/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.support.DefaultProfileValidationSupport;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.validation.FhirValidator;
import ca.uhn.fhir.validation.IValidatorModule;
import ca.uhn.fhir.validation.ResultSeverityEnum;
import ca.uhn.fhir.validation.SingleValidationMessage;
import ca.uhn.fhir.validation.ValidationResult;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hl7.fhir.common.hapi.validation.support.CachingValidationSupport;
import org.hl7.fhir.common.hapi.validation.support.CommonCodeSystemsTerminologyService;
import org.hl7.fhir.common.hapi.validation.support.InMemoryTerminologyServerValidationSupport;
import org.hl7.fhir.common.hapi.validation.support.PrePopulatedValidationSupport;
import org.hl7.fhir.common.hapi.validation.support.ValidationSupportChain;
import org.hl7.fhir.common.hapi.validation.validator.FhirInstanceValidator;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.ImplementationGuide;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.utility.ValidationProfile;

public class ResourceValidator {
    protected Repository repo;
    protected FhirContext context;
    protected FhirValidator validator;
    protected Map<String, ValidationProfile> profiles;

    public ResourceValidator(FhirContext context, Map<String, ValidationProfile> profiles, Repository repo) {
        this.repo = repo;
        this.context = context;
        this.profiles = profiles == null ? new HashMap() : profiles;
        this.setValidator();
    }

    public ResourceValidator(FhirVersionEnum version, Map<String, ValidationProfile> profiles, Repository repo) {
        this.repo = repo;
        this.context = FhirContext.forCached((FhirVersionEnum)version);
        this.profiles = profiles == null ? new HashMap() : profiles;
        this.setValidator();
    }

    protected void setValidator() {
        if (this.profiles.isEmpty()) {
            this.validator = this.context.newValidator();
        } else {
            ValidationSupportChain supportChain = new ValidationSupportChain();
            supportChain.addValidationSupport((IValidationSupport)new DefaultProfileValidationSupport(this.context));
            supportChain.addValidationSupport((IValidationSupport)new CommonCodeSystemsTerminologyService(this.context));
            supportChain.addValidationSupport((IValidationSupport)new InMemoryTerminologyServerValidationSupport(this.context));
            PrePopulatedValidationSupport profileSupport = new PrePopulatedValidationSupport(this.context);
            for (Map.Entry<String, ValidationProfile> profile : this.profiles.entrySet()) {
                ImplementationGuide ig = (ImplementationGuide)this.repo.read(ImplementationGuide.class, (IIdType)new IdType("ImplementationGuide", profile.getValue().getName()));
                if (ig == null) continue;
                for (ImplementationGuide.ImplementationGuideDefinitionResourceComponent resourceComponent : ig.getDefinition().getResource()) {
                    if (!Arrays.asList("CodeSystem", "StructureDefinition", "ValueSet").contains(resourceComponent.getReference().getReference().split("/")[0])) continue;
                    try {
                        IBaseResource resource = this.repo.read(IBaseResource.class, (IIdType)new IdType(resourceComponent.getReference().getReference()));
                        if (resource == null) continue;
                        profileSupport.addResource(resource);
                    }
                    catch (Exception exception) {}
                }
            }
            supportChain.addValidationSupport((IValidationSupport)profileSupport);
            this.validator = this.context.newValidator().registerValidatorModule((IValidatorModule)new FhirInstanceValidator((IValidationSupport)new CachingValidationSupport((IValidationSupport)supportChain)));
        }
    }

    public IBaseResource validate(IBaseResource resource) {
        return this.validate(resource, false);
    }

    public IBaseResource validate(IBaseResource resource, Boolean error) {
        ValidationResult validationResult = this.validator.validateWithResult(resource);
        List errors = validationResult.getMessages().stream().filter(m -> {
            if (m.getSeverity().compareTo((Enum)ResultSeverityEnum.ERROR) <= -1) return false;
            if (!this.profiles.entrySet().stream().flatMap(p -> ((ValidationProfile)p.getValue()).getIgnoreKeys().stream()).noneMatch(m.getMessage()::contains)) return false;
            return true;
        }).collect(Collectors.toList());
        if (errors.isEmpty()) {
            return resource;
        }
        if (Boolean.TRUE.equals(error)) {
            List messages = errors.stream().map(SingleValidationMessage::getMessage).collect(Collectors.toList());
            String issues = String.join((CharSequence)"; ", messages);
            throw new RuntimeException("Unable to validate resource. The following problems were found: " + issues);
        }
        return validationResult.toOperationOutcome();
    }
}

