/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeChildResourceBlockDefinition;
import ca.uhn.fhir.context.RuntimeResourceBlockDefinition;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.fhirpath.IFhirPath;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.opencds.cqf.cql.engine.runtime.Code;
import org.opencds.cqf.fhir.utility.Resources;

public class ValueSets {
    private ValueSets() {
    }

    public static IBase getCompose(FhirContext fhirContext, IBaseResource valueSet) {
        BaseRuntimeChildDefinition composeChild = ValueSets.getComposeDefinition(fhirContext);
        List compose = composeChild.getAccessor().getValues((IBase)valueSet);
        if (compose.isEmpty()) {
            return null;
        }
        if (compose.size() > 1) {
            throw new IllegalArgumentException("ValueSet has multiple compose definitions.");
        }
        return (IBase)compose.get(0);
    }

    public static List<IBase> getIncludes(FhirContext fhirContext, IBaseResource valueSet) {
        IBase compose = ValueSets.getCompose(fhirContext, valueSet);
        if (compose == null) {
            return null;
        }
        BaseRuntimeChildDefinition includeChild = ValueSets.getIncludeDefinition(fhirContext);
        List includeComponents = includeChild.getAccessor().getValues(compose);
        if (includeComponents.isEmpty()) {
            return null;
        }
        return includeComponents;
    }

    public static List<IBase> getExcludes(FhirContext fhirContext, IBaseResource valueSet) {
        IBase compose = ValueSets.getCompose(fhirContext, valueSet);
        if (compose == null) {
            return null;
        }
        BaseRuntimeChildDefinition excludeChild = ValueSets.getExcludeDefinition(fhirContext);
        List excludeComponents = excludeChild.getAccessor().getValues(compose);
        if (excludeComponents == null || excludeComponents.isEmpty()) {
            return null;
        }
        return excludeComponents;
    }

    public static List<IBase> getIncludeConcepts(FhirContext fhirContext, IBaseResource valueSet) {
        List<IBase> includes = ValueSets.getIncludes(fhirContext, valueSet);
        if (includes == null) {
            return null;
        }
        BaseRuntimeChildDefinition conceptChild = ValueSets.getIncludeConceptDefinition(fhirContext);
        ArrayList<IBase> concepts = new ArrayList<IBase>();
        for (IBase include : includes) {
            List currentConcepts = conceptChild.getAccessor().getValues(include);
            if (currentConcepts == null) continue;
            concepts.addAll(currentConcepts);
        }
        return concepts;
    }

    public static List<IBase> getIncludeFilters(FhirContext fhirContext, IBaseResource valueSet) {
        List<IBase> includes = ValueSets.getIncludes(fhirContext, valueSet);
        if (includes == null) {
            return null;
        }
        BaseRuntimeChildDefinition filterChild = ValueSets.getIncludeFilterDefinition(fhirContext);
        ArrayList<IBase> filters = new ArrayList<IBase>();
        for (IBase include : includes) {
            List currentFilters = filterChild.getAccessor().getValues(include);
            if (currentFilters == null) continue;
            filters.addAll(currentFilters);
        }
        return filters;
    }

    public static List<IBase> getExcludeConcepts(FhirContext fhirContext, IBaseResource valueSet) {
        List<IBase> excludes = ValueSets.getExcludes(fhirContext, valueSet);
        if (excludes == null) {
            return null;
        }
        BaseRuntimeChildDefinition conceptChild = ValueSets.getExcludeConceptDefinition(fhirContext);
        ArrayList<IBase> concepts = new ArrayList<IBase>();
        for (IBase exclude : excludes) {
            List currentConcepts = conceptChild.getAccessor().getValues(exclude);
            if (currentConcepts == null) continue;
            concepts.addAll(currentConcepts);
        }
        return concepts;
    }

    public static List<IBase> getExcludeFilters(FhirContext fhirContext, IBaseResource valueSet) {
        List<IBase> excludes = ValueSets.getExcludes(fhirContext, valueSet);
        if (excludes == null) {
            return null;
        }
        BaseRuntimeChildDefinition filterChild = ValueSets.getExcludeFilterDefinition(fhirContext);
        ArrayList<IBase> filters = new ArrayList<IBase>();
        for (IBase exclude : excludes) {
            List currentFilters = filterChild.getAccessor().getValues(exclude);
            if (currentFilters == null) continue;
            filters.addAll(currentFilters);
        }
        return filters;
    }

    public static IBase getExpansion(FhirContext fhirContext, IBaseResource valueSet) {
        BaseRuntimeChildDefinition expansionChild = ValueSets.getExpansionDefinition(fhirContext);
        List expansion = expansionChild.getAccessor().getValues((IBase)valueSet);
        if (expansion == null || expansion.isEmpty()) {
            return null;
        }
        if (expansion.size() > 1) {
            throw new IllegalArgumentException("ValueSet has multiple expansion definitions.");
        }
        return (IBase)expansion.get(0);
    }

    public static List<IBase> getContainsInExpansion(FhirContext fhirContext, IBase expansion) {
        if (expansion == null) {
            return null;
        }
        BaseRuntimeChildDefinition containsDefinition = ValueSets.getContainsDefinition(fhirContext);
        List contains = containsDefinition.getAccessor().getValues(expansion);
        if (contains == null || contains.isEmpty()) {
            return null;
        }
        return contains;
    }

    public static List<IBase> getContains(FhirContext fhirContext, IBaseResource valueSet) {
        return ValueSets.getContainsInExpansion(fhirContext, ValueSets.getExpansion(fhirContext, valueSet));
    }

    public static List<Code> getCodesInCompose(FhirContext fhirContext, IBaseResource valueSet) {
        List<IBase> includes = ValueSets.getIncludes(fhirContext, valueSet);
        if (includes == null) {
            return null;
        }
        BaseRuntimeChildDefinition conceptChild = ValueSets.getIncludeConceptDefinition(fhirContext);
        BaseRuntimeChildDefinition.IAccessor versionAccessor = ValueSets.getIncludeVersionDefinition(fhirContext).getAccessor();
        BaseRuntimeChildDefinition.IAccessor systemAccessor = ValueSets.getIncludeSystemDefinition(fhirContext).getAccessor();
        BaseRuntimeChildDefinition.IAccessor codeAccessor = ValueSets.getIncludeConceptCodeDefinition(fhirContext).getAccessor();
        BaseRuntimeChildDefinition.IAccessor displayAccessor = ValueSets.getIncludeConceptDisplayDefinition(fhirContext).getAccessor();
        ArrayList<Code> codes = new ArrayList<Code>();
        for (IBase include : includes) {
            String version = ValueSets.getStringValueFromPrimitiveAccessor(include, versionAccessor);
            String system = ValueSets.getStringValueFromPrimitiveAccessor(include, systemAccessor);
            List concepts = conceptChild.getAccessor().getValues(include);
            for (IBase c : concepts) {
                String code = ValueSets.getStringValueFromPrimitiveAccessor(c, codeAccessor);
                String display = ValueSets.getStringValueFromPrimitiveAccessor(c, displayAccessor);
                codes.add(new Code().withSystem(system).withCode(code).withDisplay(display).withVersion(version));
            }
        }
        return codes;
    }

    public static List<Code> getCodesInContains(FhirContext fhirContext, List<IBase> contains) {
        if (contains == null) {
            return null;
        }
        BaseRuntimeChildDefinition.IAccessor systemAccessor = ValueSets.getSystemDefinition(fhirContext).getAccessor();
        BaseRuntimeChildDefinition.IAccessor codeAccessor = ValueSets.getCodeDefinition(fhirContext).getAccessor();
        BaseRuntimeChildDefinition.IAccessor displayAccessor = ValueSets.getDisplayDefinition(fhirContext).getAccessor();
        BaseRuntimeChildDefinition.IAccessor versionAccessor = ValueSets.getVersionDefinition(fhirContext).getAccessor();
        ArrayList<Code> codes = new ArrayList<Code>();
        for (IBase c : contains) {
            String system = ValueSets.getStringValueFromPrimitiveAccessor(c, systemAccessor);
            String code = ValueSets.getStringValueFromPrimitiveAccessor(c, codeAccessor);
            String display = ValueSets.getStringValueFromPrimitiveAccessor(c, displayAccessor);
            String version = ValueSets.getStringValueFromPrimitiveAccessor(c, versionAccessor);
            codes.add(new Code().withSystem(system).withCode(code).withDisplay(display).withVersion(version));
        }
        return codes;
    }

    public static List<Code> getCodesInExpansion(FhirContext fhirContext, IBase expansion) {
        return ValueSets.getCodesInContains(fhirContext, ValueSets.getContainsInExpansion(fhirContext, expansion));
    }

    public static List<Code> getCodesInExpansion(FhirContext fhirContext, IBaseResource valueSet) {
        return ValueSets.getCodesInContains(fhirContext, ValueSets.getContains(fhirContext, valueSet));
    }

    public static void addCodeToExpansion(FhirContext fhirContext, IBase expansion, Code code) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        BaseRuntimeChildDefinition containsDef = ValueSets.getContainsDefinition(fhirContext);
        BaseRuntimeChildDefinition systemDef = ValueSets.getSystemDefinition(fhirContext);
        BaseRuntimeChildDefinition codeDef = ValueSets.getCodeDefinition(fhirContext);
        BaseRuntimeChildDefinition displayDef = ValueSets.getDisplayDefinition(fhirContext);
        BaseRuntimeChildDefinition versionDef = ValueSets.getVersionDefinition(fhirContext);
        Object newCode = Resources.newBackboneElement(containsDef.getChildByName("contains").getImplementingClass());
        systemDef.getMutator().addValue(newCode, (IBase)systemDef.getChildByName("system").getImplementingClass().getConstructor(String.class).newInstance(code.getSystem()));
        codeDef.getMutator().addValue(newCode, (IBase)codeDef.getChildByName("code").getImplementingClass().getConstructor(String.class).newInstance(code.getCode()));
        displayDef.getMutator().addValue(newCode, (IBase)displayDef.getChildByName("display").getImplementingClass().getConstructor(String.class).newInstance(code.getDisplay()));
        versionDef.getMutator().addValue(newCode, (IBase)versionDef.getChildByName("version").getImplementingClass().getConstructor(String.class).newInstance(code.getVersion()));
        containsDef.getMutator().addValue(expansion, newCode);
    }

    public static void setExpansionTimestamp(FhirContext fhirContext, IBase expansion, Date timeStamp) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        BaseRuntimeChildDefinition expansionChild = ValueSets.getExpansionDefinition(fhirContext);
        RuntimeResourceBlockDefinition expansionBlockChild = (RuntimeResourceBlockDefinition)expansionChild.getChildByName("expansion");
        BaseRuntimeChildDefinition timeStampChild = expansionBlockChild.getChildByName("timestamp");
        timeStampChild.getMutator().setValue(expansion, (IBase)timeStampChild.getChildByName("timestamp").getImplementingClass().getConstructor(Date.class).newInstance(timeStamp));
    }

    public static void addParameterToExpansion(FhirContext fhirContext, IBase expansion, IBaseBackboneElement parameter) {
        ValueSets.getParameterDefinition(fhirContext).getMutator().addValue(expansion, (IBase)parameter);
    }

    public static String getUrl(FhirContext fhirContext, IBaseResource valueSet) {
        BaseRuntimeChildDefinition urlDef = ValueSets.getUrlDefinition(fhirContext);
        return ValueSets.getStringValueFromPrimitiveAccessor((IBase)valueSet, urlDef.getAccessor());
    }

    public static String getId(FhirContext fhirContext, IBaseResource valueSet) {
        BaseRuntimeChildDefinition idDef = ValueSets.getIdDefinition(fhirContext);
        return ValueSets.getStringValueFromPrimitiveAccessor((IBase)valueSet, idDef.getAccessor());
    }

    private static String getStringValueFromPrimitiveAccessor(IBase value, BaseRuntimeChildDefinition.IAccessor accessor) {
        if (value == null || accessor == null) {
            return null;
        }
        List values = accessor.getValues(value);
        if (values == null || values.isEmpty()) {
            return null;
        }
        if (values.size() > 1) {
            throw new IllegalArgumentException("More than one value returned while attempting to access primitive value.");
        }
        IBase baseValue = (IBase)values.get(0);
        if (!(baseValue instanceof IPrimitiveType)) {
            throw new IllegalArgumentException("Non-primitive value encountered while trying to access primitive value.");
        }
        return ((IPrimitiveType)baseValue).getValueAsString();
    }

    private static BaseRuntimeChildDefinition getComposeDefinition(FhirContext fhirContext) {
        RuntimeResourceDefinition def = fhirContext.getResourceDefinition("ValueSet");
        return def.getChildByName("compose");
    }

    private static BaseRuntimeChildDefinition getIncludeDefinition(FhirContext fhirContext) {
        BaseRuntimeChildDefinition composeChild = ValueSets.getComposeDefinition(fhirContext);
        return ValueSets.getIncludeDefinition(composeChild);
    }

    private static BaseRuntimeChildDefinition getIncludeDefinition(BaseRuntimeChildDefinition composeChild) {
        RuntimeResourceBlockDefinition composeBlockChild = (RuntimeResourceBlockDefinition)composeChild.getChildByName("compose");
        BaseRuntimeChildDefinition includeChild = composeBlockChild.getChildByName("include");
        return includeChild;
    }

    private static BaseRuntimeChildDefinition getIncludeConceptDefinition(FhirContext fhirContext) {
        BaseRuntimeChildDefinition includeChild = ValueSets.getIncludeDefinition(fhirContext);
        RuntimeResourceBlockDefinition includeBlockChild = (RuntimeResourceBlockDefinition)includeChild.getChildByName("include");
        return ValueSets.getConceptDefinition(includeBlockChild);
    }

    private static BaseRuntimeChildDefinition getIncludeFilterDefinition(FhirContext fhirContext) {
        BaseRuntimeChildDefinition includeChild = ValueSets.getIncludeDefinition(fhirContext);
        RuntimeResourceBlockDefinition includeBlockChild = (RuntimeResourceBlockDefinition)includeChild.getChildByName("include");
        return ValueSets.getFilterDefinition(includeBlockChild);
    }

    private static RuntimeChildResourceBlockDefinition getConceptDefinition(RuntimeResourceBlockDefinition includeOrExcludeChild) {
        return (RuntimeChildResourceBlockDefinition)includeOrExcludeChild.getChildByName("concept");
    }

    private static RuntimeChildResourceBlockDefinition getFilterDefinition(RuntimeResourceBlockDefinition includeOrExcludeChild) {
        return (RuntimeChildResourceBlockDefinition)includeOrExcludeChild.getChildByName("filter");
    }

    private static BaseRuntimeChildDefinition getExcludeDefinition(FhirContext fhirContext) {
        BaseRuntimeChildDefinition composeChild = ValueSets.getComposeDefinition(fhirContext);
        return ValueSets.getExcludeDefinition(composeChild);
    }

    private static BaseRuntimeChildDefinition getExcludeDefinition(BaseRuntimeChildDefinition composeChild) {
        RuntimeResourceBlockDefinition composeBlockChild = (RuntimeResourceBlockDefinition)composeChild.getChildByName("compose");
        BaseRuntimeChildDefinition excludeChild = composeBlockChild.getChildByName("exclude");
        return excludeChild;
    }

    private static BaseRuntimeChildDefinition getExcludeConceptDefinition(FhirContext fhirContext) {
        BaseRuntimeChildDefinition excludeChild = ValueSets.getExcludeDefinition(fhirContext);
        RuntimeResourceBlockDefinition excludeBlockChild = (RuntimeResourceBlockDefinition)excludeChild.getChildByName("exclude");
        return ValueSets.getConceptDefinition(excludeBlockChild);
    }

    private static BaseRuntimeChildDefinition getExcludeFilterDefinition(FhirContext fhirContext) {
        BaseRuntimeChildDefinition excludeChild = ValueSets.getExcludeDefinition(fhirContext);
        RuntimeResourceBlockDefinition excludeBlockChild = (RuntimeResourceBlockDefinition)excludeChild.getChildByName("exclude");
        return ValueSets.getFilterDefinition(excludeBlockChild);
    }

    private static BaseRuntimeChildDefinition getExpansionDefinition(FhirContext fhirContext) {
        RuntimeResourceDefinition def = fhirContext.getResourceDefinition("ValueSet");
        return def.getChildByName("expansion");
    }

    private static BaseRuntimeChildDefinition getParameterDefinition(FhirContext fhirContext) {
        BaseRuntimeChildDefinition expansionChild = ValueSets.getExpansionDefinition(fhirContext);
        RuntimeResourceBlockDefinition expansionBlockChild = (RuntimeResourceBlockDefinition)expansionChild.getChildByName("expansion");
        return ValueSets.getParameterDefinition(expansionBlockChild);
    }

    private static BaseRuntimeChildDefinition getParameterDefinition(RuntimeResourceBlockDefinition expansionChild) {
        return expansionChild.getChildByName("parameter");
    }

    private static BaseRuntimeChildDefinition getContainsDefinition(FhirContext fhirContext) {
        BaseRuntimeChildDefinition expansionChild = ValueSets.getExpansionDefinition(fhirContext);
        RuntimeResourceBlockDefinition expansionBlockChild = (RuntimeResourceBlockDefinition)expansionChild.getChildByName("expansion");
        return ValueSets.getContainsDefinition(expansionBlockChild);
    }

    private static BaseRuntimeChildDefinition getContainsDefinition(RuntimeResourceBlockDefinition expansionChild) {
        return expansionChild.getChildByName("contains");
    }

    private static BaseRuntimeChildDefinition getSystemDefinition(FhirContext fhirContext) {
        BaseRuntimeChildDefinition containsDefinition = ValueSets.getContainsDefinition(fhirContext);
        RuntimeResourceBlockDefinition containsBlockDefinition = (RuntimeResourceBlockDefinition)containsDefinition.getChildByName("contains");
        return containsBlockDefinition.getChildByName("system");
    }

    private static BaseRuntimeChildDefinition getVersionDefinition(FhirContext fhirContext) {
        BaseRuntimeChildDefinition containsDefinition = ValueSets.getContainsDefinition(fhirContext);
        RuntimeResourceBlockDefinition containsBlockDefinition = (RuntimeResourceBlockDefinition)containsDefinition.getChildByName("contains");
        return containsBlockDefinition.getChildByName("version");
    }

    private static BaseRuntimeChildDefinition getCodeDefinition(FhirContext fhirContext) {
        BaseRuntimeChildDefinition containsDefinition = ValueSets.getContainsDefinition(fhirContext);
        RuntimeResourceBlockDefinition containsBlockDefinition = (RuntimeResourceBlockDefinition)containsDefinition.getChildByName("contains");
        return containsBlockDefinition.getChildByName("code");
    }

    private static BaseRuntimeChildDefinition getDisplayDefinition(FhirContext fhirContext) {
        BaseRuntimeChildDefinition containsDefinition = ValueSets.getContainsDefinition(fhirContext);
        RuntimeResourceBlockDefinition containsBlockDefinition = (RuntimeResourceBlockDefinition)containsDefinition.getChildByName("contains");
        return containsBlockDefinition.getChildByName("display");
    }

    private static BaseRuntimeChildDefinition getIncludeConceptCodeDefinition(FhirContext fhirContext) {
        BaseRuntimeChildDefinition includeConceptDefinition = ValueSets.getIncludeConceptDefinition(fhirContext);
        RuntimeResourceBlockDefinition containsBlockDefinition = (RuntimeResourceBlockDefinition)includeConceptDefinition.getChildByName("concept");
        return containsBlockDefinition.getChildByName("code");
    }

    private static BaseRuntimeChildDefinition getIncludeConceptDisplayDefinition(FhirContext fhirContext) {
        BaseRuntimeChildDefinition includeConceptDefinition = ValueSets.getIncludeConceptDefinition(fhirContext);
        RuntimeResourceBlockDefinition containsBlockDefinition = (RuntimeResourceBlockDefinition)includeConceptDefinition.getChildByName("concept");
        return containsBlockDefinition.getChildByName("display");
    }

    private static BaseRuntimeChildDefinition getIncludeSystemDefinition(FhirContext fhirContext) {
        BaseRuntimeChildDefinition includeDefinition = ValueSets.getIncludeDefinition(fhirContext);
        RuntimeResourceBlockDefinition includeBlockDefinition = (RuntimeResourceBlockDefinition)includeDefinition.getChildByName("include");
        return includeBlockDefinition.getChildByName("system");
    }

    private static BaseRuntimeChildDefinition getIncludeVersionDefinition(FhirContext fhirContext) {
        BaseRuntimeChildDefinition includeDefinition = ValueSets.getIncludeDefinition(fhirContext);
        RuntimeResourceBlockDefinition includeBlockDefinition = (RuntimeResourceBlockDefinition)includeDefinition.getChildByName("include");
        return includeBlockDefinition.getChildByName("version");
    }

    private static BaseRuntimeChildDefinition getUrlDefinition(FhirContext fhirContext) {
        RuntimeResourceDefinition def = fhirContext.getResourceDefinition("ValueSet");
        return def.getChildByName("url");
    }

    private static BaseRuntimeChildDefinition getIdDefinition(FhirContext fhirContext) {
        RuntimeResourceDefinition def = fhirContext.getResourceDefinition("ValueSet");
        return def.getChildByName("id");
    }

    public static <T extends IBase> List<IBase> getExpansionParameters(IBase expansion, IFhirPath fhirPath, String filterExpression) {
        String expression = String.format("parameter%s", filterExpression);
        return fhirPath.evaluate(expansion, expression, IBase.class);
    }
}

