/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.adapter;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.opencds.cqf.fhir.utility.adapter.AttachmentAdapter;
import org.opencds.cqf.fhir.utility.adapter.EndpointAdapter;
import org.opencds.cqf.fhir.utility.adapter.KnowledgeArtifactAdapter;
import org.opencds.cqf.fhir.utility.adapter.LibraryAdapter;
import org.opencds.cqf.fhir.utility.adapter.ParametersAdapter;
import org.opencds.cqf.fhir.utility.adapter.ParametersParameterComponentAdapter;
import org.opencds.cqf.fhir.utility.adapter.ResourceAdapter;

public interface AdapterFactory {
    public static AdapterFactory forFhirContext(FhirContext fhirContext) {
        return AdapterFactory.forFhirVersion(fhirContext.getVersion().getVersion());
    }

    public static AdapterFactory forFhirVersion(FhirVersionEnum fhirVersion) {
        switch (fhirVersion) {
            case DSTU3: {
                return new org.opencds.cqf.fhir.utility.adapter.dstu3.AdapterFactory();
            }
            case R4: {
                return new org.opencds.cqf.fhir.utility.adapter.r4.AdapterFactory();
            }
            case R5: {
                return new org.opencds.cqf.fhir.utility.adapter.r5.AdapterFactory();
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported FHIR version: %s", fhirVersion.toString()));
    }

    public static ResourceAdapter createAdapterForResource(IBaseResource resource) {
        return AdapterFactory.forFhirVersion(resource.getStructureFhirVersionEnum()).createResource(resource);
    }

    public ResourceAdapter createResource(IBaseResource var1);

    public KnowledgeArtifactAdapter createKnowledgeArtifactAdapter(IDomainResource var1);

    public LibraryAdapter createLibrary(IBaseResource var1);

    public AttachmentAdapter createAttachment(ICompositeType var1);

    public ParametersAdapter createParameters(IBaseParameters var1);

    public ParametersParameterComponentAdapter createParametersParameters(IBaseBackboneElement var1);

    public EndpointAdapter createEndpoint(IBaseResource var1);
}

