/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.adapter;

import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.opencds.cqf.cql.engine.model.ModelResolver;
import org.opencds.cqf.fhir.utility.adapter.ResourceAdapter;
import org.opencds.cqf.fhir.utility.model.FhirModelResolverCache;

public abstract class BaseResourceAdapter
implements ResourceAdapter {
    protected final FhirContext fhirContext;
    protected final BaseRuntimeElementDefinition<?> elementDefinition;
    protected final IBaseResource resource;
    protected final ModelResolver modelResolver;

    public BaseResourceAdapter(IBaseResource resource) {
        if (resource == null) {
            throw new IllegalArgumentException("resource can not be null");
        }
        this.resource = resource;
        this.fhirContext = FhirContext.forCached((FhirVersionEnum)resource.getStructureFhirVersionEnum());
        this.elementDefinition = this.fhirContext.getElementDefinition(this.resource.getClass());
        this.modelResolver = FhirModelResolverCache.resolverForVersion(this.fhirContext.getVersion().getVersion());
    }

    @Override
    public FhirContext fhirContext() {
        return this.fhirContext;
    }

    @Override
    public ModelResolver getModelResolver() {
        return this.modelResolver;
    }

    @Override
    public IBaseResource get() {
        return this.resource;
    }
}

