/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.adapter.dstu3;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.dstu3.model.ElementDefinition;
import org.hl7.fhir.dstu3.model.MetadataResource;
import org.hl7.fhir.dstu3.model.StructureDefinition;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.opencds.cqf.fhir.utility.adapter.DependencyInfo;
import org.opencds.cqf.fhir.utility.adapter.IDependencyInfo;
import org.opencds.cqf.fhir.utility.adapter.IStructureDefinitionAdapter;
import org.opencds.cqf.fhir.utility.adapter.dstu3.KnowledgeArtifactAdapter;

public class StructureDefinitionAdapter
extends KnowledgeArtifactAdapter
implements IStructureDefinitionAdapter {
    public StructureDefinitionAdapter(IDomainResource structureDefinition) {
        super(structureDefinition);
        if (!(structureDefinition instanceof StructureDefinition)) {
            throw new IllegalArgumentException("resource passed as planDefinition argument is not a StructureDefinition resource");
        }
    }

    public StructureDefinitionAdapter(StructureDefinition structureDefinition) {
        super((MetadataResource)structureDefinition);
    }

    protected StructureDefinition getStructureDefinition() {
        return (StructureDefinition)this.resource;
    }

    @Override
    public List<IDependencyInfo> getDependencies() {
        ArrayList<IDependencyInfo> references = new ArrayList<IDependencyInfo>();
        String referenceSource = this.getReferenceSource();
        this.addProfileReferences(references, referenceSource);
        if (this.get().hasBaseDefinition()) {
            references.add(new DependencyInfo(referenceSource, this.get().getBaseDefinition(), this.get().getBaseDefinitionElement().getExtension(), reference -> this.get().setBaseDefinition(reference)));
        }
        this.get().getDifferential().getElement().forEach(element -> this.getDependenciesOfDifferential((ElementDefinition)element, (List<IDependencyInfo>)references, referenceSource));
        return references;
    }

    private void getDependenciesOfDifferential(ElementDefinition element, List<IDependencyInfo> references, String referenceSource) {
        element.getType().forEach(type -> {
            if (type.hasProfile()) {
                references.add(new DependencyInfo(referenceSource, type.getProfile(), type.getProfileElement().getExtension(), arg_0 -> ((ElementDefinition.TypeRefComponent)type).setProfile(arg_0)));
            }
            if (type.hasTargetProfile()) {
                references.add(new DependencyInfo(referenceSource, type.getTargetProfile(), type.getTargetProfileElement().getExtension(), arg_0 -> ((ElementDefinition.TypeRefComponent)type).setTargetProfile(arg_0)));
            }
        });
        if (element.getBinding().hasValueSet()) {
            references.add(new DependencyInfo(referenceSource, element.getBinding().getValueSet().primitiveValue(), element.getBinding().getExtension(), reference -> element.getBinding().setValueSet((Type)new UriType(reference))));
        }
    }

    @Override
    public StructureDefinition get() {
        return this.getStructureDefinition();
    }

    public StructureDefinition copy() {
        return this.get().copy();
    }
}

