/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.adapter.r4;

import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.r4.model.Endpoint;
import org.hl7.fhir.r4.model.Library;
import org.hl7.fhir.r4.model.Measure;
import org.hl7.fhir.r4.model.MetadataResource;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.PlanDefinition;
import org.hl7.fhir.r4.model.Questionnaire;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r4.model.ValueSet;
import org.opencds.cqf.fhir.utility.adapter.EndpointAdapter;
import org.opencds.cqf.fhir.utility.adapter.KnowledgeArtifactAdapter;
import org.opencds.cqf.fhir.utility.adapter.ParametersAdapter;
import org.opencds.cqf.fhir.utility.adapter.ResourceAdapter;
import org.opencds.cqf.fhir.utility.adapter.r4.AttachmentAdapter;
import org.opencds.cqf.fhir.utility.adapter.r4.LibraryAdapter;
import org.opencds.cqf.fhir.utility.adapter.r4.MeasureAdapter;
import org.opencds.cqf.fhir.utility.adapter.r4.ParametersParameterComponentAdapter;
import org.opencds.cqf.fhir.utility.adapter.r4.PlanDefinitionAdapter;
import org.opencds.cqf.fhir.utility.adapter.r4.QuestionnaireAdapter;
import org.opencds.cqf.fhir.utility.adapter.r4.StructureDefinitionAdapter;
import org.opencds.cqf.fhir.utility.adapter.r4.ValueSetAdapter;

public class AdapterFactory
implements org.opencds.cqf.fhir.utility.adapter.AdapterFactory {
    @Override
    public ResourceAdapter createResource(IBaseResource resource) {
        if (resource instanceof MetadataResource) {
            return this.createKnowledgeArtifactAdapter((IDomainResource)resource);
        }
        if (resource instanceof Endpoint) {
            return this.createEndpoint(resource);
        }
        if (resource instanceof Parameters) {
            return this.createParameters((IBaseParameters)((Parameters)resource));
        }
        return new org.opencds.cqf.fhir.utility.adapter.r4.ResourceAdapter(resource);
    }

    @Override
    public KnowledgeArtifactAdapter createKnowledgeArtifactAdapter(IDomainResource resource) {
        KnowledgeArtifactAdapter adapter;
        if (resource instanceof Library) {
            adapter = this.createLibrary((IBaseResource)resource);
        } else if (resource instanceof Measure) {
            adapter = new MeasureAdapter((Measure)resource);
        } else if (resource instanceof PlanDefinition) {
            adapter = new PlanDefinitionAdapter((PlanDefinition)resource);
        } else if (resource instanceof Questionnaire) {
            adapter = new QuestionnaireAdapter((Questionnaire)resource);
        } else if (resource instanceof StructureDefinition) {
            adapter = new StructureDefinitionAdapter((StructureDefinition)resource);
        } else if (resource instanceof ValueSet) {
            adapter = new ValueSetAdapter((ValueSet)resource);
        } else if (resource != null && resource instanceof MetadataResource) {
            adapter = new org.opencds.cqf.fhir.utility.adapter.r4.KnowledgeArtifactAdapter((MetadataResource)resource);
        } else {
            throw new UnprocessableEntityException(String.format("Resource must be instance of %s", MetadataResource.class.getName()));
        }
        return adapter;
    }

    @Override
    public org.opencds.cqf.fhir.utility.adapter.LibraryAdapter createLibrary(IBaseResource library) {
        return new LibraryAdapter((IDomainResource)library);
    }

    @Override
    public org.opencds.cqf.fhir.utility.adapter.AttachmentAdapter createAttachment(ICompositeType attachment) {
        return new AttachmentAdapter(attachment);
    }

    @Override
    public ParametersAdapter createParameters(IBaseParameters parameters) {
        return new org.opencds.cqf.fhir.utility.adapter.r4.ParametersAdapter((IBaseResource)parameters);
    }

    @Override
    public org.opencds.cqf.fhir.utility.adapter.ParametersParameterComponentAdapter createParametersParameters(IBaseBackboneElement parametersParametersComponent) {
        return new ParametersParameterComponentAdapter(parametersParametersComponent);
    }

    @Override
    public EndpointAdapter createEndpoint(IBaseResource endpoint) {
        return new org.opencds.cqf.fhir.utility.adapter.r4.EndpointAdapter(endpoint);
    }
}

