/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.adapter.r5;

import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.MetadataResource;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.RelatedArtifact;
import org.opencds.cqf.fhir.utility.adapter.IDependencyInfo;
import org.opencds.cqf.fhir.utility.adapter.r5.ResourceAdapter;

public class KnowledgeArtifactAdapter
extends ResourceAdapter
implements org.opencds.cqf.fhir.utility.adapter.KnowledgeArtifactAdapter {
    MetadataResource adaptedResource;

    public KnowledgeArtifactAdapter(IDomainResource resource) {
        super((IBaseResource)resource);
        if (!(resource instanceof MetadataResource)) {
            throw new IllegalArgumentException("resource passed as resource argument is not a MetadataResource resource");
        }
        this.adaptedResource = (MetadataResource)resource;
    }

    public KnowledgeArtifactAdapter(MetadataResource resource) {
        super((IBaseResource)resource);
        this.adaptedResource = resource;
    }

    @Override
    public MetadataResource get() {
        return this.adaptedResource;
    }

    public MetadataResource copy() {
        return this.get().copy();
    }

    @Override
    public void setDateElement(IPrimitiveType<Date> date) {
        if (date != null && !(date instanceof DateTimeType)) {
            throw new UnprocessableEntityException("Date must be " + DateTimeType.class.getName());
        }
        org.opencds.cqf.fhir.utility.adapter.KnowledgeArtifactAdapter.super.setDateElement(date);
    }

    @Override
    public void setEffectivePeriod(ICompositeType effectivePeriod) {
        if (effectivePeriod != null && !(effectivePeriod instanceof Period)) {
            throw new UnprocessableEntityException("EffectivePeriod must be a valid " + Period.class.getName());
        }
        org.opencds.cqf.fhir.utility.adapter.KnowledgeArtifactAdapter.super.setEffectivePeriod(effectivePeriod);
    }

    @Override
    public List<IDependencyInfo> getDependencies() {
        ArrayList<IDependencyInfo> references = new ArrayList<IDependencyInfo>();
        String referenceSource = this.getReferenceSource();
        this.addProfileReferences(references, referenceSource);
        return references;
    }

    public List<RelatedArtifact> getRelatedArtifactsOfType(String codeString) {
        RelatedArtifact.RelatedArtifactType type;
        try {
            type = RelatedArtifact.RelatedArtifactType.fromCode((String)codeString);
        }
        catch (FHIRException e) {
            throw new UnprocessableEntityException("Invalid related artifact code");
        }
        return this.getRelatedArtifact().stream().map(ra -> (RelatedArtifact)ra).filter(ra -> ra.getType() == type).collect(Collectors.toList());
    }

    @Override
    public String getStatus() {
        return this.get().getStatus() == null ? null : this.get().getStatus().toCode();
    }

    @Override
    public void setStatus(String statusCodeString) {
        Enumerations.PublicationStatus status;
        try {
            status = Enumerations.PublicationStatus.fromCode((String)statusCodeString);
        }
        catch (FHIRException e) {
            throw new UnprocessableEntityException("Invalid status code");
        }
        this.get().setStatus(status);
    }

    @Override
    public <T extends ICompositeType & IBaseHasExtensions> void setRelatedArtifact(List<T> relatedArtifacts) throws UnprocessableEntityException {
        org.opencds.cqf.fhir.utility.adapter.KnowledgeArtifactAdapter.super.setRelatedArtifact(relatedArtifacts.stream().map(ra -> {
            try {
                return (RelatedArtifact)ra;
            }
            catch (ClassCastException e) {
                throw new UnprocessableEntityException("All related artifacts must be of type " + RelatedArtifact.class.getName());
            }
        }).collect(Collectors.toList()));
    }
}

