/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.behavior;

import com.google.common.base.Preconditions;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.opencds.cqf.fhir.utility.Ids;
import org.opencds.cqf.fhir.utility.behavior.FhirContextUser;

public interface ResourceCreator
extends FhirContextUser {
    default public <T extends IBaseResource, I extends IIdType> T newResource(I id) {
        Preconditions.checkNotNull(id, (Object)"id is required");
        Preconditions.checkArgument((id.getResourceType() != null ? 1 : 0) != 0, (Object)"id must have a resourceType");
        IBaseResource newResource = (IBaseResource)this.getFhirContext().getResourceDefinition(id.getResourceType()).newInstance();
        newResource.setId(id);
        return (T)newResource;
    }

    default public <T extends IBaseResource> T newResource(Class<T> resourceClass, String idPart) {
        Preconditions.checkNotNull(resourceClass);
        Preconditions.checkNotNull((Object)idPart);
        T newResource = this.newResource(resourceClass);
        Object id = Ids.newId(this.getFhirContext(), newResource.fhirType(), idPart);
        newResource.setId(id);
        return newResource;
    }

    default public <T extends IBaseResource> T newResource(Class<T> resourceClass) {
        Preconditions.checkNotNull(resourceClass);
        return (T)((IBaseResource)this.getFhirContext().getResourceDefinition(resourceClass).newInstance());
    }

    default public <T extends IBaseResource> T newResource(String resourceType) {
        Preconditions.checkNotNull((Object)resourceType);
        return (T)((IBaseResource)this.getFhirContext().getResourceDefinition(resourceType).newInstance());
    }
}

