/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.builder;

import com.google.common.base.Preconditions;
import java.util.Date;
import org.hl7.fhir.dstu3.model.Bundle;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r5.model.Bundle;
import org.opencds.cqf.fhir.utility.builder.BaseResourceBuilder;

public class BundleBuilder<T extends IBaseBundle>
extends BaseResourceBuilder<BundleBuilder<T>, T> {
    private String type;
    private Date timestamp = new Date();

    public BundleBuilder(Class<T> resourceClass) {
        super(resourceClass);
    }

    public BundleBuilder(Class<T> resourceClass, String id) {
        super(resourceClass, id);
    }

    public BundleBuilder(Class<T> resourceClass, String id, String type) {
        this(resourceClass, id);
        Preconditions.checkNotNull((Object)type);
        this.type = type;
    }

    public BundleBuilder<T> withType(String type) {
        Preconditions.checkNotNull((Object)type);
        this.type = type;
        return this;
    }

    public BundleBuilder<T> withTimestamp(Date timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Override
    public T build() {
        Preconditions.checkNotNull((Object)this.type);
        return (T)((IBaseBundle)super.build());
    }

    @Override
    protected void initializeDstu3(T resource) {
        super.initializeDstu3(resource);
        Bundle bundle = (Bundle)resource;
        bundle.setType(Bundle.BundleType.valueOf((String)this.type));
        bundle.setIdentifier(new Identifier().setSystem((String)this.getIdentifier().getKey()).setValue((String)this.getIdentifier().getValue()));
    }

    @Override
    protected void initializeR4(T resource) {
        super.initializeR4(resource);
        org.hl7.fhir.r4.model.Bundle bundle = (org.hl7.fhir.r4.model.Bundle)resource;
        bundle.setType(Bundle.BundleType.valueOf((String)this.type));
        bundle.setIdentifier(new org.hl7.fhir.r4.model.Identifier().setSystem((String)this.getIdentifier().getKey()).setValue((String)this.getIdentifier().getValue()));
        bundle.setTimestamp(this.timestamp);
    }

    @Override
    protected void initializeR5(T resource) {
        super.initializeR5(resource);
        org.hl7.fhir.r5.model.Bundle bundle = (org.hl7.fhir.r5.model.Bundle)resource;
        bundle.setType(Bundle.BundleType.valueOf((String)this.type));
        bundle.setIdentifier(new org.hl7.fhir.r5.model.Identifier().setSystem((String)this.getIdentifier().getKey()).setValue((String)this.getIdentifier().getValue()));
        bundle.setTimestamp(this.timestamp);
    }
}

