/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.builder;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hl7.fhir.dstu3.model.Composition;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.Composition;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r5.model.Composition;
import org.hl7.fhir.r5.model.Narrative;
import org.opencds.cqf.fhir.utility.builder.BaseBackboneElementBuilder;
import org.opencds.cqf.fhir.utility.builder.NarrativeSettings;

public class CompositionSectionComponentBuilder<T extends IBaseBackboneElement>
extends BaseBackboneElementBuilder<CompositionSectionComponentBuilder<T>, T> {
    private String title;
    private String focus;
    private List<String> entries;
    private NarrativeSettings text;

    public CompositionSectionComponentBuilder(Class<T> resourceClass) {
        super(resourceClass);
    }

    public CompositionSectionComponentBuilder(Class<T> resourceClass, String id) {
        super(resourceClass, id);
    }

    public CompositionSectionComponentBuilder(Class<T> resourceClass, String id, String focus, String entry) {
        this(resourceClass, id);
        Preconditions.checkNotNull((Object)focus);
        Preconditions.checkNotNull((Object)entry);
        this.focus = focus;
        this.addEntry(entry);
    }

    private void addEntry(String entry) {
        if (this.entries == null) {
            this.entries = new ArrayList<String>();
        }
        this.entries.add(entry);
    }

    private List<String> getEntries() {
        if (this.entries == null) {
            return Collections.emptyList();
        }
        return this.entries;
    }

    public CompositionSectionComponentBuilder<T> withTitle(String title) {
        Preconditions.checkNotNull((Object)title);
        this.title = title;
        return this;
    }

    public CompositionSectionComponentBuilder<T> withFocus(String focus) {
        Preconditions.checkNotNull((Object)focus);
        this.focus = focus;
        return this;
    }

    public CompositionSectionComponentBuilder<T> withEntry(String entry) {
        Preconditions.checkNotNull((Object)entry);
        this.addEntry(entry);
        return this;
    }

    public CompositionSectionComponentBuilder<T> withText(NarrativeSettings text) {
        Preconditions.checkNotNull((Object)text);
        this.text = text;
        return this;
    }

    @Override
    public T build() {
        Preconditions.checkNotNull((Object)this.focus);
        Preconditions.checkNotNull(this.entries);
        Preconditions.checkArgument((!this.entries.isEmpty() ? 1 : 0) != 0);
        return super.build();
    }

    @Override
    protected void initializeDstu3(T resource) {
        super.initializeDstu3(resource);
        Composition.SectionComponent section = (Composition.SectionComponent)resource;
        section.setTitle(this.title).setId(this.getId());
        this.getEntries().forEach(entry -> section.addEntry(new org.hl7.fhir.dstu3.model.Reference(entry)));
        if (this.text != null) {
            org.hl7.fhir.dstu3.model.Narrative narrative = new org.hl7.fhir.dstu3.model.Narrative();
            narrative.setStatusAsString(this.text.getStatus());
            narrative.setDivAsString(this.text.getText());
            section.setText(narrative);
        }
    }

    @Override
    protected void initializeR4(T resource) {
        super.initializeR4(resource);
        Composition.SectionComponent section = (Composition.SectionComponent)resource;
        section.setFocus(new Reference(this.focus)).setTitle(this.title).setId(this.getId());
        this.getEntries().forEach(entry -> section.addEntry(new Reference(entry)));
        if (this.text != null) {
            org.hl7.fhir.r4.model.Narrative narrative = new org.hl7.fhir.r4.model.Narrative();
            narrative.setStatusAsString(this.text.getStatus());
            narrative.setDivAsString(this.text.getText());
            section.setText(narrative);
        }
    }

    @Override
    protected void initializeR5(T resource) {
        super.initializeR5(resource);
        Composition.SectionComponent section = (Composition.SectionComponent)resource;
        section.setFocus(new org.hl7.fhir.r5.model.Reference(this.focus)).setTitle(this.title).setId(this.getId());
        this.getEntries().forEach(entry -> section.addEntry(new org.hl7.fhir.r5.model.Reference(entry)));
        if (this.text != null) {
            Narrative narrative = new Narrative();
            narrative.setStatusAsString(this.text.getStatus());
            narrative.setDivAsString(this.text.getText());
            section.setText(narrative);
        }
    }
}

