/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.client;

import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.rest.client.api.IHttpRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AdditionalRequestHeadersInterceptor {
    private final Map<String, List<String>> additionalHttpHeaders = new HashMap<String, List<String>>();

    public AdditionalRequestHeadersInterceptor() {
    }

    public AdditionalRequestHeadersInterceptor(Map<String, List<String>> headers) {
        this();
        if (headers != null) {
            this.additionalHttpHeaders.putAll(headers);
        }
    }

    public void addHeaderValue(String headerName, String headerValue) {
        Objects.requireNonNull(headerName, "headerName cannot be null");
        Objects.requireNonNull(headerValue, "headerValue cannot be null");
        this.getHeaderValues(headerName).add(headerValue);
    }

    public void addAllHeaderValues(String headerName, List<String> headerValues) {
        Objects.requireNonNull(headerName, "headerName cannot be null");
        Objects.requireNonNull(headerValues, "headerValues cannot be null");
        this.getHeaderValues(headerName).addAll(headerValues);
    }

    private List<String> getHeaderValues(String headerName) {
        return this.additionalHttpHeaders.computeIfAbsent(headerName, x -> new ArrayList());
    }

    @Hook(value=Pointcut.CLIENT_REQUEST)
    public void interceptRequest(IHttpRequest request) {
        for (Map.Entry<String, List<String>> header : this.additionalHttpHeaders.entrySet()) {
            for (String headerValue : header.getValue()) {
                if (headerValue == null) continue;
                request.addHeader(header.getKey(), headerValue);
            }
        }
    }
}

