/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.matcher;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.fhirpath.IFhirPath;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.param.DateParam;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.ReferenceParam;
import ca.uhn.fhir.rest.param.StringParam;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.param.TokenParamModifier;
import ca.uhn.fhir.rest.param.UriParam;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.NotImplementedException;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseEnumeration;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public interface ResourceMatcher {
    public static final Map<String, RuntimeSearchParam> customSearchParams = new HashMap<String, RuntimeSearchParam>();

    public IFhirPath getEngine();

    public FhirContext getContext();

    public Map<SPPathKey, IFhirPath.IParsedExpression> getPathCache();

    default public void addCustomParameter(RuntimeSearchParam searchParam) {
        customSearchParams.put(searchParam.getName(), searchParam);
    }

    default public Map<String, RuntimeSearchParam> getCustomParameters() {
        return customSearchParams;
    }

    default public boolean matches(String name, List<IQueryParameterType> params, IBaseResource resource) {
        boolean match = true;
        FhirContext context = this.getContext();
        RuntimeSearchParam s = context.getResourceDefinition(resource).getSearchParam(name);
        if (s == null) {
            s = this.getCustomParameters().get(name);
        }
        if (s == null) {
            throw new RuntimeException(String.format("The SearchParameter %s for Resource %s is not supported.", name, resource.fhirType()));
        }
        String path = s.getPath();
        if (path.isEmpty() && name.startsWith("_")) {
            path = name.substring(1);
        }
        List pathResult = null;
        try {
            IFhirPath.IParsedExpression parsed = this.getPathCache().computeIfAbsent(new SPPathKey(resource.fhirType(), path), p -> {
                try {
                    return this.getEngine().parse(p.path());
                }
                catch (Exception e) {
                    throw new RuntimeException(String.format("Parsing SearchParameter %s for Resource %s resulted in an error.", name, resource.fhirType()), e);
                }
            });
            pathResult = this.getEngine().evaluate((IBase)resource, parsed, IBase.class);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Evaluating SearchParameter %s for Resource %s resulted in an error.", name, resource.fhirType()), e);
        }
        if (pathResult == null || pathResult.isEmpty()) {
            return false;
        }
        for (IQueryParameterType param : params) {
            for (IBase r : pathResult) {
                if (param instanceof ReferenceParam) {
                    match = this.isMatchReference(param, r);
                } else if (param instanceof DateParam) {
                    match = this.isMatchDate((DateParam)param, r);
                } else if (param instanceof TokenParam) {
                    match = this.isMatchToken((TokenParam)param, r);
                    if (!match) {
                        List<TokenParam> codes = this.getCodes(r);
                        match = this.isMatchCoding((TokenParam)param, r, codes);
                    }
                } else if (param instanceof UriParam) {
                    match = this.isMatchUri((UriParam)param, r);
                } else if (param instanceof StringParam) {
                    match = this.isMatchString((StringParam)param, r);
                } else {
                    throw new NotImplementedException("Resource matching not implemented for search params of type " + param.getClass().getSimpleName());
                }
                if (!match) continue;
                return true;
            }
        }
        return false;
    }

    default public boolean isMatchReference(IQueryParameterType param, IBase pathResult) {
        if (pathResult instanceof IBaseReference) {
            return ((IBaseReference)pathResult).getReferenceElement().getValue().equals(((ReferenceParam)param).getValue());
        }
        if (pathResult instanceof IPrimitiveType) {
            return ((IPrimitiveType)pathResult).getValueAsString().equals(((ReferenceParam)param).getValue());
        }
        if (pathResult instanceof Iterable) {
            for (Object element : (Iterable)pathResult) {
                if (element instanceof IBaseReference && ((IBaseReference)element).getReferenceElement().getValue().equals(((ReferenceParam)param).getValue())) {
                    return true;
                }
                if (!(element instanceof IPrimitiveType) || !((IPrimitiveType)element).getValueAsString().equals(((ReferenceParam)param).getValue())) continue;
                return true;
            }
        } else {
            throw new UnsupportedOperationException("Expected Reference element, found " + pathResult.getClass().getSimpleName());
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public boolean isMatchDate(DateParam param, IBase pathResult) {
        DateRangeParam dateRange;
        if (pathResult instanceof IPrimitiveType) {
            Object result = ((IPrimitiveType)pathResult).getValue();
            if (!(result instanceof Date)) throw new UnsupportedOperationException("Expected date, found " + pathResult.getClass().getSimpleName());
            dateRange = new DateRangeParam((Date)result, (Date)result);
            return this.matchesDateBounds(dateRange, new DateRangeParam(param));
        } else {
            if (!(pathResult instanceof ICompositeType)) throw new UnsupportedOperationException("Expected element of type date, dateTime, instant, Timing or Period, found " + pathResult.getClass().getSimpleName());
            dateRange = this.getDateRange((ICompositeType)pathResult);
        }
        return this.matchesDateBounds(dateRange, new DateRangeParam(param));
    }

    default public boolean isMatchToken(TokenParam param, IBase pathResult) {
        if (param.getValue() == null) {
            return true;
        }
        if (pathResult instanceof IIdType) {
            IIdType id = (IIdType)pathResult;
            return param.getValue().equals(id.getIdPart());
        }
        if (pathResult instanceof IBaseEnumeration) {
            return param.getValue().equals(((IBaseEnumeration)pathResult).getValueAsString());
        }
        if (pathResult instanceof IPrimitiveType) {
            return param.getValue().equals(((IPrimitiveType)pathResult).getValue());
        }
        return false;
    }

    default public boolean isMatchCoding(TokenParam param, IBase pathResult, List<TokenParam> codes) {
        if (codes == null || codes.isEmpty()) {
            return false;
        }
        if (param.getModifier() == TokenParamModifier.IN) {
            throw new UnsupportedOperationException("In modifier is unsupported");
        }
        for (TokenParam c : codes) {
            boolean matches = param.getValue().equals(c.getValue()) && (param.getSystem() == null || param.getSystem().equals(c.getSystem()));
            if (!matches) continue;
            return true;
        }
        return false;
    }

    default public boolean isMatchUri(UriParam param, IBase pathResult) {
        if (pathResult instanceof IPrimitiveType) {
            return param.getValue().equals(((IPrimitiveType)pathResult).getValue());
        }
        throw new UnsupportedOperationException("Expected element of type url or uri, found " + pathResult.getClass().getSimpleName());
    }

    default public boolean isMatchString(StringParam param, Object pathResult) {
        if (pathResult instanceof IPrimitiveType) {
            return param.getValue().equals(((IPrimitiveType)pathResult).getValue());
        }
        throw new UnsupportedOperationException("Expected element of type string, found " + pathResult.getClass().getSimpleName());
    }

    default public boolean matchesDateBounds(DateRangeParam resourceRange, DateRangeParam paramRange) {
        Date resourceLowerBound = resourceRange.getLowerBoundAsInstant();
        Date resourceUpperBound = resourceRange.getUpperBoundAsInstant();
        Date paramLowerBound = paramRange.getLowerBoundAsInstant();
        Date paramUpperBound = paramRange.getUpperBoundAsInstant();
        if (paramLowerBound == null && paramUpperBound == null) {
            return false;
        }
        boolean result = true;
        if (paramLowerBound != null) {
            result &= resourceLowerBound.after(paramLowerBound) || resourceLowerBound.equals(paramLowerBound);
            result &= resourceUpperBound.after(paramLowerBound) || resourceUpperBound.equals(paramLowerBound);
        }
        if (paramUpperBound != null) {
            result &= resourceLowerBound.before(paramUpperBound) || resourceLowerBound.equals(paramUpperBound);
            result &= resourceUpperBound.before(paramUpperBound) || resourceUpperBound.equals(paramUpperBound);
        }
        return result;
    }

    public DateRangeParam getDateRange(ICompositeType var1);

    public List<TokenParam> getCodes(IBase var1);

    public static class SPPathKey {
        private final String resourceType;
        private final String resourcePath;

        public SPPathKey(String resourceType, String resourcePath) {
            this.resourceType = resourceType;
            this.resourcePath = resourcePath;
        }

        public String path() {
            return this.resourcePath;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.resourceType == null ? 0 : this.resourceType.hashCode());
            result = 31 * result + (this.resourcePath == null ? 0 : this.resourcePath.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SPPathKey or = (SPPathKey)obj;
            if (this.resourceType == null ? or.resourceType != null : !this.resourceType.equals(or.resourceType)) {
                return false;
            }
            return !(this.resourcePath == null ? or.resourcePath != null : !this.resourcePath.equals(or.resourcePath));
        }
    }
}

