/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.matcher;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.fhirpath.IFhirPath;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.TokenParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.NotImplementedException;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.Period;
import org.hl7.fhir.dstu3.model.Timing;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.opencds.cqf.fhir.utility.FhirPathCache;
import org.opencds.cqf.fhir.utility.matcher.ResourceMatcher;

public class ResourceMatcherDSTU3
implements ResourceMatcher {
    private Map<ResourceMatcher.SPPathKey, IFhirPath.IParsedExpression> pathCache = new HashMap<ResourceMatcher.SPPathKey, IFhirPath.IParsedExpression>();

    @Override
    public IFhirPath getEngine() {
        return FhirPathCache.cachedForVersion(FhirVersionEnum.DSTU3);
    }

    @Override
    public FhirContext getContext() {
        return FhirContext.forDstu3Cached();
    }

    @Override
    public DateRangeParam getDateRange(ICompositeType type) {
        if (type instanceof Period) {
            return new DateRangeParam(((Period)type).getStart(), ((Period)type).getEnd());
        }
        if (type instanceof Timing) {
            throw new NotImplementedException("Timing resolution has not yet been implemented");
        }
        throw new UnsupportedOperationException("Expected element of type Period or Timing, found " + type.getClass().getSimpleName());
    }

    @Override
    public List<TokenParam> getCodes(IBase codeElement) {
        List<Object> resolvedCodes = new ArrayList<TokenParam>();
        if (codeElement instanceof Coding) {
            Coding c = (Coding)codeElement;
            resolvedCodes.add(new TokenParam(c.getSystem(), c.getCode()));
        } else if (codeElement instanceof CodeType) {
            CodeType c = (CodeType)codeElement;
            resolvedCodes.add(new TokenParam((String)c.getValue()));
        } else if (codeElement instanceof CodeableConcept) {
            resolvedCodes = ((CodeableConcept)codeElement).getCoding().stream().map(code -> new TokenParam(code.getSystem(), code.getCode())).collect(Collectors.toList());
        }
        return resolvedCodes;
    }

    @Override
    public Map<ResourceMatcher.SPPathKey, IFhirPath.IParsedExpression> getPathCache() {
        return this.pathCache;
    }
}

