/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.operation;

import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.rest.annotation.Operation;
import jakarta.annotation.Nonnull;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.opencds.cqf.fhir.utility.Resources;
import org.opencds.cqf.fhir.utility.operation.ParameterBinder;
import org.opencds.cqf.fhir.utility.operation.Scope;

class MethodBinder {
    private final Method method;
    private final Operation operation;
    private final Description description;
    private final String name;
    private final String typeName;
    private final Scope scope;
    private final List<ParameterBinder> parameterBinders;
    private static final Description DEFAULT_DESCRIPTION = DefaultDescription.class.getAnnotation(Description.class);

    MethodBinder(Method method) {
        this.method = Objects.requireNonNull(method, "method cannot be null");
        this.operation = Objects.requireNonNull(method.getAnnotation(Operation.class), "method must be annotated with @Operation");
        this.description = MethodBinder.requireNonNullElse(method.getAnnotation(Description.class), DEFAULT_DESCRIPTION);
        this.name = MethodBinder.normalizeName(Objects.requireNonNull(this.operation.name(), "@Operation name cannot be null"));
        this.typeName = MethodBinder.typeNameFrom(this.operation);
        this.parameterBinders = ParameterBinder.validate(MethodBinder.parameterBindersFrom(method));
        this.scope = MethodBinder.determineScope(this.parameterBinders, this.typeName);
    }

    private static <T> T requireNonNullElse(T obj, T defaultObj) {
        return obj != null ? obj : defaultObj;
    }

    private static Scope determineScope(List<ParameterBinder> parameterBinders, String typeName) {
        boolean hasIdParam = parameterBinders.stream().anyMatch(x -> x.type() == ParameterBinder.Type.ID);
        if (hasIdParam) {
            return Scope.INSTANCE;
        }
        if (typeName.isEmpty()) {
            return Scope.SERVER;
        }
        return Scope.TYPE;
    }

    private static String normalizeName(String name) {
        return name.startsWith("$") ? name.substring(1) : name;
    }

    private static List<ParameterBinder> parameterBindersFrom(Method method) {
        return Arrays.stream(method.getParameters()).map(ParameterBinder::from).collect(Collectors.toList());
    }

    private static String typeNameFrom(Operation operation) {
        if (operation.type() != IBaseResource.class) {
            return operation.type().getSimpleName();
        }
        return operation.typeName();
    }

    private List<Object> args(IIdType id, IBaseParameters parameters) {
        IBaseParameters cloned;
        if (this.scope != Scope.INSTANCE && id != null) {
            throw new IllegalArgumentException("id not supported on non-instance operation");
        }
        if (this.scope == Scope.INSTANCE && id == null) {
            throw new IllegalArgumentException("id required for instance operation");
        }
        ArrayList<Object> args = new ArrayList<Object>(this.parameterBinders.size());
        int paramIndex = 0;
        if (id != null) {
            args.add(id);
            ++paramIndex;
        }
        IBaseParameters iBaseParameters = cloned = parameters != null ? Resources.clone(parameters) : null;
        while (paramIndex < this.parameterBinders.size()) {
            args.add(this.parameterBinders.get(paramIndex).bind(cloned));
            ++paramIndex;
        }
        if (cloned != null && !cloned.isEmpty()) {
            throw new IllegalArgumentException("Parameters were not bound to @Operation invocation: " + Resources.stringify((IBaseResource)cloned));
        }
        return args;
    }

    @Nonnull
    Operation operation() {
        return this.operation;
    }

    @Nonnull
    String name() {
        return this.name;
    }

    @Nonnull
    String typeName() {
        return this.typeName;
    }

    @Nonnull
    String canonicalUrl() {
        return this.operation.canonicalUrl();
    }

    @Nonnull
    Method method() {
        return this.method;
    }

    @Nonnull
    String description() {
        return this.description.value();
    }

    @Nonnull
    Scope scope() {
        return this.scope;
    }

    @Nonnull
    List<ParameterBinder> parameters() {
        return this.parameterBinders;
    }

    public Callable<IBaseResource> bind(Object provider, IIdType id, IBaseParameters parameters) {
        List<Object> args = this.args(id, parameters);
        return () -> (IBaseResource)this.method.invoke(provider, args.toArray());
    }

    @Description
    private static final class DefaultDescription {
        private DefaultDescription() {
        }
    }
}

