/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.r4;

import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Attachment;
import org.hl7.fhir.r4.model.Library;

public class AttachmentUtil {
    public static String getCqlLocation(IBaseResource resource) {
        Library library = (Library)resource;
        for (Attachment attachment : library.getContent()) {
            if (!attachment.hasContentType() || !attachment.getContentType().equals("text/cql") || !StringUtils.isNotBlank((CharSequence)attachment.getUrl())) continue;
            return attachment.getUrl();
        }
        return null;
    }

    public static IBaseResource addData(IBaseResource resource, String text) {
        if (StringUtils.isNotBlank((CharSequence)text)) {
            Library library = (Library)resource;
            for (Attachment attachment : library.getContent()) {
                if (!attachment.hasContentType() || !attachment.getContentType().equals("text/cql")) continue;
                attachment.setData(text.getBytes());
                return library;
            }
        }
        return null;
    }
}

