/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.r5;

import java.util.List;
import java.util.function.Consumer;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r5.model.ActivityDefinition;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.Library;
import org.hl7.fhir.r5.model.Measure;
import org.hl7.fhir.r5.model.MetadataResource;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.ValueSet;
import org.opencds.cqf.fhir.api.Repository;

public class MetadataResourceHelper {
    public static void forEachMetadataResource(List<Bundle.BundleEntryComponent> entries, Consumer<MetadataResource> callback, Repository repository) {
        entries.stream().map(entry -> entry.getResponse().getLocation()).map(location -> {
            switch (location.split("/")[0]) {
                case "ActivityDefinition": {
                    return (MetadataResource)repository.read(ActivityDefinition.class, (IIdType)new IdType(location));
                }
                case "Library": {
                    return (MetadataResource)repository.read(Library.class, (IIdType)new IdType(location));
                }
                case "Measure": {
                    return (MetadataResource)repository.read(Measure.class, (IIdType)new IdType(location));
                }
                case "PlanDefinition": {
                    return (MetadataResource)repository.read(PlanDefinition.class, (IIdType)new IdType(location));
                }
                case "ValueSet": {
                    return (MetadataResource)repository.read(ValueSet.class, (IIdType)new IdType(location));
                }
            }
            return null;
        }).forEach(callback);
    }
}

