/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.repository.ig;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.api.MethodOutcome;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.server.exceptions.ForbiddenOperationException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.rest.server.exceptions.UnclassifiedServerFailureException;
import ca.uhn.fhir.util.BundleBuilder;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.utility.Ids;
import org.opencds.cqf.fhir.utility.matcher.ResourceMatcher;
import org.opencds.cqf.fhir.utility.repository.Repositories;
import org.opencds.cqf.fhir.utility.repository.ig.CqlContent;
import org.opencds.cqf.fhir.utility.repository.ig.EncodingBehavior;
import org.opencds.cqf.fhir.utility.repository.ig.IgConventions;
import org.opencds.cqf.fhir.utility.repository.ig.ResourceCategory;
import org.opencds.cqf.fhir.utility.repository.operations.IRepositoryOperationProvider;

public class IgRepository
implements Repository {
    private final FhirContext fhirContext;
    private final Path root;
    private final IgConventions conventions;
    private final EncodingBehavior encodingBehavior;
    private final ResourceMatcher resourceMatcher;
    private IRepositoryOperationProvider operationProvider;
    private final Map<Path, Optional<IBaseResource>> resourceCache = new HashMap<Path, Optional<IBaseResource>>();
    static final String SOURCE_PATH_TAG = "sourcePath";
    static final String EXTERNAL_DIRECTORY = "external";
    static final Map<ResourceCategory, String> CATEGORY_DIRECTORIES = new ImmutableMap.Builder().put((Object)ResourceCategory.CONTENT, (Object)"resources").put((Object)ResourceCategory.DATA, (Object)"tests").put((Object)ResourceCategory.TERMINOLOGY, (Object)"vocabulary").build();
    static final BiMap<EncodingEnum, String> FILE_EXTENSIONS = new ImmutableBiMap.Builder().put((Object)EncodingEnum.JSON, (Object)"json").put((Object)EncodingEnum.XML, (Object)"xml").put((Object)EncodingEnum.RDF, (Object)"rdf").build();

    private static IParser parserForEncoding(FhirContext fhirContext, EncodingEnum encodingEnum) {
        switch (encodingEnum) {
            case JSON: {
                return fhirContext.newJsonParser();
            }
            case XML: {
                return fhirContext.newXmlParser();
            }
            case RDF: {
                return fhirContext.newRDFParser();
            }
        }
        throw new IllegalArgumentException("NDJSON is not supported");
    }

    public IgRepository(FhirContext fhirContext, Path root) {
        this(fhirContext, root, IgConventions.autoDetect(root), EncodingBehavior.DEFAULT, null);
    }

    public IgRepository(FhirContext fhirContext, Path root, IgConventions conventions, EncodingBehavior encodingBehavior, IRepositoryOperationProvider operationProvider) {
        this.fhirContext = Objects.requireNonNull(fhirContext, "fhirContext can not be null");
        this.root = Objects.requireNonNull(root, "root can not be null");
        this.conventions = Objects.requireNonNull(conventions, "conventions is required");
        this.encodingBehavior = Objects.requireNonNull(encodingBehavior, "encodingBehavior is required");
        this.resourceMatcher = Repositories.getResourceMatcher(this.fhirContext);
        this.operationProvider = operationProvider;
    }

    public void setOperationProvider(IRepositoryOperationProvider operationProvider) {
        this.operationProvider = operationProvider;
    }

    public void clearCache() {
        this.resourceCache.clear();
    }

    private boolean isExternaPath(Path path) {
        return path.getParent() != null && path.getParent().toString().toLowerCase().endsWith(EXTERNAL_DIRECTORY);
    }

    protected <T extends IBaseResource, I extends IIdType> Path preferredPathForResource(Class<T> resourceType, I id) {
        Path directory = this.directoryForResource(resourceType);
        String fileName = this.fileNameForResource(resourceType.getSimpleName(), id.getIdPart(), this.encodingBehavior.preferredEncoding());
        return directory.resolve(fileName);
    }

    <T extends IBaseResource, I extends IIdType> List<Path> potentialPathsForResource(Class<T> resourceType, I id) {
        ArrayList<Path> potentialDirectories = new ArrayList<Path>();
        Path directory = this.directoryForResource(resourceType);
        potentialDirectories.add(directory);
        if (ResourceCategory.forType(resourceType.getSimpleName()) == ResourceCategory.TERMINOLOGY) {
            Path externalDirectory = directory.resolve(EXTERNAL_DIRECTORY);
            potentialDirectories.add(externalDirectory);
        }
        ArrayList<Path> potentialPaths = new ArrayList<Path>();
        for (Path d : potentialDirectories) {
            for (EncodingEnum e : FILE_EXTENSIONS.keySet()) {
                potentialPaths.add(d.resolve(this.fileNameForResource(resourceType.getSimpleName(), id.getIdPart(), e)));
            }
        }
        return potentialPaths;
    }

    protected String fileNameForResource(String resourceType, String resourceId, EncodingEnum encoding) {
        String name = resourceId + "." + (String)FILE_EXTENSIONS.get((Object)encoding);
        if (IgConventions.FilenameMode.ID_ONLY.equals((Object)this.conventions.filenameMode())) {
            return name;
        }
        return resourceType + "-" + name;
    }

    protected <T extends IBaseResource> Path directoryForCategory(Class<T> resourceType) {
        if (this.conventions.categoryLayout() == IgConventions.CategoryLayout.FLAT) {
            return this.root;
        }
        ResourceCategory category = ResourceCategory.forType(resourceType.getSimpleName());
        String directory = CATEGORY_DIRECTORIES.get((Object)category);
        return this.root.resolve(directory);
    }

    protected <T extends IBaseResource> Path directoryForResource(Class<T> resourceType) {
        Path directory = this.directoryForCategory(resourceType);
        if (this.conventions.typeLayout() == IgConventions.FhirTypeLayout.FLAT) {
            return directory;
        }
        return directory.resolve(resourceType.getSimpleName().toLowerCase());
    }

    protected Optional<IBaseResource> readResource(Path path) {
        Optional<IBaseResource> optional;
        File file = path.toFile();
        if (!file.exists()) {
            return Optional.empty();
        }
        String extension = this.fileExtension(path);
        if (extension == null) {
            return Optional.empty();
        }
        EncodingEnum encoding = (EncodingEnum)FILE_EXTENSIONS.inverse().get((Object)extension);
        FileInputStream stream = new FileInputStream(file);
        try {
            IBaseResource resource = IgRepository.parserForEncoding(this.fhirContext, encoding).parseResource((InputStream)stream);
            resource.setUserData(SOURCE_PATH_TAG, (Object)path);
            CqlContent.loadCqlContent(resource, path.getParent());
            optional = Optional.of(resource);
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                return Optional.empty();
            }
            catch (DataFormatException e) {
                throw new ResourceNotFoundException(String.format("Found empty or invalid content at path %s", path));
            }
            catch (IOException e) {
                throw new UnclassifiedServerFailureException(500, String.format("Unable to read resource from path %s", path));
            }
        }
        stream.close();
        return optional;
    }

    protected Optional<IBaseResource> cachedReadResource(Path path) {
        return this.resourceCache.computeIfAbsent(path, this::readResource);
    }

    protected EncodingEnum encodingForPath(Path path) {
        String extension = this.fileExtension(path);
        return (EncodingEnum)FILE_EXTENSIONS.inverse().get((Object)extension);
    }

    protected <T extends IBaseResource> void writeResource(T resource, Path path) {
        try {
            if (path.getParent() != null) {
                path.getParent().toFile().mkdirs();
            }
            try (FileOutputStream stream = new FileOutputStream(path.toFile());){
                String result = IgRepository.parserForEncoding(this.fhirContext, this.encodingForPath(path)).setPrettyPrint(true).encodeResourceToString(resource);
                stream.write(result.getBytes());
                resource.setUserData(SOURCE_PATH_TAG, (Object)path);
                this.resourceCache.put(path, Optional.of(resource));
            }
        }
        catch (IOException | SecurityException e) {
            throw new UnclassifiedServerFailureException(500, String.format("Unable to write resource to path %s", path));
        }
    }

    private String fileExtension(Path path) {
        String name = path.getFileName().toString();
        int lastPeriod = name.lastIndexOf(".");
        if (lastPeriod == -1) {
            return null;
        }
        return name.substring(lastPeriod + 1).toLowerCase();
    }

    private boolean acceptByFileExtension(Path path) {
        String extension = this.fileExtension(path);
        if (extension == null) {
            return false;
        }
        return FILE_EXTENSIONS.containsValue((Object)extension);
    }

    private boolean acceptByFileExtensionAndPrefix(Path path, String prefix) {
        boolean extensionAccepted = this.acceptByFileExtension(path);
        if (!extensionAccepted) {
            return false;
        }
        return path.getFileName().toString().toLowerCase().startsWith(prefix.toLowerCase() + "-");
    }

    protected <T extends IBaseResource> Map<IIdType, T> readDirectoryForResourceType(Class<T> resourceClass) {
        Predicate<Path> resourceFileFilter;
        Path path = this.directoryForResource(resourceClass);
        HashMap<IIdType, T> resources = new HashMap<IIdType, T>();
        if (!path.toFile().exists()) {
            return resources;
        }
        switch (this.conventions.filenameMode()) {
            case ID_ONLY: {
                resourceFileFilter = this::acceptByFileExtension;
                break;
            }
            default: {
                resourceFileFilter = p -> this.acceptByFileExtensionAndPrefix((Path)p, resourceClass.getSimpleName());
            }
        }
        try (Stream<Path> paths = Files.walk(path, new FileVisitOption[0]);){
            List recursiveResources = paths.filter(resourceFileFilter).map(this::cachedReadResource).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            for (IBaseResource r : recursiveResources) {
                if (!r.fhirType().equals(resourceClass.getSimpleName())) continue;
                T t = this.validateResource(resourceClass, r, r.getIdElement());
                resources.put(r.getIdElement().toUnqualifiedVersionless(), t);
            }
        }
        catch (IOException e) {
            throw new UnclassifiedServerFailureException(500, String.format("Unable to read resources from path: %s", path));
        }
        return resources;
    }

    public FhirContext fhirContext() {
        return this.fhirContext;
    }

    public <T extends IBaseResource, I extends IIdType> T read(Class<T> resourceType, I id, Map<String, String> headers) {
        Objects.requireNonNull(resourceType, "resourceType can not be null");
        Objects.requireNonNull(id, "id can not be null");
        List<Path> paths = this.potentialPathsForResource(resourceType, id);
        for (Path path : paths) {
            Optional<IBaseResource> optionalResource;
            if (!path.toFile().exists() || !(optionalResource = this.cachedReadResource(path)).isPresent()) continue;
            IBaseResource r = optionalResource.get();
            return this.validateResource(resourceType, r, id);
        }
        throw new ResourceNotFoundException(id);
    }

    public <T extends IBaseResource> MethodOutcome create(T resource, Map<String, String> headers) {
        Objects.requireNonNull(resource, "resource can not be null");
        Objects.requireNonNull(resource.getIdElement().getIdPart(), "resource id can not be null");
        Path path = this.preferredPathForResource(resource.getClass(), resource.getIdElement());
        this.writeResource(resource, path);
        return new MethodOutcome(resource.getIdElement(), Boolean.valueOf(true));
    }

    private <T extends IBaseResource> T validateResource(Class<T> resourceType, IBaseResource r, IIdType id) {
        Path path = (Path)r.getUserData(SOURCE_PATH_TAG);
        if (!resourceType.getSimpleName().equals(r.fhirType())) {
            throw new ResourceNotFoundException(String.format("Expected to find a resource with type: %s at path: %s. Found resource with type %s instead.", resourceType.getSimpleName(), path, r.fhirType()));
        }
        if (!r.getIdElement().hasIdPart()) {
            throw new ResourceNotFoundException(String.format("Expected to find a resource with id: %s at path: %s. Found resource without an id instead.", id.toUnqualifiedVersionless(), path));
        }
        if (!id.getIdPart().equals(r.getIdElement().getIdPart())) {
            throw new ResourceNotFoundException(String.format("Expected to find a resource with id: %s at path: %s. Found resource with an id %s instead.", id.getIdPart(), path, r.getIdElement().getIdPart()));
        }
        if (id.hasVersionIdPart() && !id.getVersionIdPart().equals(r.getIdElement().getVersionIdPart())) {
            throw new ResourceNotFoundException(String.format("Expected to find a resource with version: %s at path: %s. Found resource with version %s instead.", id.getVersionIdPart(), path, r.getIdElement().getVersionIdPart()));
        }
        return (T)((IBaseResource)resourceType.cast(r));
    }

    public <T extends IBaseResource> MethodOutcome update(T resource, Map<String, String> headers) {
        Objects.requireNonNull(resource, "resource can not be null");
        Objects.requireNonNull(resource.getIdElement().getIdPart(), "resource id can not be null");
        Path preferred = this.preferredPathForResource(resource.getClass(), resource.getIdElement());
        Path actual = (Path)resource.getUserData(SOURCE_PATH_TAG);
        if (actual == null) {
            actual = preferred;
        }
        if (this.isExternaPath(actual)) {
            throw new ForbiddenOperationException(String.format("Unable to create or update: %s. Resource is marked as external, and external resources are read-only.", resource.getIdElement().toUnqualifiedVersionless()));
        }
        if (!preferred.equals(actual) && this.encodingBehavior.preserveEncoding() == EncodingBehavior.PreserveEncoding.OVERWRITE_WITH_PREFERRED_ENCODING) {
            try {
                Files.deleteIfExists(actual);
            }
            catch (IOException e) {
                throw new UnclassifiedServerFailureException(500, String.format("Couldn't change encoding for %s", actual));
            }
            actual = preferred;
        }
        this.writeResource(resource, actual);
        return new MethodOutcome(resource.getIdElement(), Boolean.valueOf(false));
    }

    public <T extends IBaseResource, I extends IIdType> MethodOutcome delete(Class<T> resourceType, I id, Map<String, String> headers) {
        Objects.requireNonNull(resourceType, "resourceType can not be null");
        Objects.requireNonNull(id, "id can not be null");
        List<Path> paths = this.potentialPathsForResource(resourceType, id);
        boolean deleted = false;
        for (Path path : paths) {
            try {
                deleted = Files.deleteIfExists(path);
                if (!deleted) continue;
                break;
            }
            catch (IOException e) {
                throw new UnclassifiedServerFailureException(500, String.format("Couldn't delete %s", path));
            }
        }
        if (!deleted) {
            throw new ResourceNotFoundException(id);
        }
        return new MethodOutcome(id);
    }

    public <B extends IBaseBundle, T extends IBaseResource> B search(Class<B> bundleType, Class<T> resourceType, Map<String, List<IQueryParameterType>> searchParameters, Map<String, String> headers) {
        Collection<T> candidates;
        Map<IIdType, T> resourceIdMap;
        BundleBuilder builder;
        block8: {
            block7: {
                builder = new BundleBuilder(this.fhirContext);
                builder.setType("searchset");
                resourceIdMap = this.readDirectoryForResourceType(resourceType);
                if (searchParameters == null) break block7;
                if (!searchParameters.isEmpty()) break block8;
            }
            resourceIdMap.values().forEach(arg_0 -> ((BundleBuilder)builder).addCollectionEntry(arg_0));
            return (B)builder.getBundle();
        }
        if (searchParameters.containsKey("_id")) {
            List<IQueryParameterType> idQueries = searchParameters.get("_id");
            searchParameters.remove("_id");
            ArrayList<T> idResources = new ArrayList<T>(idQueries.size());
            for (IQueryParameterType idQuery : idQueries) {
                TokenParam idToken = (TokenParam)idQuery;
                Object id = Ids.newId(this.fhirContext, resourceType.getSimpleName(), idToken.getValue());
                IBaseResource r = (IBaseResource)resourceIdMap.get(id);
                if (r == null) continue;
                idResources.add(r);
            }
            candidates = idResources;
        } else {
            candidates = resourceIdMap.values();
        }
        for (IBaseResource resource : candidates) {
            if (!this.allParametersMatch(searchParameters, resource)) continue;
            builder.addCollectionEntry(resource);
        }
        return (B)builder.getBundle();
    }

    private boolean allParametersMatch(Map<String, List<IQueryParameterType>> searchParameters, IBaseResource resource) {
        for (Map.Entry<String, List<IQueryParameterType>> nextEntry : searchParameters.entrySet()) {
            String paramName = nextEntry.getKey();
            if (this.resourceMatcher.matches(paramName, nextEntry.getValue(), resource)) continue;
            return false;
        }
        return true;
    }

    public <R extends IBaseResource, P extends IBaseParameters, T extends IBaseResource> R invoke(Class<T> resourceType, String name, P parameters, Class<R> returnType, Map<String, String> headers) {
        return this.invokeOperation(null, resourceType.getSimpleName(), name, parameters);
    }

    public <R extends IBaseResource, P extends IBaseParameters, I extends IIdType> R invoke(I id, String name, P parameters, Class<R> returnType, Map<String, String> headers) {
        return this.invokeOperation(id, id.getResourceType(), name, parameters);
    }

    protected <R extends IBaseResource> R invokeOperation(IIdType id, String resourceType, String operationName, IBaseParameters parameters) {
        if (this.operationProvider == null) {
            throw new IllegalArgumentException("No operation provider found.  Unable to invoke operations.");
        }
        return this.operationProvider.invokeOperation(this, id, resourceType, operationName, parameters);
    }
}

