/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.repository.operations;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.opencds.cqf.fhir.utility.adapter.AdapterFactory;
import org.opencds.cqf.fhir.utility.adapter.ParametersAdapter;
import org.opencds.cqf.fhir.utility.adapter.ParametersParameterComponentAdapter;

public class OperationParametersParser {
    protected AdapterFactory adapterFactory;

    public OperationParametersParser(AdapterFactory adapterFactory) {
        Objects.requireNonNull(adapterFactory, "adapterFactory must not be null");
        this.adapterFactory = adapterFactory;
    }

    public void addResourceChild(IBaseParameters parameters, String name, IBaseResource resource) {
        Objects.requireNonNull(parameters, "parameters must not be null");
        Objects.requireNonNull(name, "name must not be null");
        ParametersAdapter parametersAdapter = this.adapterFactory.createParameters(parameters);
        List parts = parametersAdapter.getParameter().stream().map(x -> this.adapterFactory.createParametersParameters((IBaseBackboneElement)x)).collect(Collectors.toList());
        ParametersParameterComponentAdapter part = parts.stream().filter(x -> x.getName().equals(name)).findFirst().orElse(null);
        if (part == null) {
            part = this.adapterFactory.createParametersParameters(parametersAdapter.addParameter());
        }
        part.setName(name);
        part.setResource(resource);
        part.setValue(null);
    }

    public void addValueChild(IBaseParameters parameters, String name, IBaseDatatype value) {
        Objects.requireNonNull(parameters, "parameters must not be null");
        Objects.requireNonNull(name, "name must not be null");
        ParametersAdapter parametersAdapter = this.adapterFactory.createParameters(parameters);
        List parts = parametersAdapter.getParameter().stream().map(x -> this.adapterFactory.createParametersParameters((IBaseBackboneElement)x)).collect(Collectors.toList());
        ParametersParameterComponentAdapter part = parts.stream().filter(x -> x.getName().equals(name)).findFirst().orElse(null);
        if (part == null) {
            part = this.adapterFactory.createParametersParameters(parametersAdapter.addParameter());
        }
        part.setName(name);
        part.setResource(null);
        part.setValue(value);
    }

    public IBaseResource getResourceChild(IBaseParameters parameters, String name) {
        if (parameters == null) {
            return null;
        }
        Objects.requireNonNull(name, "name must not be null");
        ParametersAdapter parametersAdapter = this.adapterFactory.createParameters(parameters);
        List parts = parametersAdapter.getParameter().stream().map(x -> this.adapterFactory.createParametersParameters((IBaseBackboneElement)x)).collect(Collectors.toList());
        IBaseResource value = parts.stream().filter(x -> x.getName().equals(name)).map(x -> x.getResource()).findFirst().orElse(null);
        return value;
    }

    public Map<String, IBaseResource> getResourceChildren(IBaseParameters parameters) {
        if (parameters == null) {
            return null;
        }
        Objects.requireNonNull(parameters, "parameters must not be null");
        ParametersAdapter parametersAdapter = this.adapterFactory.createParameters(parameters);
        List parts = parametersAdapter.getParameter().stream().map(x -> this.adapterFactory.createParametersParameters((IBaseBackboneElement)x)).collect(Collectors.toList());
        Map<String, IBaseResource> resources = parts.stream().collect(Collectors.toMap(x -> x.getName(), x -> x.getResource()));
        return resources;
    }

    public IBaseDatatype getValueChild(IBaseParameters parameters, String name) {
        if (parameters == null) {
            return null;
        }
        Objects.requireNonNull(parameters, "parameters must not be null");
        Objects.requireNonNull(name, "name must not be null");
        ParametersAdapter parametersAdapter = this.adapterFactory.createParameters(parameters);
        List parts = parametersAdapter.getParameter().stream().map(x -> this.adapterFactory.createParametersParameters((IBaseBackboneElement)x)).collect(Collectors.toList());
        IBaseDatatype value = parts.stream().filter(x -> x.getName().equals(name)).map(x -> x.getValue()).findFirst().orElse(null);
        return value;
    }

    public Map<String, IBaseDatatype> getValueChildren(IBaseParameters parameters) {
        if (parameters == null) {
            return null;
        }
        Objects.requireNonNull(parameters, "parameters must not be null");
        ParametersAdapter parametersAdapter = this.adapterFactory.createParameters(parameters);
        List parts = parametersAdapter.getParameter().stream().map(x -> this.adapterFactory.createParametersParameters((IBaseBackboneElement)x)).collect(Collectors.toList());
        Map<String, IBaseDatatype> values = parts.stream().collect(Collectors.toMap(x -> x.getName(), x -> x.getValue()));
        return values;
    }

    public Map<String, Object> getParameterParts(IBaseParameters parameters) {
        Objects.requireNonNull(parameters, "parameters must not be null");
        ParametersAdapter parametersAdapter = this.adapterFactory.createParameters(parameters);
        List parts = parametersAdapter.getParameter().stream().map(x -> this.adapterFactory.createParametersParameters((IBaseBackboneElement)x)).collect(Collectors.toList());
        HashMap<String, Object> parameterParts = new HashMap<String, Object>();
        for (ParametersParameterComponentAdapter part : parts) {
            Object value = part.hasValue() ? part.getValue() : (part.hasResource() ? part.getResource() : null);
            if (value == null) continue;
            if (!parameterParts.containsKey(part.getName())) {
                parameterParts.put(part.getName(), value);
                continue;
            }
            Object existingValue = parameterParts.get(part.getName());
            if (existingValue instanceof List) {
                ((List)existingValue).add(value);
                parameterParts.put(part.getName(), existingValue);
                continue;
            }
            List<Object> newListValue = Arrays.asList(existingValue, value);
            parameterParts.put(part.getName(), newListValue);
        }
        return parameterParts;
    }
}

