/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.visitor;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.rest.server.exceptions.PreconditionFailedException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.MetadataResource;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.utility.BundleHelper;
import org.opencds.cqf.fhir.utility.Canonicals;
import org.opencds.cqf.fhir.utility.SearchHelper;
import org.opencds.cqf.fhir.utility.adapter.AdapterFactory;
import org.opencds.cqf.fhir.utility.adapter.KnowledgeArtifactAdapter;
import org.opencds.cqf.fhir.utility.search.Searches;

public class VisitorHelper {
    public static <T extends IBaseDatatype> Optional<T> getParameter(String name, IBaseParameters operationParameters, Class<T> type) {
        AdapterFactory factory = AdapterFactory.forFhirVersion(operationParameters.getStructureFhirVersionEnum());
        return Optional.ofNullable(operationParameters).map(p -> factory.createParameters((IBaseParameters)p)).map(p -> p.getParameter(name)).map(p -> factory.createParametersParameters((IBaseBackboneElement)p)).map(parametersParameters -> parametersParameters.getValue());
    }

    public static <T extends IBaseResource> Optional<T> getResourceParameter(String name, IBaseParameters operationParameters, Class<T> type) {
        AdapterFactory factory = AdapterFactory.forFhirVersion(operationParameters.getStructureFhirVersionEnum());
        return Optional.ofNullable(operationParameters).map(p -> factory.createParameters((IBaseParameters)p)).map(p -> p.getParameter(name)).map(p -> factory.createParametersParameters((IBaseBackboneElement)p)).map(parametersParameters -> parametersParameters.getResource());
    }

    public static <T extends IBaseDatatype> Optional<List<T>> getListParameter(String name, IBaseParameters operationParameters, Class<T> type) {
        AdapterFactory factory = AdapterFactory.forFhirVersion(operationParameters.getStructureFhirVersionEnum());
        return Optional.ofNullable(operationParameters).map(p -> factory.createParameters((IBaseParameters)p)).map(p -> p.getParameterValues(name)).map(vals -> vals.stream().map(val -> val).collect(Collectors.toList()));
    }

    public static List<IDomainResource> getMetadataResourcesFromBundle(IBaseBundle bundle) {
        ArrayList<IDomainResource> resourceList = new ArrayList<IDomainResource>();
        FhirVersionEnum version = bundle.getStructureFhirVersionEnum();
        if (!BundleHelper.getEntryFirstRep(bundle).isEmpty()) {
            BundleHelper.getEntry(bundle).stream().map(e -> BundleHelper.getEntryResource(version, e)).filter(r -> r != null).forEach(r -> {
                switch (version) {
                    case DSTU3: {
                        if (!(r instanceof org.hl7.fhir.dstu3.model.MetadataResource)) break;
                        resourceList.add((IDomainResource)r);
                        break;
                    }
                    case R4: {
                        if (!(r instanceof MetadataResource)) break;
                        resourceList.add((IDomainResource)r);
                        break;
                    }
                    case R5: {
                        if (!(r instanceof org.hl7.fhir.r5.model.MetadataResource)) break;
                        resourceList.add((IDomainResource)r);
                        break;
                    }
                }
            });
        }
        return resourceList;
    }

    public static void findUnsupportedCapability(KnowledgeArtifactAdapter resource, List<String> capability) throws PreconditionFailedException {
        if (capability != null && !capability.isEmpty()) {
            List knowledgeCapabilityExtension = resource.get().getExtension().stream().filter(ext -> ext.getUrl().contains("cqf-knowledgeCapability")).collect(Collectors.toList());
            if (knowledgeCapabilityExtension.isEmpty()) {
                throw new PreconditionFailedException(String.format("Resource with url: '%s' does not specify capability.", resource.getUrl()));
            }
            knowledgeCapabilityExtension.stream().filter(ext -> !capability.contains(((IPrimitiveType)ext.getValue()).getValue())).findAny().ifPresent(ext -> {
                throw new PreconditionFailedException(String.format("Resource with url: '%s' is not one of '%s'.", resource.getUrl(), String.join((CharSequence)", ", capability)));
            });
        }
    }

    public static void processCanonicals(KnowledgeArtifactAdapter resource, List<String> canonicalVersion, List<String> checkArtifactVersion, List<String> forceArtifactVersion) throws PreconditionFailedException {
        if (checkArtifactVersion != null && !checkArtifactVersion.isEmpty()) {
            VisitorHelper.findVersionInListMatchingResource(checkArtifactVersion, resource).ifPresent(version -> {
                if (!resource.getVersion().equals(version)) {
                    throw new PreconditionFailedException(String.format("Resource with url '%s' has version '%s' but checkVersion specifies '%s'", resource.getUrl(), resource.getVersion(), version));
                }
            });
        } else if (forceArtifactVersion != null && !forceArtifactVersion.isEmpty()) {
            VisitorHelper.findVersionInListMatchingResource(forceArtifactVersion, resource).ifPresent(version -> resource.setVersion((String)version));
        } else if (canonicalVersion != null && !canonicalVersion.isEmpty() && !resource.hasVersion()) {
            VisitorHelper.findVersionInListMatchingResource(canonicalVersion, resource).ifPresent(version -> resource.setVersion((String)version));
        }
    }

    private static Optional<String> findVersionInListMatchingResource(List<String> list, KnowledgeArtifactAdapter resource) {
        return list.stream().filter(canonical -> Canonicals.getUrl(canonical).equals(resource.getUrl())).map(canonical -> Canonicals.getVersion(canonical)).findAny();
    }

    public static boolean typeHasCoding(ICompositeType type, String system, String code) {
        return false;
    }

    public static Optional<KnowledgeArtifactAdapter> tryGetLatestVersion(String inputReference, Repository repository) {
        return KnowledgeArtifactAdapter.findLatestVersion(SearchHelper.searchRepositoryByCanonicalWithPaging(repository, inputReference)).map(res -> AdapterFactory.forFhirVersion(res.getStructureFhirVersionEnum()).createKnowledgeArtifactAdapter((IDomainResource)res));
    }

    public static Optional<KnowledgeArtifactAdapter> tryGetLatestVersionWithStatus(String inputReference, Repository repository, String status) {
        return KnowledgeArtifactAdapter.findLatestVersion(SearchHelper.searchRepositoryByCanonicalWithPagingWithParams(repository, inputReference, Searches.byStatus(status))).map(res -> AdapterFactory.forFhirVersion(res.getStructureFhirVersionEnum()).createKnowledgeArtifactAdapter((IDomainResource)res));
    }
}

