/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.visitor;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.rest.server.exceptions.PreconditionFailedException;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.utility.BundleHelper;
import org.opencds.cqf.fhir.utility.PackageHelper;
import org.opencds.cqf.fhir.utility.adapter.KnowledgeArtifactAdapter;
import org.opencds.cqf.fhir.utility.visitor.AbstractKnowledgeArtifactVisitor;

public class WithdrawVisitor
extends AbstractKnowledgeArtifactVisitor {
    @Override
    public IBase visit(KnowledgeArtifactAdapter rootAdapter, Repository repository, IBaseParameters operationParameters) {
        if (!rootAdapter.getStatus().equals("draft")) {
            throw new PreconditionFailedException("Cannot withdraw an artifact that is not in draft status");
        }
        FhirVersionEnum fhirVersion = rootAdapter.get().getStructureFhirVersionEnum();
        IBaseBundle transactionBundle = BundleHelper.newBundle(fhirVersion, null, "transaction");
        ArrayList<IDomainResource> resToUpdate = new ArrayList<IDomainResource>();
        resToUpdate.add(rootAdapter.get());
        this.findArtifactCommentsToUpdate((IBaseResource)rootAdapter.get(), fhirVersion.getFhirVersionString(), repository).forEach(artifact -> {
            IBaseResource resource = BundleHelper.getEntryResource(fhirVersion, artifact);
            IBaseBackboneElement entry = PackageHelper.deleteEntry(resource);
            BundleHelper.addEntry(transactionBundle, entry);
        });
        List<IDomainResource> resourcesToUpdate = this.getComponents(rootAdapter, repository, resToUpdate);
        for (IDomainResource artifact2 : resourcesToUpdate) {
            IBaseBackboneElement entry = PackageHelper.deleteEntry((IBaseResource)artifact2);
            BundleHelper.addEntry(transactionBundle, entry);
        }
        return repository.transaction(transactionBundle);
    }
}

