/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.adapter;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.RelatedArtifact;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.MetadataResource;
import org.hl7.fhir.r4.model.RelatedArtifact;
import org.hl7.fhir.r5.model.RelatedArtifact;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.utility.BundleHelper;
import org.opencds.cqf.fhir.utility.adapter.AdapterFactory;
import org.opencds.cqf.fhir.utility.adapter.DependencyInfo;
import org.opencds.cqf.fhir.utility.adapter.IDependencyInfo;
import org.opencds.cqf.fhir.utility.adapter.ResourceAdapter;
import org.opencds.cqf.fhir.utility.visitor.KnowledgeArtifactVisitor;

public interface KnowledgeArtifactAdapter
extends ResourceAdapter {
    public static final String releaseLabelUrl = "http://hl7.org/fhir/StructureDefinition/artifact-releaseLabel";
    public static final String releaseDescriptionUrl = "http://hl7.org/fhir/StructureDefinition/artifact-releaseDescription";
    public static final String usPhContextTypeUrl = "http://hl7.org/fhir/us/ecr/CodeSystem/us-ph-usage-context-type";
    public static final String contextTypeUrl = "http://terminology.hl7.org/CodeSystem/usage-context-type";
    public static final String contextUrl = "http://hl7.org/fhir/us/ecr/CodeSystem/us-ph-usage-context";
    public static final String isOwnedUrl = "http://hl7.org/fhir/StructureDefinition/crmi-isOwned";

    @Override
    public IDomainResource get();

    public IDomainResource copy();

    default public IIdType getId() {
        return this.get().getIdElement();
    }

    default public void setId(IIdType id) {
        this.get().setId(id);
    }

    public String getName();

    public void setName(String var1);

    public boolean hasUrl();

    public String getUrl();

    public void setUrl(String var1);

    public boolean hasVersion();

    public String getVersion();

    public void setVersion(String var1);

    public List<IDependencyInfo> getDependencies();

    public Date getApprovalDate();

    public void setApprovalDate(Date var1);

    public Date getDate();

    public void setDate(Date var1);

    public void setDateElement(IPrimitiveType<Date> var1);

    public String getStatus();

    public void setStatus(String var1);

    public ICompositeType getEffectivePeriod();

    public boolean getExperimental();

    public void setExtension(List<IBaseExtension<?, ?>> var1);

    public static <T extends ICompositeType & IBaseHasExtensions> T newRelatedArtifact(FhirVersionEnum version, String type, String reference) {
        switch (version) {
            case DSTU3: {
                RelatedArtifact dstu3 = new RelatedArtifact();
                dstu3.setType(RelatedArtifact.RelatedArtifactType.fromCode((String)type)).setResource(new Reference(reference));
                return (T)dstu3;
            }
            case R4: {
                org.hl7.fhir.r4.model.RelatedArtifact r4 = new org.hl7.fhir.r4.model.RelatedArtifact();
                r4.setType(RelatedArtifact.RelatedArtifactType.fromCode((String)type)).setResource(reference);
                return (T)r4;
            }
            case R5: {
                org.hl7.fhir.r5.model.RelatedArtifact r5 = new org.hl7.fhir.r5.model.RelatedArtifact();
                r5.setType(RelatedArtifact.RelatedArtifactType.fromCode((String)type)).setResource(reference);
                return (T)r5;
            }
        }
        throw new UnprocessableEntityException("Upsupported version: " + version.toString());
    }

    public static <T extends ICompositeType & IBaseHasExtensions> String getRelatedArtifactReference(T relatedArtifact) {
        if (relatedArtifact instanceof RelatedArtifact) {
            return KnowledgeArtifactAdapter.getRelatedArtifactReference((RelatedArtifact)relatedArtifact);
        }
        if (relatedArtifact instanceof org.hl7.fhir.r4.model.RelatedArtifact) {
            return KnowledgeArtifactAdapter.getRelatedArtifactReference((org.hl7.fhir.r4.model.RelatedArtifact)relatedArtifact);
        }
        if (relatedArtifact instanceof org.hl7.fhir.r5.model.RelatedArtifact) {
            return KnowledgeArtifactAdapter.getRelatedArtifactReference((org.hl7.fhir.r5.model.RelatedArtifact)relatedArtifact);
        }
        throw new UnprocessableEntityException("Must be a valid RelatedArtifact");
    }

    private static String getRelatedArtifactReference(RelatedArtifact relatedArtifact) {
        return relatedArtifact.getResource().getReference();
    }

    private static String getRelatedArtifactReference(org.hl7.fhir.r4.model.RelatedArtifact relatedArtifact) {
        return relatedArtifact.getResource();
    }

    private static String getRelatedArtifactReference(org.hl7.fhir.r5.model.RelatedArtifact relatedArtifact) {
        return relatedArtifact.getResource();
    }

    public static <T extends ICompositeType & IBaseHasExtensions> String getRelatedArtifactType(T relatedArtifact) {
        if (relatedArtifact instanceof RelatedArtifact) {
            return KnowledgeArtifactAdapter.getRelatedArtifactType((RelatedArtifact)relatedArtifact);
        }
        if (relatedArtifact instanceof org.hl7.fhir.r4.model.RelatedArtifact) {
            return KnowledgeArtifactAdapter.getRelatedArtifactType((org.hl7.fhir.r4.model.RelatedArtifact)relatedArtifact);
        }
        if (relatedArtifact instanceof org.hl7.fhir.r5.model.RelatedArtifact) {
            return KnowledgeArtifactAdapter.getRelatedArtifactType((org.hl7.fhir.r5.model.RelatedArtifact)relatedArtifact);
        }
        throw new UnprocessableEntityException("Must be a valid RelatedArtifact");
    }

    private static String getRelatedArtifactType(RelatedArtifact relatedArtifact) {
        return relatedArtifact.getType().toCode();
    }

    private static String getRelatedArtifactType(org.hl7.fhir.r4.model.RelatedArtifact relatedArtifact) {
        return relatedArtifact.getType().toCode();
    }

    private static String getRelatedArtifactType(org.hl7.fhir.r5.model.RelatedArtifact relatedArtifact) {
        return relatedArtifact.getType().toCode();
    }

    public static <T extends ICompositeType & IBaseHasExtensions> void setRelatedArtifactReference(T relatedArtifact, String reference) {
        if (relatedArtifact instanceof RelatedArtifact) {
            KnowledgeArtifactAdapter.setRelatedArtifactReference((RelatedArtifact)relatedArtifact, reference);
        } else if (relatedArtifact instanceof org.hl7.fhir.r4.model.RelatedArtifact) {
            KnowledgeArtifactAdapter.setRelatedArtifactReference((org.hl7.fhir.r4.model.RelatedArtifact)relatedArtifact, reference);
        } else if (relatedArtifact instanceof org.hl7.fhir.r5.model.RelatedArtifact) {
            KnowledgeArtifactAdapter.setRelatedArtifactReference((org.hl7.fhir.r5.model.RelatedArtifact)relatedArtifact, reference);
        } else {
            throw new UnprocessableEntityException("Must be a valid RelatedArtifact");
        }
    }

    private static void setRelatedArtifactReference(RelatedArtifact relatedArtifact, String reference) {
        relatedArtifact.getResource().setReference(reference);
    }

    private static void setRelatedArtifactReference(org.hl7.fhir.r4.model.RelatedArtifact relatedArtifact, String reference) {
        relatedArtifact.setResource(reference);
    }

    private static void setRelatedArtifactReference(org.hl7.fhir.r5.model.RelatedArtifact relatedArtifact, String reference) {
        relatedArtifact.setResource(reference);
    }

    public void setEffectivePeriod(ICompositeType var1);

    public boolean hasRelatedArtifact();

    public <T extends ICompositeType & IBaseHasExtensions> List<T> getRelatedArtifact();

    public <T extends ICompositeType & IBaseHasExtensions> List<T> getRelatedArtifactsOfType(String var1);

    default public <T extends ICompositeType & IBaseHasExtensions> List<T> getComponents() {
        return this.getRelatedArtifactsOfType("composed-of");
    }

    public static <T extends ICompositeType & IBaseHasExtensions> boolean checkIfRelatedArtifactIsOwned(T relatedArtifact) {
        return ((IBaseHasExtensions)relatedArtifact).getExtension().stream().anyMatch(ext -> ext.getUrl().equals(isOwnedUrl));
    }

    default public List<IDependencyInfo> combineComponentsAndDependencies() {
        String referenceSource = this.hasVersion() ? this.getUrl() + "|" + this.getVersion() : this.getUrl();
        return Stream.concat(this.getComponents().stream().filter(ra -> ra != null).map(ra -> DependencyInfo.convertRelatedArtifact(ra, referenceSource)), this.getDependencies().stream()).collect(Collectors.toList());
    }

    public <T extends ICompositeType & IBaseHasExtensions> void setRelatedArtifact(List<T> var1);

    public IBase accept(KnowledgeArtifactVisitor var1, Repository var2, IBaseParameters var3);

    default public <T extends ICompositeType & IBaseHasExtensions> List<T> getOwnedRelatedArtifacts() {
        return this.getRelatedArtifactsOfType("composed-of").stream().filter(ra -> KnowledgeArtifactAdapter.checkIfRelatedArtifactIsOwned(ra)).collect(Collectors.toList());
    }

    public static boolean isSupportedMetadataResource(IBaseResource resource) {
        return resource instanceof org.hl7.fhir.dstu3.model.MetadataResource || resource instanceof MetadataResource || resource instanceof org.hl7.fhir.r5.model.MetadataResource;
    }

    public static Optional<IDomainResource> findLatestVersion(IBaseBundle bundle) {
        List sorted = BundleHelper.getEntryResources(bundle).stream().filter(r -> KnowledgeArtifactAdapter.isSupportedMetadataResource(r)).map(r -> (KnowledgeArtifactAdapter)AdapterFactory.forFhirVersion(r.getStructureFhirVersionEnum()).createResource((IBaseResource)r)).sorted((a, b) -> a.getVersion().compareTo(b.getVersion())).collect(Collectors.toList());
        if (!sorted.isEmpty()) {
            return Optional.of(((KnowledgeArtifactAdapter)sorted.get(0)).get());
        }
        return Optional.ofNullable(null);
    }
}

