/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.repository;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.api.MethodOutcome;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.server.exceptions.NotImplementedOperationException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.util.BundleBuilder;
import ca.uhn.fhir.util.BundleUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.NotImplementedException;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseConformance;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.utility.BundleHelper;
import org.opencds.cqf.fhir.utility.Ids;
import org.opencds.cqf.fhir.utility.matcher.ResourceMatcher;
import org.opencds.cqf.fhir.utility.repository.Repositories;

public class InMemoryFhirRepository
implements Repository {
    private final Map<String, Map<IIdType, IBaseResource>> resourceMap;
    private final FhirContext context;
    private final Map<String, Function<IBaseParameters, Object>> operationMap;

    public InMemoryFhirRepository(FhirContext context) {
        this.context = context;
        this.resourceMap = new HashMap<String, Map<IIdType, IBaseResource>>();
        this.operationMap = new HashMap<String, Function<IBaseParameters, Object>>();
    }

    public InMemoryFhirRepository(FhirContext context, IBaseBundle bundle) {
        this.context = context;
        List resources = BundleUtil.toListOfResources((FhirContext)this.context, (IBaseBundle)bundle);
        this.resourceMap = resources.stream().collect(Collectors.groupingBy(IBase::fhirType, Collectors.toMap(r -> r.getIdElement().toUnqualifiedVersionless(), Function.identity())));
        this.operationMap = new HashMap<String, Function<IBaseParameters, Object>>();
    }

    public <T extends IBaseResource, I extends IIdType> T read(Class<T> resourceType, I id, Map<String, String> headers) {
        Map resources = this.resourceMap.computeIfAbsent(resourceType.getSimpleName(), x -> new HashMap());
        IBaseResource resource = (IBaseResource)resources.get(id.toUnqualifiedVersionless());
        if (resource == null) {
            throw new ResourceNotFoundException(id);
        }
        return (T)resource;
    }

    public <T extends IBaseResource> MethodOutcome create(T resource, Map<String, String> headers) {
        Map resources = this.resourceMap.computeIfAbsent(resource.fhirType(), r -> new HashMap());
        Object theId = Ids.newRandomId(this.context, resource.fhirType());
        while (resources.containsKey(theId)) {
            theId = Ids.newRandomId(this.context, resource.fhirType());
        }
        resource.setId(theId);
        MethodOutcome outcome = new MethodOutcome(theId, Boolean.valueOf(true));
        resources.put(theId.toUnqualifiedVersionless(), resource);
        return outcome;
    }

    public <I extends IIdType, P extends IBaseParameters> MethodOutcome patch(I id, P patchParameters, Map<String, String> headers) {
        throw new NotImplementedException("The PATCH operation is not currently supported");
    }

    public <T extends IBaseResource> MethodOutcome update(T resource, Map<String, String> headers) {
        Map resources = this.resourceMap.computeIfAbsent(resource.fhirType(), r -> new HashMap());
        IIdType theId = resource.getIdElement().toUnqualifiedVersionless();
        MethodOutcome outcome = new MethodOutcome(theId, Boolean.valueOf(false));
        if (!resources.containsKey(theId)) {
            outcome.setCreated(Boolean.valueOf(true));
        }
        resources.put(theId, resource);
        return outcome;
    }

    public <T extends IBaseResource, I extends IIdType> MethodOutcome delete(Class<T> resourceType, I id, Map<String, String> headers) {
        IIdType keyId;
        MethodOutcome outcome = new MethodOutcome();
        Map resources = this.resourceMap.computeIfAbsent(id.getResourceType(), r -> new HashMap());
        if (!resources.containsKey(keyId = id.toUnqualifiedVersionless())) {
            throw new ResourceNotFoundException("Resource not found with id " + String.valueOf(id));
        }
        resources.remove(keyId);
        return outcome;
    }

    public <B extends IBaseBundle, T extends IBaseResource> B search(Class<B> bundleType, Class<T> resourceType, Map<String, List<IQueryParameterType>> searchParameters, Map<String, String> headers) {
        Collection candidates;
        Map resourceIdMap;
        BundleBuilder builder;
        block9: {
            block8: {
                builder = new BundleBuilder(this.context);
                resourceIdMap = this.resourceMap.computeIfAbsent(resourceType.getSimpleName(), r -> new HashMap());
                if (searchParameters == null) break block8;
                if (!searchParameters.isEmpty()) break block9;
            }
            resourceIdMap.values().forEach(arg_0 -> ((BundleBuilder)builder).addCollectionEntry(arg_0));
            builder.setType("searchset");
            return (B)builder.getBundle();
        }
        if (searchParameters.containsKey("_id")) {
            List<IQueryParameterType> idQueries = searchParameters.get("_id");
            searchParameters.remove("_id");
            ArrayList idResources = new ArrayList(idQueries.size());
            for (IQueryParameterType idQuery : idQueries) {
                TokenParam idToken = (TokenParam)idQuery;
                Object id = Ids.newId(this.context, resourceType.getSimpleName(), idToken.getValue());
                IBaseResource r2 = (IBaseResource)resourceIdMap.get(id);
                if (r2 == null) continue;
                idResources.add(r2);
            }
            candidates = idResources;
        } else {
            candidates = resourceIdMap.values();
        }
        ResourceMatcher resourceMatcher = Repositories.getResourceMatcher(this.context);
        for (IBaseResource resource : candidates) {
            boolean include = true;
            for (Map.Entry<String, List<IQueryParameterType>> nextEntry : searchParameters.entrySet()) {
                String paramName = nextEntry.getKey();
                if (resourceMatcher.matches(paramName, nextEntry.getValue(), resource)) continue;
                include = false;
                break;
            }
            if (!include) continue;
            builder.addCollectionEntry(resource);
        }
        builder.setType("searchset");
        return (B)builder.getBundle();
    }

    public <B extends IBaseBundle> B link(Class<B> bundleType, String url, Map<String, String> headers) {
        throw new NotImplementedException("Paging is not currently supported");
    }

    public <C extends IBaseConformance> C capabilities(Class<C> resourceType, Map<String, String> headers) {
        throw new NotImplementedException("The capabilities interaction is not currently supported");
    }

    public <B extends IBaseBundle> B transaction(B transaction, Map<String, String> headers) {
        throw new NotImplementedException("The transaction operation is not currently supported");
    }

    public static <B extends IBaseBundle> B transactionStub(B transaction, Repository repository) {
        FhirVersionEnum version = transaction.getStructureFhirVersionEnum();
        IBaseBundle returnBundle = BundleHelper.newBundle(version);
        BundleHelper.getEntry(transaction).forEach(e -> {
            if (BundleHelper.isEntryRequestPut(version, e)) {
                MethodOutcome outcome = repository.update(BundleHelper.getEntryResource(version, e));
                String location = outcome.getId().getValue();
                BundleHelper.addEntry(returnBundle, BundleHelper.newEntryWithResponse(version, BundleHelper.newResponseWithLocation(version, location)));
            } else if (BundleHelper.isEntryRequestPost(version, e)) {
                MethodOutcome outcome = repository.create(BundleHelper.getEntryResource(version, e));
                String location = outcome.getId().getValue();
                BundleHelper.addEntry(returnBundle, BundleHelper.newEntryWithResponse(version, BundleHelper.newResponseWithLocation(version, location)));
            } else {
                throw new NotImplementedOperationException("Transaction stub only supports PUT or POST");
            }
        });
        return (B)returnBundle;
    }

    public <R extends IBaseResource, P extends IBaseParameters> R invoke(String name, P parameters, Class<R> returnType, Map<String, String> headers) {
        throw new NotImplementedException();
    }

    public <P extends IBaseParameters> MethodOutcome invoke(String name, P parameters, Map<String, String> headers) {
        throw new NotImplementedException();
    }

    public <R extends IBaseResource, P extends IBaseParameters, T extends IBaseResource> R invoke(Class<T> resourceType, String name, P parameters, Class<R> returnType, Map<String, String> headers) {
        return (R)((IBaseResource)this.invokeOperation(name, parameters));
    }

    public <P extends IBaseParameters, T extends IBaseResource> MethodOutcome invoke(Class<T> resourceType, String name, P parameters, Map<String, String> headers) {
        throw new NotImplementedException();
    }

    public <R extends IBaseResource, P extends IBaseParameters, I extends IIdType> R invoke(I id, String name, P parameters, Class<R> returnType, Map<String, String> headers) {
        throw new NotImplementedException();
    }

    public <P extends IBaseParameters, I extends IIdType> MethodOutcome invoke(I id, String name, P parameters, Map<String, String> headers) {
        throw new NotImplementedException();
    }

    public <B extends IBaseBundle, P extends IBaseParameters> B history(P parameters, Class<B> returnType, Map<String, String> headers) {
        throw new NotImplementedException("The history interaction is not currently supported");
    }

    public <B extends IBaseBundle, P extends IBaseParameters, T extends IBaseResource> B history(Class<T> resourceType, P parameters, Class<B> returnType, Map<String, String> headers) {
        throw new NotImplementedException("The history interaction is not currently supported");
    }

    public <B extends IBaseBundle, P extends IBaseParameters, I extends IIdType> B history(I id, P parameters, Class<B> returnType, Map<String, String> headers) {
        throw new NotImplementedException("The history interaction is not currently supported");
    }

    public FhirContext fhirContext() {
        return this.context;
    }

    protected <R> R invokeOperation(String operationName, IBaseParameters parameters) {
        return (R)this.operationMap.get(operationName).apply(parameters);
    }
}

