/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.visitor;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.rest.server.exceptions.NotImplementedOperationException;
import ca.uhn.fhir.rest.server.exceptions.PreconditionFailedException;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.hl7.fhir.dstu3.model.MetadataResource;
import org.hl7.fhir.dstu3.model.RelatedArtifact;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r5.model.IdType;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.utility.BundleHelper;
import org.opencds.cqf.fhir.utility.Canonicals;
import org.opencds.cqf.fhir.utility.SearchHelper;
import org.opencds.cqf.fhir.utility.adapter.AdapterFactory;
import org.opencds.cqf.fhir.utility.adapter.IDependencyInfo;
import org.opencds.cqf.fhir.utility.adapter.KnowledgeArtifactAdapter;
import org.opencds.cqf.fhir.utility.adapter.LibraryAdapter;
import org.opencds.cqf.fhir.utility.adapter.PlanDefinitionAdapter;
import org.opencds.cqf.fhir.utility.adapter.ValueSetAdapter;
import org.opencds.cqf.fhir.utility.r4.PackageHelper;
import org.opencds.cqf.fhir.utility.visitor.KnowledgeArtifactVisitor;
import org.opencds.cqf.fhir.utility.visitor.VisitorHelper;

public class KnowledgeArtifactDraftVisitor
implements KnowledgeArtifactVisitor {
    public IBaseBundle visit(LibraryAdapter library, Repository repository, IBaseParameters draftParameters) {
        FhirVersionEnum fhirVersion = library.get().getStructureFhirVersionEnum();
        String version = VisitorHelper.getParameter("version", draftParameters, IPrimitiveType.class).map(r -> (String)r.getValue()).orElseThrow(() -> new UnprocessableEntityException("The version argument is required"));
        IDomainResource libRes = library.get();
        this.checkVersionValidSemver(version);
        List<IBaseExtension<?, ?>> removeReleaseLabelAndDescription = libRes.getExtension().stream().filter(ext -> !ext.getUrl().equals("http://hl7.org/fhir/StructureDefinition/artifact-releaseDescription") && !ext.getUrl().equals("http://hl7.org/fhir/StructureDefinition/artifact-releaseLabel")).collect(Collectors.toList());
        library.setExtension(removeReleaseLabelAndDescription);
        library.setApprovalDate(null);
        String draftVersion = version + "-draft";
        String draftVersionUrl = Canonicals.getUrl(library.getUrl()) + "|" + draftVersion;
        if (library.getStatus() != "active") {
            throw new PreconditionFailedException(String.format("Drafts can only be created from artifacts with status of 'active'. Resource '%s' has a status of: '%s'", library.getUrl(), library.getStatus()));
        }
        IBaseBundle existingArtifactsForUrl = SearchHelper.searchRepositoryByCanonicalWithPaging(repository, draftVersionUrl);
        if (BundleHelper.getEntry(existingArtifactsForUrl).size() != 0) {
            throw new PreconditionFailedException(String.format("A draft of Program '%s' already exists with version: '%s'. Only one draft of a program version can exist at a time.", library.getUrl(), draftVersionUrl));
        }
        List<IDomainResource> resourcesToCreate = this.createDraftsOfArtifactAndRelated(libRes, repository, version, new ArrayList<IDomainResource>(), fhirVersion);
        IBaseBundle transactionBundle = BundleHelper.newBundle(fhirVersion, null, "transaction");
        List<String> urnList = resourcesToCreate.stream().map(res -> "urn:uuid:" + UUID.randomUUID().toString()).collect(Collectors.toList());
        TreeSet<String> ownedResourceUrls = this.createOwnedResourceUrlCache(resourcesToCreate, fhirVersion);
        for (int i = 0; i < resourcesToCreate.size(); ++i) {
            KnowledgeArtifactAdapter newResourceAdapter = AdapterFactory.forFhirVersion(fhirVersion).createKnowledgeArtifactAdapter(resourcesToCreate.get(i));
            this.updateUsageContextReferencesWithUrns(resourcesToCreate.get(i), resourcesToCreate, urnList, fhirVersion);
            this.updateRelatedArtifactUrlsWithNewVersions(newResourceAdapter.combineComponentsAndDependencies(), draftVersion, ownedResourceUrls);
            IDomainResource updateIdForBundle = newResourceAdapter.copy();
            updateIdForBundle.setId(urnList.get(i));
            BundleHelper.addEntry(transactionBundle, PackageHelper.createEntry((IBaseResource)updateIdForBundle, false));
        }
        return repository.transaction(transactionBundle);
    }

    @Override
    public IBase visit(KnowledgeArtifactAdapter library, Repository repository, IBaseParameters draftParameters) {
        throw new NotImplementedOperationException("Not implemented");
    }

    @Override
    public IBase visit(PlanDefinitionAdapter planDefinition, Repository repository, IBaseParameters operationParameters) {
        throw new NotImplementedOperationException("Not implemented");
    }

    @Override
    public IBase visit(ValueSetAdapter valueSet, Repository repository, IBaseParameters operationParameters) {
        throw new NotImplementedOperationException("Not implemented");
    }

    private List<IDomainResource> createDraftsOfArtifactAndRelated(IDomainResource resource, Repository repository, String version, List<IDomainResource> resourcesToCreate, FhirVersionEnum fhirVersion) {
        String draftVersion = version + "-draft";
        KnowledgeArtifactAdapter sourceResourceAdapter = AdapterFactory.forFhirVersion(fhirVersion).createKnowledgeArtifactAdapter(resource);
        String draftVersionUrl = Canonicals.getUrl(sourceResourceAdapter.getUrl()) + "|" + draftVersion;
        Optional<IDomainResource> existingArtifactsWithMatchingUrl = KnowledgeArtifactAdapter.findLatestVersion(SearchHelper.searchRepositoryByCanonicalWithPaging(repository, draftVersionUrl));
        Optional<KnowledgeArtifactAdapter> draftVersionAlreadyInBundle = resourcesToCreate.stream().map(res -> AdapterFactory.forFhirVersion(fhirVersion).createKnowledgeArtifactAdapter((IDomainResource)res)).filter(a -> a.getUrl().equals(Canonicals.getUrl(draftVersionUrl)) && a.getVersion().equals(draftVersion)).findAny();
        IDomainResource newResource = null;
        if (existingArtifactsWithMatchingUrl.isPresent()) {
            newResource = existingArtifactsWithMatchingUrl.get();
        } else if (draftVersionAlreadyInBundle.isPresent()) {
            newResource = draftVersionAlreadyInBundle.get().get();
        }
        if (newResource == null) {
            sourceResourceAdapter.setEffectivePeriod(null);
            newResource = sourceResourceAdapter.copy();
            KnowledgeArtifactAdapter newResourceAdapter = AdapterFactory.forFhirVersion(fhirVersion).createKnowledgeArtifactAdapter(newResource);
            newResourceAdapter.setStatus("draft");
            newResourceAdapter.setVersion(draftVersion);
            resourcesToCreate.add(newResource);
            List ownedRelatedArtifacts = sourceResourceAdapter.getOwnedRelatedArtifacts();
            for (ICompositeType ra : ownedRelatedArtifacts) {
                this.processReferencedResourceForDraft(repository, ra, version, resourcesToCreate, fhirVersion);
            }
        }
        return resourcesToCreate;
    }

    private void processReferencedResourceForDraft(Repository repository, ICompositeType ra, String version, List<IDomainResource> transactionBundle, FhirVersionEnum fhirVersion) {
        Optional<Object> referencedResource = Optional.empty();
        switch (fhirVersion) {
            case DSTU3: {
                referencedResource = org.opencds.cqf.fhir.utility.visitor.dstu3.KnowledgeArtifactDraftVisitor.processReferencedResourceForDraft(repository, (RelatedArtifact)ra, version).map(r -> r);
                break;
            }
            case R4: {
                referencedResource = org.opencds.cqf.fhir.utility.visitor.r4.KnowledgeArtifactDraftVisitor.processReferencedResourceForDraft(repository, (org.hl7.fhir.r4.model.RelatedArtifact)ra, version).map(r -> r);
                break;
            }
            case R5: {
                referencedResource = org.opencds.cqf.fhir.utility.visitor.r5.KnowledgeArtifactDraftVisitor.processReferencedResourceForDraft(repository, (org.hl7.fhir.r5.model.RelatedArtifact)ra, version).map(r -> r);
                break;
            }
            default: {
                throw new UnprocessableEntityException(String.format("Unsupported version of FHIR: %s", fhirVersion.getFhirVersionString()));
            }
        }
        referencedResource.ifPresent(r -> this.createDraftsOfArtifactAndRelated((IDomainResource)r, repository, version, transactionBundle, fhirVersion));
    }

    private void checkVersionValidSemver(String version) throws UnprocessableEntityException {
        if (version == null || version.isEmpty()) {
            throw new UnprocessableEntityException("The version argument is required");
        }
        if (version.contains("draft")) {
            throw new UnprocessableEntityException("The version cannot contain 'draft'");
        }
        if (version.contains("/") || version.contains("\\") || version.contains("|")) {
            throw new UnprocessableEntityException("The version contains illegal characters");
        }
        Pattern pattern = Pattern.compile("^(\\d+\\.)(\\d+\\.)(\\d+\\.)?(\\*|\\d+)$", 2);
        Matcher matcher = pattern.matcher(version);
        boolean matchFound = matcher.find();
        if (!matchFound) {
            throw new UnprocessableEntityException("The version must be in the format MAJOR.MINOR.PATCH or MAJOR.MINOR.PATCH.REVISION");
        }
    }

    private TreeSet<String> createOwnedResourceUrlCache(List<IDomainResource> resources, FhirVersionEnum fhirVersion) {
        TreeSet<String> retval = new TreeSet<String>();
        resources.stream().map(resource -> AdapterFactory.forFhirVersion(fhirVersion).createKnowledgeArtifactAdapter((IDomainResource)resource)).map(KnowledgeArtifactAdapter::getOwnedRelatedArtifacts).flatMap(Collection::stream).map(x$0 -> KnowledgeArtifactAdapter.getRelatedArtifactReference((ICompositeType)x$0)).filter(r -> r != null).map(Canonicals::getUrl).forEach(retval::add);
        return retval;
    }

    private void updateUsageContextReferencesWithUrns(IDomainResource newResource, List<IDomainResource> resourceListWithOriginalIds, List<String> idListForTransactionBundle, FhirVersionEnum fhirVersion) {
        switch (fhirVersion) {
            case DSTU3: {
                org.opencds.cqf.fhir.utility.visitor.dstu3.KnowledgeArtifactDraftVisitor.updateUsageContextReferencesWithUrns((MetadataResource)newResource, resourceListWithOriginalIds.stream().map(ra -> (MetadataResource)ra).collect(Collectors.toList()), idListForTransactionBundle.stream().map(id -> new org.hl7.fhir.dstu3.model.IdType(id)).collect(Collectors.toList()));
                break;
            }
            case R4: {
                org.opencds.cqf.fhir.utility.visitor.r4.KnowledgeArtifactDraftVisitor.updateUsageContextReferencesWithUrns((org.hl7.fhir.r4.model.MetadataResource)newResource, resourceListWithOriginalIds.stream().map(ra -> (org.hl7.fhir.r4.model.MetadataResource)ra).collect(Collectors.toList()), idListForTransactionBundle.stream().map(id -> new org.hl7.fhir.r4.model.IdType(id)).collect(Collectors.toList()));
                break;
            }
            case R5: {
                org.opencds.cqf.fhir.utility.visitor.r5.KnowledgeArtifactDraftVisitor.updateUsageContextReferencesWithUrns((org.hl7.fhir.r5.model.MetadataResource)newResource, resourceListWithOriginalIds.stream().map(ra -> (org.hl7.fhir.r5.model.MetadataResource)ra).collect(Collectors.toList()), idListForTransactionBundle.stream().map(id -> new IdType(id)).collect(Collectors.toList()));
                break;
            }
            default: {
                throw new UnprocessableEntityException(String.format("Unsupported version of FHIR: %s", fhirVersion.getFhirVersionString()));
            }
        }
    }

    private void updateRelatedArtifactUrlsWithNewVersions(List<IDependencyInfo> referenceList, String updatedVersion, TreeSet<String> ownedUrlCache) {
        referenceList.stream().filter(ra -> ownedUrlCache.contains(Canonicals.getUrl(ra.getReference()))).collect(Collectors.toList()).replaceAll(ra -> {
            ra.setReference(Canonicals.getUrl(ra.getReference()) + "|" + updatedVersion);
            return ra;
        });
    }
}

