/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.visitor;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.NotImplementedOperationException;
import ca.uhn.fhir.rest.server.exceptions.PreconditionFailedException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.dstu3.model.MetadataResource;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.Period;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.utility.BundleHelper;
import org.opencds.cqf.fhir.utility.Canonicals;
import org.opencds.cqf.fhir.utility.PackageHelper;
import org.opencds.cqf.fhir.utility.SearchHelper;
import org.opencds.cqf.fhir.utility.adapter.AdapterFactory;
import org.opencds.cqf.fhir.utility.adapter.IDependencyInfo;
import org.opencds.cqf.fhir.utility.adapter.KnowledgeArtifactAdapter;
import org.opencds.cqf.fhir.utility.adapter.LibraryAdapter;
import org.opencds.cqf.fhir.utility.adapter.PlanDefinitionAdapter;
import org.opencds.cqf.fhir.utility.adapter.ValueSetAdapter;
import org.opencds.cqf.fhir.utility.dstu3.CRMIReleaseExperimentalBehavior;
import org.opencds.cqf.fhir.utility.r4.CRMIReleaseExperimentalBehavior;
import org.opencds.cqf.fhir.utility.r5.CRMIReleaseExperimentalBehavior;
import org.opencds.cqf.fhir.utility.visitor.KnowledgeArtifactVisitor;
import org.opencds.cqf.fhir.utility.visitor.VisitorHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KnowledgeArtifactReleaseVisitor
implements KnowledgeArtifactVisitor {
    private Logger log = LoggerFactory.getLogger(KnowledgeArtifactReleaseVisitor.class);

    @Override
    public IBase visit(LibraryAdapter rootLibraryAdapter, Repository repository, IBaseParameters operationParameters) {
        Optional<Boolean> latestFromTxServer = VisitorHelper.getParameter("latestFromTxServer", operationParameters, IPrimitiveType.class).map(t -> (Boolean)t.getValue());
        if (latestFromTxServer.isPresent()) {
            throw new NotImplementedOperationException("Support for 'latestFromTxServer' is not yet implemented.");
        }
        String version = VisitorHelper.getParameter("version", operationParameters, IPrimitiveType.class).map(t -> (String)t.getValue()).orElseThrow(() -> new UnprocessableEntityException("Version must be present"));
        String releaseLabel = VisitorHelper.getParameter("releaseLabel", operationParameters, IPrimitiveType.class).map(t -> (String)t.getValue()).orElse("");
        Optional<String> versionBehavior = VisitorHelper.getParameter("versionBehavior", operationParameters, IPrimitiveType.class).map(t -> (String)t.getValue());
        Optional<String> requireNonExpermimental = VisitorHelper.getParameter("requireNonExperimental", operationParameters, IPrimitiveType.class).map(t -> (String)t.getValue());
        this.checkReleaseVersion(version, versionBehavior);
        IDomainResource rootLibrary = rootLibraryAdapter.get();
        FhirVersionEnum fhirVersion = rootLibrary.getStructureFhirVersionEnum();
        Date currentApprovalDate = rootLibraryAdapter.getApprovalDate();
        this.checkReleasePreconditions(rootLibraryAdapter, currentApprovalDate);
        String existingVersion = rootLibraryAdapter.hasVersion() ? rootLibraryAdapter.getVersion().replace("-draft", "") : null;
        String releaseVersion = this.getReleaseVersion(version, versionBehavior, existingVersion, fhirVersion).orElseThrow(() -> new UnprocessableEntityException("Could not resolve a version for the root artifact."));
        ICompositeType rootEffectivePeriod = rootLibraryAdapter.getEffectivePeriod();
        if (rootLibraryAdapter.getExperimental()) {
            requireNonExpermimental = Optional.of("none");
        }
        List<IDomainResource> releasedResources = this.internalRelease(rootLibraryAdapter, releaseVersion, rootEffectivePeriod, latestFromTxServer.orElse(false), requireNonExpermimental, repository);
        this.updateReleaseLabel((IBaseResource)rootLibrary, releaseLabel);
        ArrayList<IDependencyInfo> rootArtifactOriginalDependencies = new ArrayList<IDependencyInfo>(rootLibraryAdapter.getDependencies());
        List originalDependenciesWithExtensions = rootArtifactOriginalDependencies.stream().filter(dep -> dep.getExtension() != null && dep.getExtension().size() > 0).collect(Collectors.toList());
        rootLibraryAdapter.getRelatedArtifact().removeIf(ra -> KnowledgeArtifactAdapter.getRelatedArtifactType(ra).equalsIgnoreCase("depends-on"));
        IBaseBundle transactionBundle = BundleHelper.newBundle(fhirVersion, null, "transaction");
        for (IDomainResource artifact : releasedResources) {
            String updatedReference;
            KnowledgeArtifactAdapter adapter;
            IBaseBackboneElement entry2 = PackageHelper.createEntry((IBaseResource)artifact, true);
            BundleHelper.addEntry(transactionBundle, entry2);
            KnowledgeArtifactAdapter artifactAdapter = AdapterFactory.forFhirVersion(fhirVersion).createKnowledgeArtifactAdapter(artifact);
            List components = artifactAdapter.getComponents();
            for (ICompositeType component : components) {
                String relatedArtifactReference = KnowledgeArtifactAdapter.getRelatedArtifactReference(component);
                if (KnowledgeArtifactAdapter.checkIfRelatedArtifactIsOwned(component)) {
                    IDomainResource resource = this.checkIfReferenceInList(relatedArtifactReference, releasedResources).orElseThrow(() -> new InternalErrorException("Owned resource reference not found during release"));
                    adapter = AdapterFactory.forFhirVersion(resource.getStructureFhirVersionEnum()).createKnowledgeArtifactAdapter(resource);
                    String reference = String.format("%s|%s", adapter.getUrl(), adapter.getVersion());
                    KnowledgeArtifactAdapter.setRelatedArtifactReference(component, reference);
                } else if (Canonicals.getVersion(relatedArtifactReference) == null || Canonicals.getVersion(relatedArtifactReference).isEmpty()) {
                    updatedReference = this.tryUpdateReferenceToLatestActiveVersion(relatedArtifactReference, repository, artifactAdapter.getUrl());
                    KnowledgeArtifactAdapter.setRelatedArtifactReference(component, updatedReference);
                }
                Object componentToDependency = KnowledgeArtifactAdapter.newRelatedArtifact(fhirVersion, "depends-on", relatedArtifactReference);
                rootLibraryAdapter.getRelatedArtifact().add(componentToDependency);
            }
            List<IDependencyInfo> dependencies = artifactAdapter.getDependencies();
            for (IDependencyInfo dependency : dependencies) {
                Optional<IDomainResource> maybeReference = this.checkIfReferenceInList(dependency, releasedResources);
                if (maybeReference.isPresent()) {
                    adapter = AdapterFactory.forFhirVersion(fhirVersion).createKnowledgeArtifactAdapter(maybeReference.get());
                    String updatedReference2 = adapter.hasVersion() ? String.format("%s|%s", adapter.getUrl(), adapter.getVersion()) : adapter.getUrl();
                    dependency.setReference(updatedReference2);
                } else if (Canonicals.getVersion(dependency.getReference()) == null || Canonicals.getVersion(dependency.getReference()).isEmpty()) {
                    updatedReference = this.tryUpdateReferenceToLatestActiveVersion(dependency.getReference(), repository, artifactAdapter.getUrl());
                    dependency.setReference(updatedReference);
                }
                if (artifactAdapter.getUrl().equals(rootLibraryAdapter.getUrl())) continue;
                Object newDep = KnowledgeArtifactAdapter.newRelatedArtifact(fhirVersion, "depends-on", dependency.getReference());
                rootLibraryAdapter.getRelatedArtifact().add(newDep);
            }
        }
        List relatedArtifacts = rootLibraryAdapter.getRelatedArtifact();
        ArrayList distinctResolvedRelatedArtifacts = new ArrayList(relatedArtifacts);
        distinctResolvedRelatedArtifacts.clear();
        for (ICompositeType resolvedRelatedArtifact : relatedArtifacts) {
            String relatedArtifactReference = KnowledgeArtifactAdapter.getRelatedArtifactReference(resolvedRelatedArtifact);
            boolean isDistinct = !distinctResolvedRelatedArtifacts.stream().anyMatch(distinctRelatedArtifact -> {
                boolean referenceNotInArray = relatedArtifactReference.equals(KnowledgeArtifactAdapter.getRelatedArtifactReference(distinctRelatedArtifact));
                boolean typeMatches = KnowledgeArtifactAdapter.getRelatedArtifactType(distinctRelatedArtifact).equals(KnowledgeArtifactAdapter.getRelatedArtifactType(resolvedRelatedArtifact));
                return referenceNotInArray && typeMatches;
            });
            if (!isDistinct) continue;
            distinctResolvedRelatedArtifacts.add(resolvedRelatedArtifact);
            originalDependenciesWithExtensions.stream().filter(originalDep -> originalDep.getReference().equals(relatedArtifactReference)).findFirst().ifPresent(dep -> {
                ((IBaseHasExtensions)resolvedRelatedArtifact).getExtension().addAll(dep.getExtension());
                originalDependenciesWithExtensions.removeIf(ra -> ra.getReference().equals(relatedArtifactReference));
            });
        }
        this.findArtifactCommentsToUpdate((IBaseResource)rootLibrary, releaseVersion, repository).forEach(entry -> BundleHelper.addEntry(transactionBundle, entry));
        rootLibraryAdapter.setRelatedArtifact(distinctResolvedRelatedArtifacts);
        return repository.transaction(transactionBundle);
    }

    private List<IDomainResource> internalRelease(KnowledgeArtifactAdapter artifactAdapter, String version, ICompositeType rootEffectivePeriod, boolean latestFromTxServer, Optional<String> experimentalBehavior, Repository repository) throws NotImplementedOperationException, ResourceNotFoundException {
        ArrayList<IDomainResource> resourcesToUpdate = new ArrayList<IDomainResource>();
        artifactAdapter.setDate(new Date());
        artifactAdapter.setStatus("active");
        artifactAdapter.setVersion(version);
        this.propagageEffectivePeriod(rootEffectivePeriod, artifactAdapter);
        resourcesToUpdate.add(artifactAdapter.get());
        List ownedRelatedArtifacts = artifactAdapter.getOwnedRelatedArtifacts();
        for (ICompositeType ownedRelatedArtifact : ownedRelatedArtifacts) {
            Boolean alreadyUpdated;
            String ownedRelatedArtifactReference = KnowledgeArtifactAdapter.getRelatedArtifactReference(ownedRelatedArtifact);
            if (StringUtils.isBlank((CharSequence)ownedRelatedArtifactReference) || (alreadyUpdated = Boolean.valueOf(resourcesToUpdate.stream().map(resource -> AdapterFactory.forFhirVersion(resource.getStructureFhirVersionEnum()).createKnowledgeArtifactAdapter((IDomainResource)resource)).filter(r -> r.getUrl().equals(Canonicals.getUrl(ownedRelatedArtifactReference))).findAny().isPresent())).booleanValue()) continue;
            IDomainResource referencedResource = KnowledgeArtifactAdapter.findLatestVersion(SearchHelper.searchRepositoryByCanonicalWithPaging(repository, ownedRelatedArtifactReference)).orElseThrow(() -> new ResourceNotFoundException(String.format("Resource with URL '%s' is Owned by this repository and referenced by resource '%s', but was not found on the server.", ownedRelatedArtifactReference, artifactAdapter.getUrl())));
            KnowledgeArtifactAdapter searchResultAdapter = AdapterFactory.forFhirVersion(referencedResource.getStructureFhirVersionEnum()).createKnowledgeArtifactAdapter(referencedResource);
            this.checkNonExperimental(referencedResource, experimentalBehavior, repository);
            resourcesToUpdate.addAll(this.internalRelease(searchResultAdapter, version, rootEffectivePeriod, latestFromTxServer, experimentalBehavior, repository));
        }
        return resourcesToUpdate;
    }

    private void checkNonExperimental(IDomainResource resource, Optional<String> experimentalBehavior, Repository repository) throws UnprocessableEntityException {
        if (resource instanceof MetadataResource) {
            CRMIReleaseExperimentalBehavior.CRMIReleaseExperimentalBehaviorCodes code = experimentalBehavior.isPresent() ? CRMIReleaseExperimentalBehavior.CRMIReleaseExperimentalBehaviorCodes.fromCode(experimentalBehavior.get()) : CRMIReleaseExperimentalBehavior.CRMIReleaseExperimentalBehaviorCodes.NULL;
            org.opencds.cqf.fhir.utility.visitor.dstu3.KnowledgeArtifactReleaseVisitor.checkNonExperimental((MetadataResource)resource, code, repository, this.log);
        } else if (resource instanceof org.hl7.fhir.r4.model.MetadataResource) {
            CRMIReleaseExperimentalBehavior.CRMIReleaseExperimentalBehaviorCodes code = experimentalBehavior.isPresent() ? CRMIReleaseExperimentalBehavior.CRMIReleaseExperimentalBehaviorCodes.fromCode(experimentalBehavior.get()) : CRMIReleaseExperimentalBehavior.CRMIReleaseExperimentalBehaviorCodes.NULL;
            org.opencds.cqf.fhir.utility.visitor.r4.KnowledgeArtifactReleaseVisitor.checkNonExperimental((org.hl7.fhir.r4.model.MetadataResource)resource, code, repository, this.log);
        } else if (resource instanceof org.hl7.fhir.r5.model.MetadataResource) {
            CRMIReleaseExperimentalBehavior.CRMIReleaseExperimentalBehaviorCodes code = experimentalBehavior.isPresent() ? CRMIReleaseExperimentalBehavior.CRMIReleaseExperimentalBehaviorCodes.fromCode(experimentalBehavior.get()) : CRMIReleaseExperimentalBehavior.CRMIReleaseExperimentalBehaviorCodes.NULL;
            org.opencds.cqf.fhir.utility.visitor.r5.KnowledgeArtifactReleaseVisitor.checkNonExperimental((org.hl7.fhir.r5.model.MetadataResource)resource, code, repository, this.log);
        } else {
            throw new UnprocessableEntityException(resource.getClass().getName() + " not supported");
        }
    }

    private void propagageEffectivePeriod(ICompositeType rootEffectivePeriod, KnowledgeArtifactAdapter artifactAdapter) {
        if (rootEffectivePeriod instanceof org.hl7.fhir.dstu3.model.Period) {
            org.opencds.cqf.fhir.utility.visitor.dstu3.KnowledgeArtifactReleaseVisitor.propagageEffectivePeriod((org.hl7.fhir.dstu3.model.Period)rootEffectivePeriod, artifactAdapter);
        } else if (rootEffectivePeriod instanceof Period) {
            org.opencds.cqf.fhir.utility.visitor.r4.KnowledgeArtifactReleaseVisitor.propagageEffectivePeriod((Period)rootEffectivePeriod, artifactAdapter);
        } else if (rootEffectivePeriod instanceof org.hl7.fhir.r5.model.Period) {
            org.opencds.cqf.fhir.utility.visitor.r5.KnowledgeArtifactReleaseVisitor.propagageEffectivePeriod((org.hl7.fhir.r5.model.Period)rootEffectivePeriod, artifactAdapter);
        } else {
            throw new UnprocessableEntityException(rootEffectivePeriod.getClass().getName() + " not supported");
        }
    }

    private String tryUpdateReferenceToLatestActiveVersion(String inputReference, Repository repository, String sourceArtifactUrl) throws ResourceNotFoundException {
        List matchingResources = VisitorHelper.getMetadataResourcesFromBundle(SearchHelper.searchRepositoryByCanonicalWithPaging(repository, inputReference)).stream().map(r -> AdapterFactory.forFhirVersion(r.getStructureFhirVersionEnum()).createKnowledgeArtifactAdapter((IDomainResource)r)).filter(a -> a.getStatus().equals("active")).collect(Collectors.toList());
        if (matchingResources.isEmpty()) {
            return inputReference;
        }
        matchingResources.sort(Comparator.comparing(r -> ((KnowledgeArtifactAdapter)r).getVersion()).reversed());
        KnowledgeArtifactAdapter latestActiveVersion = (KnowledgeArtifactAdapter)matchingResources.get(0);
        String latestActiveReference = latestActiveVersion.hasVersion() ? String.format("%s|%s", latestActiveVersion.getUrl(), latestActiveVersion.getVersion()) : latestActiveVersion.getUrl();
        return latestActiveReference;
    }

    private Optional<String> getReleaseVersion(String version, Optional<String> versionBehavior, String existingVersion, FhirVersionEnum fhirVersion) throws UnprocessableEntityException {
        switch (fhirVersion) {
            case DSTU3: {
                return org.opencds.cqf.fhir.utility.visitor.dstu3.KnowledgeArtifactReleaseVisitor.getReleaseVersion(version, versionBehavior, existingVersion);
            }
            case R4: {
                return org.opencds.cqf.fhir.utility.visitor.r4.KnowledgeArtifactReleaseVisitor.getReleaseVersion(version, versionBehavior, existingVersion);
            }
            case R5: {
                return org.opencds.cqf.fhir.utility.visitor.r5.KnowledgeArtifactReleaseVisitor.getReleaseVersion(version, versionBehavior, existingVersion);
            }
        }
        throw new UnprocessableEntityException(String.format("Unsupported version of FHIR: %s", fhirVersion.getFhirVersionString()));
    }

    private void updateReleaseLabel(IBaseResource artifact, String releaseLabel) throws IllegalArgumentException {
        if (artifact instanceof MetadataResource) {
            org.opencds.cqf.fhir.utility.visitor.dstu3.KnowledgeArtifactReleaseVisitor.updateReleaseLabel((MetadataResource)artifact, releaseLabel);
        } else if (artifact instanceof org.hl7.fhir.r4.model.MetadataResource) {
            org.opencds.cqf.fhir.utility.visitor.r4.KnowledgeArtifactReleaseVisitor.updateReleaseLabel((org.hl7.fhir.r4.model.MetadataResource)artifact, releaseLabel);
        } else if (artifact instanceof org.hl7.fhir.r5.model.MetadataResource) {
            org.opencds.cqf.fhir.utility.visitor.r5.KnowledgeArtifactReleaseVisitor.updateReleaseLabel((org.hl7.fhir.r5.model.MetadataResource)artifact, releaseLabel);
        } else {
            throw new UnprocessableEntityException(artifact.getClass().getName() + " not supported");
        }
    }

    private Optional<IDomainResource> checkIfReferenceInList(String referenceToCheck, List<IDomainResource> resourceList) {
        Optional<Object> updatedReference = Optional.ofNullable(null);
        for (IDomainResource resource : resourceList) {
            String currentResourceURL;
            String referenceURL = Canonicals.getUrl(referenceToCheck);
            if (!referenceURL.equals(currentResourceURL = AdapterFactory.forFhirVersion(resource.getStructureFhirVersionEnum()).createKnowledgeArtifactAdapter(resource).getUrl())) continue;
            return Optional.of(resource);
        }
        return updatedReference;
    }

    private Optional<IDomainResource> checkIfReferenceInList(IDependencyInfo artifactToUpdate, List<IDomainResource> resourceList) {
        Optional<Object> updatedReference = Optional.ofNullable(null);
        for (IDomainResource resource : resourceList) {
            String currentResourceURL;
            String referenceURL = Canonicals.getUrl(artifactToUpdate.getReference());
            if (!referenceURL.equals(currentResourceURL = AdapterFactory.forFhirVersion(resource.getStructureFhirVersionEnum()).createKnowledgeArtifactAdapter(resource).getUrl())) continue;
            return Optional.of(resource);
        }
        return updatedReference;
    }

    private void checkReleasePreconditions(KnowledgeArtifactAdapter artifact, Date approvalDate) throws PreconditionFailedException {
        if (artifact == null) {
            throw new ResourceNotFoundException("Resource not found.");
        }
        if (!artifact.getStatus().equals("draft")) {
            throw new PreconditionFailedException(String.format("Resource with ID: '%s' does not have a status of 'draft'.", artifact.get().getIdElement().getIdPart()));
        }
        if (approvalDate == null) {
            throw new PreconditionFailedException(String.format("The artifact must be approved (indicated by approvalDate) before it is eligible for release.", new Object[0]));
        }
        if (approvalDate.before(artifact.getDate())) {
            throw new PreconditionFailedException(String.format("The artifact was approved on '%s', but was last modified on '%s'. An approval must be provided after the most-recent update.", approvalDate, artifact.getDate()));
        }
    }

    private List<IBaseBackboneElement> findArtifactCommentsToUpdate(IBaseResource artifact, String releaseVersion, Repository repository) {
        if (artifact instanceof MetadataResource) {
            return org.opencds.cqf.fhir.utility.visitor.dstu3.KnowledgeArtifactReleaseVisitor.findArtifactCommentsToUpdate((MetadataResource)artifact, releaseVersion, repository).stream().map(r -> r).collect(Collectors.toList());
        }
        if (artifact instanceof org.hl7.fhir.r4.model.MetadataResource) {
            return org.opencds.cqf.fhir.utility.visitor.r4.KnowledgeArtifactReleaseVisitor.findArtifactCommentsToUpdate((org.hl7.fhir.r4.model.MetadataResource)artifact, releaseVersion, repository).stream().map(r -> r).collect(Collectors.toList());
        }
        if (artifact instanceof org.hl7.fhir.r5.model.MetadataResource) {
            return org.opencds.cqf.fhir.utility.visitor.r5.KnowledgeArtifactReleaseVisitor.findArtifactCommentsToUpdate((org.hl7.fhir.r5.model.MetadataResource)artifact, releaseVersion, repository).stream().map(r -> r).collect(Collectors.toList());
        }
        throw new UnprocessableEntityException("Version not supported");
    }

    private void checkReleaseVersion(String version, Optional<String> versionBehavior) throws UnprocessableEntityException {
        if (!versionBehavior.isPresent()) {
            throw new UnprocessableEntityException("'versionBehavior' must be provided as an argument to the $release operation. Valid values are 'default', 'check', 'force'.");
        }
        this.checkVersionValidSemver(version);
    }

    private void checkVersionValidSemver(String version) throws UnprocessableEntityException {
        if (version == null || version.isEmpty()) {
            throw new UnprocessableEntityException("The version argument is required");
        }
        if (version.contains("draft")) {
            throw new UnprocessableEntityException("The version cannot contain 'draft'");
        }
        if (version.contains("/") || version.contains("\\") || version.contains("|")) {
            throw new UnprocessableEntityException("The version contains illegal characters");
        }
        Pattern pattern = Pattern.compile("^(\\d+\\.)(\\d+\\.)(\\d+\\.)?(\\*|\\d+)$", 2);
        Matcher matcher = pattern.matcher(version);
        boolean matchFound = matcher.find();
        if (!matchFound) {
            throw new UnprocessableEntityException("The version must be in the format MAJOR.MINOR.PATCH or MAJOR.MINOR.PATCH.REVISION");
        }
    }

    @Override
    public IBase visit(PlanDefinitionAdapter valueSet, Repository repository, IBaseParameters operationParameters) {
        throw new NotImplementedOperationException("Not implemented");
    }

    @Override
    public IBase visit(ValueSetAdapter valueSet, Repository repository, IBaseParameters operationParameters) {
        throw new NotImplementedOperationException("Not implemented");
    }

    @Override
    public IBase visit(KnowledgeArtifactAdapter knowledgeArtifactAdapter, Repository repository, IBaseParameters operationParameters) {
        throw new NotImplementedOperationException("Not implemented");
    }
}

