/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.visitor.r4;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Library;
import org.hl7.fhir.r4.model.MetadataResource;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StructureDefinition;

public class KnowledgeArtifactPackageVisitor {
    public static final List<ResourceType> canonicalResourceTypes = Collections.unmodifiableList(new ArrayList<ResourceType>(Arrays.asList(ResourceType.ActivityDefinition, ResourceType.CapabilityStatement, ResourceType.ChargeItemDefinition, ResourceType.CompartmentDefinition, ResourceType.ConceptMap, ResourceType.EffectEvidenceSynthesis, ResourceType.EventDefinition, ResourceType.Evidence, ResourceType.EvidenceVariable, ResourceType.ExampleScenario, ResourceType.GraphDefinition, ResourceType.ImplementationGuide, ResourceType.Library, ResourceType.Measure, ResourceType.MessageDefinition, ResourceType.NamingSystem, ResourceType.OperationDefinition, ResourceType.PlanDefinition, ResourceType.Questionnaire, ResourceType.ResearchDefinition, ResourceType.ResearchElementDefinition, ResourceType.RiskEvidenceSynthesis, ResourceType.SearchParameter, ResourceType.StructureDefinition, ResourceType.StructureMap, ResourceType.TerminologyCapabilities, ResourceType.TestScript, ResourceType.ValueSet)));
    public static final List<ResourceType> conformanceResourceTypes = Collections.unmodifiableList(new ArrayList<ResourceType>(Arrays.asList(ResourceType.CapabilityStatement, ResourceType.StructureDefinition, ResourceType.ImplementationGuide, ResourceType.SearchParameter, ResourceType.MessageDefinition, ResourceType.OperationDefinition, ResourceType.CompartmentDefinition, ResourceType.StructureMap, ResourceType.GraphDefinition, ResourceType.ExampleScenario)));
    public static final List<ResourceType> knowledgeArtifactResourceTypes = Collections.unmodifiableList(new ArrayList<ResourceType>(Arrays.asList(ResourceType.Library, ResourceType.Measure, ResourceType.ActivityDefinition, ResourceType.PlanDefinition)));
    public static final List<ResourceType> terminologyResourceTypes = Collections.unmodifiableList(new ArrayList<ResourceType>(Arrays.asList(ResourceType.CodeSystem, ResourceType.ValueSet, ResourceType.ConceptMap, ResourceType.NamingSystem, ResourceType.TerminologyCapabilities)));

    public static void setCorrectBundleType(Optional<Integer> count, Optional<Integer> offset, Bundle bundle) {
        if (count.isPresent() && count.get() == 0) {
            bundle.setType(Bundle.BundleType.SEARCHSET);
            bundle.setTotal(bundle.getEntry().size());
        } else if (offset.isPresent() && offset.get() > 0 || count.isPresent() && count.get() < bundle.getEntry().size()) {
            bundle.setType(Bundle.BundleType.COLLECTION);
            List removedRequest = bundle.getEntry().stream().map(entry -> {
                entry.setRequest(null);
                return entry;
            }).collect(Collectors.toList());
            bundle.setEntry(removedRequest);
        } else {
            bundle.setType(Bundle.BundleType.TRANSACTION);
        }
    }

    public static List<Bundle.BundleEntryComponent> findUnsupportedInclude(List<Bundle.BundleEntryComponent> entries, List<String> include) {
        if (include == null || include.isEmpty() || include.stream().anyMatch(includedType -> includedType.equals("all"))) {
            return entries;
        }
        ArrayList filteredList = new ArrayList();
        entries.stream().forEach(entry -> {
            Boolean resourceIsConformanceType;
            Boolean resourceIsTerminologyType;
            Boolean resourceIsCanonicalType;
            Boolean resourceIsKnowledgeType;
            if (include.stream().anyMatch(type -> type.equals("knowledge")) && (resourceIsKnowledgeType = Boolean.valueOf(knowledgeArtifactResourceTypes.contains(entry.getResource().getResourceType()))).booleanValue()) {
                filteredList.add(entry);
            }
            if (include.stream().anyMatch(type -> type.equals("canonical")) && (resourceIsCanonicalType = Boolean.valueOf(canonicalResourceTypes.contains(entry.getResource().getResourceType()))).booleanValue()) {
                filteredList.add(entry);
            }
            if (include.stream().anyMatch(type -> type.equals("terminology")) && (resourceIsTerminologyType = Boolean.valueOf(terminologyResourceTypes.contains(entry.getResource().getResourceType()))).booleanValue()) {
                filteredList.add(entry);
            }
            if (include.stream().anyMatch(type -> type.equals("conformance")) && (resourceIsConformanceType = Boolean.valueOf(conformanceResourceTypes.contains(entry.getResource().getResourceType()))).booleanValue()) {
                filteredList.add(entry);
            }
            if (include.stream().anyMatch(type -> type.equals("extensions")) && entry.getResource().getResourceType().equals((Object)ResourceType.StructureDefinition) && ((StructureDefinition)entry.getResource()).getType().equals("Extension")) {
                filteredList.add(entry);
            }
            if (include.stream().anyMatch(type -> type.equals("profiles")) && entry.getResource().getResourceType().equals((Object)ResourceType.StructureDefinition) && !((StructureDefinition)entry.getResource()).getType().equals("Extension")) {
                filteredList.add(entry);
            }
            if (include.stream().anyMatch(type -> type.equals("tests"))) {
                if (entry.getResource().getResourceType().equals((Object)ResourceType.Library) && ((Library)entry.getResource()).getType().getCoding().stream().anyMatch(coding -> coding.getCode().equals("test-case"))) {
                    filteredList.add(entry);
                } else if (((MetadataResource)entry.getResource()).getExtension().stream().anyMatch(ext -> ext.getUrl().contains("isTestCase") && (Boolean)((BooleanType)ext.getValue()).getValue() != false)) {
                    filteredList.add(entry);
                }
            }
            if (include.stream().anyMatch(type -> type.equals("examples")) && ((MetadataResource)entry.getResource()).getExtension().stream().anyMatch(ext -> ext.getUrl().contains("isExample") && (Boolean)((BooleanType)ext.getValue()).getValue() != false)) {
                filteredList.add(entry);
            }
        });
        ArrayList<Bundle.BundleEntryComponent> distinctFilteredEntries = new ArrayList<Bundle.BundleEntryComponent>();
        for (Bundle.BundleEntryComponent entry2 : filteredList) {
            if (distinctFilteredEntries.stream().map(e -> (MetadataResource)e.getResource()).anyMatch(existingEntry -> existingEntry.getUrl().equals(((MetadataResource)entry2.getResource()).getUrl()) && existingEntry.getVersion().equals(((MetadataResource)entry2.getResource()).getVersion()))) continue;
            distinctFilteredEntries.add(entry2);
        }
        return distinctFilteredEntries;
    }
}

