/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.rest.api.RestSearchParameterTypeEnum;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hl7.fhir.dstu3.model.Bundle;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.SearchParameter;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.opencds.cqf.fhir.utility.Canonicals;

public class BundleHelper {
    private static final String UNSUPPORTED_VERSION_OF_FHIR = "Unsupported version of FHIR: %s";

    private BundleHelper() {
    }

    public static IBaseBackboneElement getEntryFirstRep(IBaseBundle bundle) {
        FhirVersionEnum fhirVersion = bundle.getStructureFhirVersionEnum();
        switch (fhirVersion) {
            case DSTU3: {
                return ((org.hl7.fhir.dstu3.model.Bundle)bundle).getEntryFirstRep();
            }
            case R4: {
                return ((Bundle)bundle).getEntryFirstRep();
            }
            case R5: {
                return ((org.hl7.fhir.r5.model.Bundle)bundle).getEntryFirstRep();
            }
        }
        throw new IllegalArgumentException(UNSUPPORTED_VERSION_OF_FHIR.formatted(fhirVersion.getFhirVersionString()));
    }

    public static IBaseResource getEntryResourceFirstRep(IBaseBundle bundle) {
        FhirVersionEnum fhirVersion = bundle.getStructureFhirVersionEnum();
        switch (fhirVersion) {
            case DSTU3: {
                Bundle.BundleEntryComponent dstu3Entry = ((org.hl7.fhir.dstu3.model.Bundle)bundle).getEntryFirstRep();
                return dstu3Entry != null && dstu3Entry.hasResource() ? dstu3Entry.getResource() : null;
            }
            case R4: {
                Bundle.BundleEntryComponent r4Entry = ((Bundle)bundle).getEntryFirstRep();
                return r4Entry != null && r4Entry.hasResource() ? r4Entry.getResource() : null;
            }
            case R5: {
                Bundle.BundleEntryComponent r5Entry = ((org.hl7.fhir.r5.model.Bundle)bundle).getEntryFirstRep();
                return r5Entry != null && r5Entry.hasResource() ? r5Entry.getResource() : null;
            }
        }
        throw new IllegalArgumentException(UNSUPPORTED_VERSION_OF_FHIR.formatted(fhirVersion.getFhirVersionString()));
    }

    public static List<IBaseResource> getEntryResources(IBaseBundle bundle) {
        ArrayList<IBaseResource> resources = new ArrayList<IBaseResource>();
        FhirVersionEnum fhirVersion = bundle.getStructureFhirVersionEnum();
        switch (fhirVersion) {
            case DSTU3: {
                List dstu3Entry = ((org.hl7.fhir.dstu3.model.Bundle)bundle).getEntry();
                dstu3Entry.stream().filter(Bundle.BundleEntryComponent::hasResource).forEach(entry -> resources.add((IBaseResource)entry.getResource()));
                break;
            }
            case R4: {
                List r4Entry = ((Bundle)bundle).getEntry();
                r4Entry.stream().filter(Bundle.BundleEntryComponent::hasResource).forEach(entry -> resources.add((IBaseResource)entry.getResource()));
                break;
            }
            case R5: {
                List r5Entry = ((org.hl7.fhir.r5.model.Bundle)bundle).getEntry();
                r5Entry.stream().filter(Bundle.BundleEntryComponent::hasResource).forEach(entry -> resources.add((IBaseResource)entry.getResource()));
                break;
            }
            default: {
                throw new IllegalArgumentException(UNSUPPORTED_VERSION_OF_FHIR.formatted(fhirVersion.getFhirVersionString()));
            }
        }
        return resources;
    }

    public static IBaseResource getEntryResource(FhirVersionEnum fhirVersion, IBaseBackboneElement entry) {
        switch (fhirVersion) {
            case DSTU3: {
                return ((Bundle.BundleEntryComponent)entry).getResource();
            }
            case R4: {
                return ((Bundle.BundleEntryComponent)entry).getResource();
            }
            case R5: {
                return ((Bundle.BundleEntryComponent)entry).getResource();
            }
        }
        throw new IllegalArgumentException(UNSUPPORTED_VERSION_OF_FHIR.formatted(fhirVersion.getFhirVersionString()));
    }

    public static boolean isEntryRequestPut(FhirVersionEnum fhirVersion, IBaseBackboneElement entry) {
        switch (fhirVersion) {
            case DSTU3: {
                return Optional.ofNullable(((Bundle.BundleEntryComponent)entry).getRequest()).map(r -> r.getMethod()).filter(r -> r == Bundle.HTTPVerb.PUT).isPresent();
            }
            case R4: {
                return Optional.ofNullable(((Bundle.BundleEntryComponent)entry).getRequest()).map(r -> r.getMethod()).filter(r -> r == Bundle.HTTPVerb.PUT).isPresent();
            }
            case R5: {
                return Optional.ofNullable(((Bundle.BundleEntryComponent)entry).getRequest()).map(r -> r.getMethod()).filter(r -> r == Bundle.HTTPVerb.PUT).isPresent();
            }
        }
        throw new IllegalArgumentException(UNSUPPORTED_VERSION_OF_FHIR.formatted(fhirVersion.getFhirVersionString()));
    }

    public static boolean isEntryRequestPost(FhirVersionEnum fhirVersion, IBaseBackboneElement entry) {
        switch (fhirVersion) {
            case DSTU3: {
                return Optional.ofNullable(((Bundle.BundleEntryComponent)entry).getRequest()).map(r -> r.getMethod()).filter(r -> r == Bundle.HTTPVerb.POST).isPresent();
            }
            case R4: {
                return Optional.ofNullable(((Bundle.BundleEntryComponent)entry).getRequest()).map(r -> r.getMethod()).filter(r -> r == Bundle.HTTPVerb.POST).isPresent();
            }
            case R5: {
                return Optional.ofNullable(((Bundle.BundleEntryComponent)entry).getRequest()).map(r -> r.getMethod()).filter(r -> r == Bundle.HTTPVerb.POST).isPresent();
            }
        }
        throw new IllegalArgumentException(UNSUPPORTED_VERSION_OF_FHIR.formatted(fhirVersion.getFhirVersionString()));
    }

    public static boolean isEntryRequestDelete(FhirVersionEnum fhirVersion, IBaseBackboneElement entry) {
        switch (fhirVersion) {
            case DSTU3: {
                return Optional.ofNullable(((Bundle.BundleEntryComponent)entry).getRequest()).map(Bundle.BundleEntryRequestComponent::getMethod).filter(r -> r == Bundle.HTTPVerb.DELETE).isPresent();
            }
            case R4: {
                return Optional.ofNullable(((Bundle.BundleEntryComponent)entry).getRequest()).map(Bundle.BundleEntryRequestComponent::getMethod).filter(r -> r == Bundle.HTTPVerb.DELETE).isPresent();
            }
            case R5: {
                return Optional.ofNullable(((Bundle.BundleEntryComponent)entry).getRequest()).map(Bundle.BundleEntryRequestComponent::getMethod).filter(r -> r == Bundle.HTTPVerb.DELETE).isPresent();
            }
        }
        throw new IllegalArgumentException(UNSUPPORTED_VERSION_OF_FHIR.formatted(fhirVersion.getFhirVersionString()));
    }

    public static <T extends IBaseBackboneElement> List<T> getEntry(IBaseBundle bundle) {
        FhirVersionEnum fhirVersion = bundle.getStructureFhirVersionEnum();
        switch (fhirVersion) {
            case DSTU3: {
                return ((org.hl7.fhir.dstu3.model.Bundle)bundle).getEntry();
            }
            case R4: {
                return ((Bundle)bundle).getEntry();
            }
            case R5: {
                return ((org.hl7.fhir.r5.model.Bundle)bundle).getEntry();
            }
        }
        throw new IllegalArgumentException(UNSUPPORTED_VERSION_OF_FHIR.formatted(fhirVersion.getFhirVersionString()));
    }

    public static Optional<IIdType> getEntryRequestId(FhirVersionEnum fhirVersion, IBaseBackboneElement entry) {
        switch (fhirVersion) {
            case DSTU3: {
                return Optional.ofNullable(((Bundle.BundleEntryComponent)entry).getRequest().getUrl()).map(Canonicals::getIdPart).map(org.hl7.fhir.dstu3.model.IdType::new);
            }
            case R4: {
                return Optional.ofNullable(((Bundle.BundleEntryComponent)entry).getRequest().getUrl()).map(Canonicals::getIdPart).map(IdType::new);
            }
            case R5: {
                return Optional.ofNullable(((Bundle.BundleEntryComponent)entry).getRequest().getUrl()).map(Canonicals::getIdPart).map(org.hl7.fhir.r5.model.IdType::new);
            }
        }
        throw new IllegalArgumentException(UNSUPPORTED_VERSION_OF_FHIR.formatted(fhirVersion.getFhirVersionString()));
    }

    public static String getEntryRequestUrl(FhirVersionEnum fhirVersion, IBaseBackboneElement entry) {
        return switch (fhirVersion) {
            case FhirVersionEnum.DSTU3 -> ((Bundle.BundleEntryComponent)entry).getRequest().getUrl();
            case FhirVersionEnum.R4 -> ((Bundle.BundleEntryComponent)entry).getRequest().getUrl();
            case FhirVersionEnum.R5 -> ((Bundle.BundleEntryComponent)entry).getRequest().getUrl();
            default -> throw new IllegalArgumentException(UNSUPPORTED_VERSION_OF_FHIR.formatted(fhirVersion.getFhirVersionString()));
        };
    }

    public static void setEntry(IBaseBundle bundle, List<? extends IBaseBackboneElement> entries) {
        FhirVersionEnum fhirVersion = bundle.getStructureFhirVersionEnum();
        switch (fhirVersion) {
            case DSTU3: {
                ((org.hl7.fhir.dstu3.model.Bundle)bundle).setEntry(entries);
                break;
            }
            case R4: {
                ((Bundle)bundle).setEntry(entries);
                break;
            }
            case R5: {
                ((org.hl7.fhir.r5.model.Bundle)bundle).setEntry(entries);
                break;
            }
            default: {
                throw new IllegalArgumentException(UNSUPPORTED_VERSION_OF_FHIR.formatted(fhirVersion.getFhirVersionString()));
            }
        }
    }

    public static IBaseBundle addEntry(IBaseBundle bundle, IBaseBackboneElement entry) {
        FhirVersionEnum fhirVersion = bundle.getStructureFhirVersionEnum();
        switch (fhirVersion) {
            case DSTU3: {
                ((org.hl7.fhir.dstu3.model.Bundle)bundle).addEntry((Bundle.BundleEntryComponent)entry);
                break;
            }
            case R4: {
                ((Bundle)bundle).addEntry((Bundle.BundleEntryComponent)entry);
                break;
            }
            case R5: {
                ((org.hl7.fhir.r5.model.Bundle)bundle).addEntry((Bundle.BundleEntryComponent)entry);
                break;
            }
            default: {
                throw new IllegalArgumentException(UNSUPPORTED_VERSION_OF_FHIR.formatted(fhirVersion.getFhirVersionString()));
            }
        }
        return bundle;
    }

    public static IBaseBundle newBundle(FhirVersionEnum fhirVersion) {
        return BundleHelper.newBundle(fhirVersion, null, null);
    }

    public static IBaseBundle newBundle(FhirVersionEnum fhirVersion, String id, String type) {
        switch (fhirVersion) {
            case DSTU3: {
                return BundleHelper.newDstu3Bundle(id, type);
            }
            case R4: {
                return BundleHelper.newR4Bundle(id, type);
            }
            case R5: {
                return BundleHelper.newR5Bundle(id, type);
            }
        }
        throw new IllegalArgumentException(UNSUPPORTED_VERSION_OF_FHIR.formatted(fhirVersion.getFhirVersionString()));
    }

    @Nonnull
    private static org.hl7.fhir.r5.model.Bundle newR5Bundle(String id, String type) {
        org.hl7.fhir.r5.model.Bundle r5Bundle = new org.hl7.fhir.r5.model.Bundle();
        if (id != null && !id.isEmpty()) {
            r5Bundle.setId(id);
        }
        r5Bundle.setType(type == null || type.isEmpty() ? Bundle.BundleType.COLLECTION : Bundle.BundleType.fromCode((String)type));
        return r5Bundle;
    }

    @Nonnull
    private static Bundle newR4Bundle(String id, String type) {
        Bundle r4Bundle = new Bundle();
        if (id != null && !id.isEmpty()) {
            r4Bundle.setId(id);
        }
        r4Bundle.setType(type == null || type.isEmpty() ? Bundle.BundleType.COLLECTION : Bundle.BundleType.fromCode((String)type));
        return r4Bundle;
    }

    @Nonnull
    private static org.hl7.fhir.dstu3.model.Bundle newDstu3Bundle(String id, String type) {
        org.hl7.fhir.dstu3.model.Bundle dstu3Bundle = new org.hl7.fhir.dstu3.model.Bundle();
        if (id != null && !id.isEmpty()) {
            dstu3Bundle.setId(id);
        }
        dstu3Bundle.setType(type == null || type.isEmpty() ? Bundle.BundleType.COLLECTION : Bundle.BundleType.fromCode((String)type));
        return dstu3Bundle;
    }

    public static IBaseBundle setBundleType(IBaseBundle bundle, String bundleType) {
        FhirVersionEnum fhirVersion = bundle.getStructureFhirVersionEnum();
        switch (fhirVersion) {
            case DSTU3: {
                return ((org.hl7.fhir.dstu3.model.Bundle)bundle).setType(Bundle.BundleType.fromCode((String)bundleType));
            }
            case R4: {
                return ((Bundle)bundle).setType(Bundle.BundleType.fromCode((String)bundleType));
            }
            case R5: {
                return ((org.hl7.fhir.r5.model.Bundle)bundle).setType(Bundle.BundleType.fromCode((String)bundleType));
            }
        }
        throw new IllegalArgumentException(UNSUPPORTED_VERSION_OF_FHIR.formatted(fhirVersion.getFhirVersionString()));
    }

    public static IBaseBundle setBundleTotal(IBaseBundle bundle, int total) {
        FhirVersionEnum fhirVersion = bundle.getStructureFhirVersionEnum();
        switch (fhirVersion) {
            case DSTU3: {
                return ((org.hl7.fhir.dstu3.model.Bundle)bundle).setTotal(total);
            }
            case R4: {
                return ((Bundle)bundle).setTotal(total);
            }
            case R5: {
                return ((org.hl7.fhir.r5.model.Bundle)bundle).setTotal(total);
            }
        }
        throw new IllegalArgumentException(UNSUPPORTED_VERSION_OF_FHIR.formatted(fhirVersion.getFhirVersionString()));
    }

    public static IBaseBackboneElement newEntry(FhirVersionEnum fhirVersion) {
        switch (fhirVersion) {
            case DSTU3: {
                return new Bundle.BundleEntryComponent();
            }
            case R4: {
                return new Bundle.BundleEntryComponent();
            }
            case R5: {
                return new Bundle.BundleEntryComponent();
            }
        }
        throw new IllegalArgumentException(UNSUPPORTED_VERSION_OF_FHIR.formatted(fhirVersion.getFhirVersionString()));
    }

    public static IBaseBackboneElement newEntryWithResource(IBaseResource resource) {
        FhirVersionEnum fhirVersion = resource.getStructureFhirVersionEnum();
        switch (fhirVersion) {
            case DSTU3: {
                return new Bundle.BundleEntryComponent().setResource((Resource)resource);
            }
            case R4: {
                return new Bundle.BundleEntryComponent().setResource((org.hl7.fhir.r4.model.Resource)resource);
            }
            case R5: {
                return new Bundle.BundleEntryComponent().setResource((org.hl7.fhir.r5.model.Resource)resource);
            }
        }
        throw new IllegalArgumentException(UNSUPPORTED_VERSION_OF_FHIR.formatted(fhirVersion.getFhirVersionString()));
    }

    public static IBaseBackboneElement newEntryWithResponse(FhirVersionEnum fhirVersion, IBaseBackboneElement response) {
        switch (fhirVersion) {
            case DSTU3: {
                return new Bundle.BundleEntryComponent().setResponse((Bundle.BundleEntryResponseComponent)response);
            }
            case R4: {
                return new Bundle.BundleEntryComponent().setResponse((Bundle.BundleEntryResponseComponent)response);
            }
            case R5: {
                return new Bundle.BundleEntryComponent().setResponse((Bundle.BundleEntryResponseComponent)response);
            }
        }
        throw new IllegalArgumentException(UNSUPPORTED_VERSION_OF_FHIR.formatted(fhirVersion.getFhirVersionString()));
    }

    public static IBaseBackboneElement newResponseWithLocation(FhirVersionEnum fhirVersion, String location) {
        switch (fhirVersion) {
            case DSTU3: {
                return new Bundle.BundleEntryResponseComponent().setLocation(location);
            }
            case R4: {
                return new Bundle.BundleEntryResponseComponent().setLocation(location);
            }
            case R5: {
                return new Bundle.BundleEntryResponseComponent().setLocation(location);
            }
        }
        throw new IllegalArgumentException(UNSUPPORTED_VERSION_OF_FHIR.formatted(fhirVersion.getFhirVersionString()));
    }

    public static IBaseBackboneElement newRequest(FhirVersionEnum fhirVersion, String method, String url) {
        switch (fhirVersion) {
            case DSTU3: {
                return new Bundle.BundleEntryRequestComponent().setMethod(Bundle.HTTPVerb.fromCode((String)method)).setUrl(url);
            }
            case R4: {
                return new Bundle.BundleEntryRequestComponent().setMethod(Bundle.HTTPVerb.fromCode((String)method)).setUrl(url);
            }
            case R5: {
                return new Bundle.BundleEntryRequestComponent().setMethod(Bundle.HTTPVerb.fromCode((String)method)).setUrl(url);
            }
        }
        throw new IllegalArgumentException(UNSUPPORTED_VERSION_OF_FHIR.formatted(fhirVersion.getFhirVersionString()));
    }

    public static IBaseBackboneElement newRequest(FhirVersionEnum fhirVersion, String method) {
        switch (fhirVersion) {
            case DSTU3: {
                return new Bundle.BundleEntryRequestComponent().setMethod(Bundle.HTTPVerb.fromCode((String)method));
            }
            case R4: {
                return new Bundle.BundleEntryRequestComponent().setMethod(Bundle.HTTPVerb.fromCode((String)method));
            }
            case R5: {
                return new Bundle.BundleEntryRequestComponent().setMethod(Bundle.HTTPVerb.fromCode((String)method));
            }
        }
        throw new IllegalArgumentException(UNSUPPORTED_VERSION_OF_FHIR.formatted(fhirVersion.getFhirVersionString()));
    }

    public static IBaseBackboneElement setRequestUrl(FhirVersionEnum fhirVersion, IBaseBackboneElement request, String url) {
        if (request == null) {
            request = BundleHelper.newRequest(fhirVersion, null);
        }
        switch (fhirVersion) {
            case DSTU3: {
                return ((Bundle.BundleEntryRequestComponent)request).setUrl(url);
            }
            case R4: {
                return ((Bundle.BundleEntryRequestComponent)request).setUrl(url);
            }
            case R5: {
                return ((Bundle.BundleEntryRequestComponent)request).setUrl(url);
            }
        }
        throw new IllegalArgumentException(UNSUPPORTED_VERSION_OF_FHIR.formatted(fhirVersion.getFhirVersionString()));
    }

    public static IBaseBackboneElement setRequestIfNoneExist(FhirVersionEnum fhirVersion, IBaseBackboneElement request, String ifNoneExist) {
        if (request == null) {
            request = BundleHelper.newRequest(fhirVersion, null);
        }
        switch (fhirVersion) {
            case DSTU3: {
                return ((Bundle.BundleEntryRequestComponent)request).setIfNoneExist(ifNoneExist);
            }
            case R4: {
                return ((Bundle.BundleEntryRequestComponent)request).setIfNoneExist(ifNoneExist);
            }
            case R5: {
                return ((Bundle.BundleEntryRequestComponent)request).setIfNoneExist(ifNoneExist);
            }
        }
        throw new IllegalArgumentException(UNSUPPORTED_VERSION_OF_FHIR.formatted(fhirVersion.getFhirVersionString()));
    }

    public static IBaseBackboneElement setEntryFullUrl(FhirVersionEnum fhirVersion, IBaseBackboneElement entry, String fullUrl) {
        if (entry == null) {
            entry = BundleHelper.newEntry(fhirVersion);
        }
        switch (fhirVersion) {
            case DSTU3: {
                return ((Bundle.BundleEntryComponent)entry).setFullUrl(fullUrl);
            }
            case R4: {
                return ((Bundle.BundleEntryComponent)entry).setFullUrl(fullUrl);
            }
            case R5: {
                return ((Bundle.BundleEntryComponent)entry).setFullUrl(fullUrl);
            }
        }
        throw new IllegalArgumentException(UNSUPPORTED_VERSION_OF_FHIR.formatted(fhirVersion.getFhirVersionString()));
    }

    public static IBaseBackboneElement setEntryRequest(FhirVersionEnum fhirVersion, IBaseBackboneElement entry, IBaseBackboneElement request) {
        if (entry == null) {
            entry = BundleHelper.newEntry(fhirVersion);
        }
        if (request == null) {
            request = BundleHelper.newRequest(fhirVersion, null);
        }
        String requestTypeError = "Request should be of type: %s";
        switch (fhirVersion) {
            case DSTU3: {
                if (request != null && !(request instanceof Bundle.BundleEntryRequestComponent)) {
                    throw new IllegalArgumentException(requestTypeError.formatted("org.hl7.fhir.dstu3.model.Bundle.BundleEntryRequestComponent"));
                }
                return ((Bundle.BundleEntryComponent)entry).setRequest((Bundle.BundleEntryRequestComponent)request);
            }
            case R4: {
                if (request != null && !(request instanceof Bundle.BundleEntryRequestComponent)) {
                    throw new IllegalArgumentException(requestTypeError.formatted("org.hl7.fhir.r4.model.Bundle.BundleEntryRequestComponent"));
                }
                return ((Bundle.BundleEntryComponent)entry).setRequest((Bundle.BundleEntryRequestComponent)request);
            }
            case R5: {
                if (request != null && !(request instanceof Bundle.BundleEntryRequestComponent)) {
                    throw new IllegalArgumentException(requestTypeError.formatted("org.hl7.fhir.r5.model.Bundle.BundleEntryRequestComponent"));
                }
                return ((Bundle.BundleEntryComponent)entry).setRequest((Bundle.BundleEntryRequestComponent)request);
            }
        }
        throw new IllegalArgumentException(UNSUPPORTED_VERSION_OF_FHIR.formatted(fhirVersion.getFhirVersionString()));
    }

    public static RuntimeSearchParam resourceToRuntimeSearchParam(IBaseResource resource) {
        FhirVersionEnum fhirVersion = resource.getStructureFhirVersionEnum();
        switch (fhirVersion) {
            case DSTU3: {
                org.hl7.fhir.dstu3.model.SearchParameter res = (org.hl7.fhir.dstu3.model.SearchParameter)resource;
                return new RuntimeSearchParam((IIdType)res.getIdElement(), res.getUrl(), res.getCode(), res.getDescription(), res.getExpression(), RestSearchParameterTypeEnum.REFERENCE, null, res.getTarget().stream().map(org.hl7.fhir.dstu3.model.StringType::toString).collect(Collectors.toSet()), RuntimeSearchParam.RuntimeSearchParamStatusEnum.ACTIVE, res.getBase().stream().map(org.hl7.fhir.dstu3.model.StringType::toString).toList());
            }
            case R4: {
                SearchParameter resR4 = (SearchParameter)resource;
                return new RuntimeSearchParam((IIdType)resR4.getIdElement(), resR4.getUrl(), resR4.getCode(), resR4.getDescription(), resR4.getExpression(), RestSearchParameterTypeEnum.REFERENCE, null, resR4.getTarget().stream().map(StringType::toString).collect(Collectors.toSet()), RuntimeSearchParam.RuntimeSearchParamStatusEnum.ACTIVE, resR4.getBase().stream().map(StringType::toString).toList());
            }
            case R5: {
                org.hl7.fhir.r5.model.SearchParameter resR5 = (org.hl7.fhir.r5.model.SearchParameter)resource;
                return new RuntimeSearchParam((IIdType)resR5.getIdElement(), resR5.getUrl(), resR5.getCode(), resR5.getDescription(), resR5.getExpression(), RestSearchParameterTypeEnum.REFERENCE, null, resR5.getTarget().stream().map(PrimitiveType::toString).collect(Collectors.toSet()), RuntimeSearchParam.RuntimeSearchParamStatusEnum.ACTIVE, resR5.getBase().stream().map(PrimitiveType::toString).toList());
            }
        }
        throw new IllegalArgumentException(UNSUPPORTED_VERSION_OF_FHIR.formatted(fhirVersion.getFhirVersionString()));
    }
}

