/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility;

import ca.uhn.fhir.context.FhirVersionEnum;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r4.model.Expression;
import org.hl7.fhir.r5.model.Extension;

public class CqfExpression {
    private String language;
    private String expression;
    private Map<String, String> referencedLibraries;
    private String libraryUrl;
    private String altLanguage;
    private String altExpression;
    private String altLibraryUrl;
    private String name;

    public static CqfExpression of(IBaseExtension<?, ?> extension, Map<String, String> referencedLibraries) {
        if (extension == null) {
            return null;
        }
        String fhirPackagePath = "org.hl7.fhir.";
        String className = extension.getClass().getCanonicalName();
        String[] modelSplit = className.split(fhirPackagePath);
        if (modelSplit.length < 2) {
            throw new IllegalArgumentException();
        }
        String model = modelSplit[1];
        model = model.substring(0, model.indexOf(".")).toUpperCase();
        FhirVersionEnum version = FhirVersionEnum.forVersionString((String)model);
        return switch (version) {
            case FhirVersionEnum.DSTU3 -> new CqfExpression("text/cql-expression", extension.getValue().toString(), referencedLibraries);
            case FhirVersionEnum.R4 -> CqfExpression.of((Expression)extension.getValue(), referencedLibraries);
            case FhirVersionEnum.R5 -> CqfExpression.of((org.hl7.fhir.r5.model.Expression)extension.getValue(), referencedLibraries);
            default -> null;
        };
    }

    public static CqfExpression of(Expression expression, Map<String, String> referencedLibraries) {
        if (expression == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Extension altExpressionExt = expression.getExtensionByUrl("http://hl7.org/fhir/us/ecr/StructureDefinition/us-ph-alternativeExpression");
        Expression altExpression = altExpressionExt == null ? null : (Expression)altExpressionExt.getValue();
        return new CqfExpression(expression.getLanguage(), expression.getExpression(), referencedLibraries, expression.getReference(), altExpression != null ? altExpression.getLanguage() : null, altExpression != null ? altExpression.getExpression() : null, altExpression != null && altExpression.hasReference() ? altExpression.getReference() : null, expression.getName());
    }

    public static CqfExpression of(org.hl7.fhir.r5.model.Expression expression, Map<String, String> referencedLibraries) {
        if (expression == null) {
            return null;
        }
        Extension altExpressionExt = expression.getExtensionByUrl("http://hl7.org/fhir/us/ecr/StructureDefinition/us-ph-alternativeExpression");
        org.hl7.fhir.r5.model.Expression altExpression = altExpressionExt == null ? null : (org.hl7.fhir.r5.model.Expression)altExpressionExt.getValue();
        return new CqfExpression(expression.getLanguage(), expression.getExpression(), referencedLibraries, expression.getReference(), altExpression != null ? altExpression.getLanguage() : null, altExpression != null ? altExpression.getExpression() : null, altExpression != null && altExpression.hasReference() ? altExpression.getReference() : null, expression.getName());
    }

    public CqfExpression() {
    }

    public CqfExpression(String language, String expression, Map<String, String> referencedLibraries) {
        this(language, expression, referencedLibraries, null, null, null, null, null);
    }

    public CqfExpression(String language, String expression, Map<String, String> referencedLibraries, String libraryUrl, String altLanguage, String altExpression, String altLibraryUrl, String name) {
        this.language = language;
        this.expression = expression;
        this.referencedLibraries = referencedLibraries;
        this.libraryUrl = libraryUrl;
        this.altLanguage = altLanguage;
        this.altExpression = altExpression;
        this.altLibraryUrl = altLibraryUrl;
        this.name = name;
    }

    private String resolveLibrary(String lang, String url, String expr) {
        if (List.of("text/cql", "text/cql.expression", "text/cql-expression", "text/fhirpath").contains(lang)) {
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)url)) {
            return url;
        }
        if (this.referencedLibraries != null && !this.referencedLibraries.isEmpty()) {
            return this.referencedLibraries.values().stream().findFirst().get();
        }
        throw new IllegalArgumentException("No Library reference found for expression: %s".formatted(expr));
    }

    public String getName() {
        return this.name;
    }

    public CqfExpression setName(String name) {
        this.name = name;
        return this;
    }

    public String getLanguage() {
        return this.language;
    }

    public CqfExpression setLanguage(String language) {
        this.language = language;
        return this;
    }

    public String getExpression() {
        return this.expression;
    }

    public CqfExpression setExpression(String expression) {
        this.expression = expression;
        return this;
    }

    public Map<String, String> getReferencedLibraries() {
        return this.referencedLibraries;
    }

    public CqfExpression setReferencedLibraries(Map<String, String> referencedLibraries) {
        this.referencedLibraries = referencedLibraries;
        return this;
    }

    public String getLibraryUrl() {
        return this.resolveLibrary(this.language, this.libraryUrl, this.expression);
    }

    public CqfExpression setLibraryUrl(String libraryUrl) {
        this.libraryUrl = libraryUrl;
        return this;
    }

    public String getAltLanguage() {
        return this.altLanguage;
    }

    public CqfExpression setAltLanguage(String altLanguage) {
        this.altLanguage = altLanguage;
        return this;
    }

    public String getAltExpression() {
        return this.altExpression;
    }

    public CqfExpression setAltExpression(String altExpression) {
        this.altExpression = altExpression;
        return this;
    }

    public String getAltLibraryUrl() {
        return StringUtils.isBlank((CharSequence)this.altExpression) ? null : this.resolveLibrary(this.altLanguage, this.altLibraryUrl, this.altExpression);
    }

    public CqfExpression setAltLibraryUrl(String altLibraryUrl) {
        this.altLibraryUrl = altLibraryUrl;
        return this;
    }

    public ICompositeType toExpressionType(FhirVersionEnum fhirVersion) {
        return switch (fhirVersion) {
            case FhirVersionEnum.R4 -> new Expression().setLanguage(this.language).setExpression(this.expression).setReference(this.libraryUrl).setName(this.name);
            case FhirVersionEnum.R5 -> new org.hl7.fhir.r5.model.Expression().setLanguage(this.language).setExpression(this.expression).setReference(this.libraryUrl).setName(this.name);
            default -> null;
        };
    }
}

