/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility;

import ca.uhn.fhir.context.FhirVersionEnum;
import com.google.common.base.Preconditions;
import org.hl7.fhir.instance.model.api.IBase;

public class FhirVersions {
    private FhirVersions() {
    }

    public static <BaseType extends IBase> FhirVersionEnum forClass(Class<? extends BaseType> baseTypeClass) {
        Preconditions.checkNotNull(baseTypeClass);
        String packageName = baseTypeClass.getPackage().getName();
        if (packageName.contains("r5")) {
            return FhirVersionEnum.R5;
        }
        if (packageName.contains("r4")) {
            return FhirVersionEnum.R4;
        }
        if (packageName.contains("dstu3")) {
            return FhirVersionEnum.DSTU3;
        }
        if (packageName.contains("dstu2016may")) {
            return FhirVersionEnum.DSTU2_1;
        }
        if (packageName.contains("org.hl7.fhir.dstu2")) {
            return FhirVersionEnum.DSTU2_HL7ORG;
        }
        if (packageName.contains("ca.uhn.fhir.model.dstu2")) {
            return FhirVersionEnum.DSTU2;
        }
        throw new IllegalArgumentException("Unable to determine FHIR version for IBaseResource type: %s".formatted(baseTypeClass.getName()));
    }
}

