/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.opencds.cqf.fhir.utility.FhirVersions;

public class Reflections {
    private Reflections() {
    }

    public static <BaseType extends IBase> BaseRuntimeChildDefinition.IAccessor getAccessor(Class<? extends BaseType> baseTypeClass, String childName) {
        Preconditions.checkNotNull(baseTypeClass);
        Preconditions.checkNotNull((Object)childName);
        FhirContext fhirContext = FhirContext.forCached((FhirVersionEnum)FhirVersions.forClass(baseTypeClass));
        BaseRuntimeElementDefinition elementDefinition = fhirContext.getElementDefinition(baseTypeClass);
        return elementDefinition.getChildByName(childName).getAccessor();
    }

    public static <BaseType extends IBase, ReturnType> Function<BaseType, ReturnType> getPrimitiveFunction(Class<? extends BaseType> baseTypeClass, String childName) {
        Preconditions.checkNotNull(baseTypeClass);
        Preconditions.checkNotNull((Object)childName);
        BaseRuntimeChildDefinition.IAccessor accessor = Reflections.getAccessor(baseTypeClass, childName);
        return r -> {
            Optional value = accessor.getFirstValueOrNull(r);
            if (value.isEmpty()) {
                return null;
            }
            Object x = ((IPrimitiveType)value.get()).getValue();
            return x;
        };
    }

    public static <BaseType extends IBase, ReturnType extends List<? extends IBase>> Function<BaseType, ReturnType> getFunction(Class<? extends BaseType> baseTypeClass, String childName) {
        Preconditions.checkNotNull(baseTypeClass);
        Preconditions.checkNotNull((Object)childName);
        BaseRuntimeChildDefinition.IAccessor accessor = Reflections.getAccessor(baseTypeClass, childName);
        return r -> {
            List x = accessor.getValues(r);
            return x;
        };
    }

    public static <BaseType extends IBase> Function<BaseType, String> getVersionFunction(Class<? extends BaseType> baseTypeClass) {
        Preconditions.checkNotNull(baseTypeClass);
        return Reflections.getPrimitiveFunction(baseTypeClass, "version");
    }

    public static <BaseType extends IBase> Function<BaseType, String> getUrlFunction(Class<? extends BaseType> baseTypeClass) {
        Preconditions.checkNotNull(baseTypeClass);
        return Reflections.getPrimitiveFunction(baseTypeClass, "url");
    }

    public static <BaseType extends IBase> Function<BaseType, String> getNameFunction(Class<? extends BaseType> baseTypeClass) {
        Preconditions.checkNotNull(baseTypeClass);
        return Reflections.getPrimitiveFunction(baseTypeClass, "name");
    }
}

