/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.repository.IRepository;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.dstu3.model.Bundle;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.opencds.cqf.fhir.utility.BundleHelper;
import org.opencds.cqf.fhir.utility.Canonicals;
import org.opencds.cqf.fhir.utility.adapter.IDependencyInfo;
import org.opencds.cqf.fhir.utility.search.Searches;

public class SearchHelper {
    private SearchHelper() {
    }

    protected static Class<IBaseBundle> getBundleClass(IRepository repository) {
        return repository.fhirContext().getResourceDefinition("Bundle").getImplementingClass();
    }

    public static Class<IBaseResource> getResourceClass(IRepository repository, String resourceType) {
        return repository.fhirContext().getResourceDefinition(resourceType).getImplementingClass();
    }

    public static IBaseResource readRepository(IRepository repository, IIdType id) {
        return repository.read(SearchHelper.getResourceClass(repository, id.getResourceType()), id);
    }

    public static <CanonicalType extends IPrimitiveType<String>> IBaseResource searchRepositoryByCanonical(IRepository repository, CanonicalType canonical) {
        Class<IBaseResource> resourceType = SearchHelper.getResourceType(repository, canonical);
        return SearchHelper.searchRepositoryByCanonical(repository, canonical, resourceType);
    }

    public static <CanonicalType extends IPrimitiveType<String>> Class<? extends IBaseResource> getResourceType(IRepository repository, CanonicalType canonical) {
        Class resourceType = null;
        try {
            String resourceTypeString = Canonicals.getResourceType(canonical);
            if (StringUtils.isEmpty((CharSequence)resourceTypeString)) {
                throw new DataFormatException();
            }
            resourceType = repository.fhirContext().getResourceDefinition(resourceTypeString).getImplementingClass();
        }
        catch (DataFormatException e) {
            Optional<String> cqfResourceTypeExt = SearchHelper.getResourceTypeStringFromCqfResourceTypeExtension(canonical);
            if (cqfResourceTypeExt.isPresent()) {
                try {
                    resourceType = repository.fhirContext().getResourceDefinition(cqfResourceTypeExt.get()).getImplementingClass();
                }
                catch (DataFormatException | NullPointerException e2) {
                    throw new UnprocessableEntityException("cqf-resourceType extension contains invalid resource type: " + cqfResourceTypeExt.get());
                }
            }
            resourceType = repository.fhirContext().getResourceDefinition("CodeSystem").getImplementingClass();
        }
        return resourceType;
    }

    public static Class<? extends IBaseResource> getResourceType(IRepository repository, IDependencyInfo dependencyInfo) {
        Class resourceType = null;
        try {
            String resourceTypeString = Canonicals.getResourceType(dependencyInfo.getReference());
            if (StringUtils.isEmpty((CharSequence)resourceTypeString)) {
                throw new DataFormatException();
            }
            resourceType = repository.fhirContext().getResourceDefinition(resourceTypeString).getImplementingClass();
        }
        catch (DataFormatException e) {
            Optional<String> cqfResourceTypeExt = SearchHelper.getResourceTypeStringFromCqfResourceTypeExtension(dependencyInfo.getExtension());
            if (cqfResourceTypeExt.isPresent()) {
                try {
                    resourceType = repository.fhirContext().getResourceDefinition(cqfResourceTypeExt.get()).getImplementingClass();
                }
                catch (DataFormatException | NullPointerException e2) {
                    throw new UnprocessableEntityException("cqf-resourceType extension contains invalid resource type: " + cqfResourceTypeExt.get());
                }
            }
            resourceType = repository.fhirContext().getResourceDefinition("CodeSystem").getImplementingClass();
        }
        return resourceType;
    }

    private static <CanonicalType extends IPrimitiveType<String>> Optional<String> getResourceTypeStringFromCqfResourceTypeExtension(CanonicalType canonical) {
        return SearchHelper.getResourceTypeStringFromCqfResourceTypeExtension(SearchHelper.getExtensions(canonical));
    }

    private static Optional<String> getResourceTypeStringFromCqfResourceTypeExtension(List<? extends IBaseExtension> extensions) {
        return extensions.stream().filter(ext -> ext.getUrl().contains("cqf-resourceType")).findAny().map(ext -> (String)((IPrimitiveType)ext.getValue()).getValue());
    }

    private static <CanonicalType extends IPrimitiveType<String>> List<IBaseExtension> getExtensions(CanonicalType canonical) {
        if (canonical instanceof org.hl7.fhir.dstu3.model.PrimitiveType) {
            return ((org.hl7.fhir.dstu3.model.PrimitiveType)canonical).getExtension().stream().map(ext -> ext).collect(Collectors.toList());
        }
        if (canonical instanceof org.hl7.fhir.r4.model.PrimitiveType) {
            return ((org.hl7.fhir.r4.model.PrimitiveType)canonical).getExtension().stream().map(ext -> ext).collect(Collectors.toList());
        }
        if (canonical instanceof PrimitiveType) {
            return ((PrimitiveType)canonical).getExtension().stream().map(ext -> ext).collect(Collectors.toList());
        }
        throw new UnprocessableEntityException("Unsupported FHIR version for canonical: " + (String)canonical.getValue());
    }

    private static Class<? extends IBaseResource> getResourceType(IRepository repository, String canonical) {
        Class resourceType = null;
        try {
            resourceType = repository.fhirContext().getResourceDefinition(Canonicals.getResourceType(canonical)).getImplementingClass();
        }
        catch (RuntimeException e) {
            resourceType = repository.fhirContext().getResourceDefinition("CodeSystem").getImplementingClass();
        }
        return resourceType;
    }

    public static <CanonicalType extends IPrimitiveType<String>, R extends IBaseResource> IBaseResource searchRepositoryByCanonical(IRepository repository, CanonicalType canonical, Class<R> resourceType) {
        String url = Canonicals.getUrl(canonical);
        String version = Canonicals.getVersion(canonical);
        Map<String, List<IQueryParameterType>> searchParams = version == null ? Searches.byUrl(url) : Searches.byUrlAndVersion(url, version);
        IBaseBundle searchResult = repository.search(SearchHelper.getBundleClass(repository), resourceType, searchParams);
        IBaseResource result = BundleHelper.getEntryResourceFirstRep(searchResult);
        if (result == null) {
            throw new FHIRException("No resource of type %s found for url: %s|%s".formatted(resourceType.getSimpleName(), url, version));
        }
        return result;
    }

    public static <CanonicalType extends IPrimitiveType<String>> IBaseBundle searchRepositoryByCanonicalWithPaging(IRepository repository, CanonicalType canonical) {
        Class<IBaseResource> resourceType = SearchHelper.getResourceType(repository, canonical);
        return SearchHelper.searchRepositoryByCanonicalWithPaging(repository, canonical, resourceType);
    }

    public static <CanonicalType extends IPrimitiveType<String>> IBaseBundle searchRepositoryByCanonicalWithPaging(IRepository repository, String canonical) {
        Class<? extends IBaseResource> resourceType = SearchHelper.getResourceType(repository, canonical);
        return SearchHelper.searchRepositoryByCanonicalWithPaging(repository, canonical, resourceType);
    }

    public static IBaseBundle searchRepositoryByCanonicalWithPagingWithParams(IRepository repository, String canonical, Map<String, List<IQueryParameterType>> additionalSearchParams) {
        Class<? extends IBaseResource> resourceType = SearchHelper.getResourceType(repository, canonical);
        return SearchHelper.searchRepositoryByCanonicalWithPagingWithParams(repository, canonical, resourceType, additionalSearchParams);
    }

    public static <CanonicalType extends IPrimitiveType<String>, R extends IBaseResource> IBaseBundle searchRepositoryByCanonicalWithPaging(IRepository repository, CanonicalType canonical, Class<R> resourceType) {
        return SearchHelper.searchRepositoryByCanonicalWithPagingWithParams(repository, canonical, resourceType, null);
    }

    public static <CanonicalType extends IPrimitiveType<String>, R extends IBaseResource> IBaseBundle searchRepositoryByCanonicalWithPagingWithParams(IRepository repository, CanonicalType canonical, Class<R> resourceType, Map<String, List<IQueryParameterType>> additionalSearchParams) {
        Map<String, List<IQueryParameterType>> searchParams;
        String url = Canonicals.getUrl(canonical);
        String version = Canonicals.getVersion(canonical);
        Map<String, List<IQueryParameterType>> map = searchParams = version == null ? Searches.byUrl(url) : Searches.byUrlAndVersion(url, version);
        if (additionalSearchParams != null) {
            searchParams.putAll(additionalSearchParams);
        }
        R searchResult = SearchHelper.searchRepositoryWithPaging(repository, resourceType, searchParams, Collections.emptyMap());
        return searchResult;
    }

    public static <R extends IBaseResource> IBaseBundle searchRepositoryByCanonicalWithPaging(IRepository repository, String canonical, Class<R> resourceType) {
        return SearchHelper.searchRepositoryByCanonicalWithPagingWithParams(repository, canonical, resourceType, null);
    }

    public static <R extends IBaseResource> IBaseBundle searchRepositoryByCanonicalWithPagingWithParams(IRepository repository, String canonical, Class<R> resourceType, Map<String, List<IQueryParameterType>> additionalSearchParams) {
        Map<String, List<IQueryParameterType>> searchParams;
        String url = Canonicals.getUrl(canonical);
        String version = Canonicals.getVersion(canonical);
        Map<String, List<IQueryParameterType>> map = searchParams = version == null ? Searches.byUrl(url) : Searches.byUrlAndVersion(url, version);
        if (additionalSearchParams != null) {
            searchParams.putAll(additionalSearchParams);
        }
        R searchResult = SearchHelper.searchRepositoryWithPaging(repository, resourceType, searchParams, Collections.emptyMap());
        return searchResult;
    }

    public static <T extends IBaseResource, R extends IBaseBundle> R searchRepositoryWithPaging(IRepository repository, Class<T> resourceType, Map<String, List<IQueryParameterType>> searchParameters, Map<String, String> headers) {
        Class<IBaseBundle> bundleClass = SearchHelper.getBundleClass(repository);
        IBaseBundle result = repository.search(bundleClass, resourceType, searchParameters, headers);
        SearchHelper.handlePaging(repository, result);
        return (R)result;
    }

    private static void handlePaging(IRepository repository, IBaseBundle bundle) {
        FhirVersionEnum fhirVersion = repository.fhirContext().getVersion().getVersion();
        switch (fhirVersion) {
            case DSTU3: {
                org.hl7.fhir.dstu3.model.Bundle dstu3Bundle = (org.hl7.fhir.dstu3.model.Bundle)bundle;
                Bundle.BundleLinkComponent dstu3Next = dstu3Bundle.getLink("next");
                if (dstu3Next == null) break;
                SearchHelper.getNextPageDstu3(repository, dstu3Bundle, dstu3Next.getUrl());
                break;
            }
            case R4: {
                Bundle r4Bundle = (Bundle)bundle;
                Bundle.BundleLinkComponent r4Next = r4Bundle.getLink("next");
                if (r4Next == null) break;
                SearchHelper.getNextPageR4(repository, r4Bundle, r4Next.getUrl());
                break;
            }
            case R5: {
                org.hl7.fhir.r5.model.Bundle r5Bundle = (org.hl7.fhir.r5.model.Bundle)bundle;
                Bundle.BundleLinkComponent r5Next = r5Bundle.getLink("next");
                if (r5Next == null) break;
                SearchHelper.getNextPageR5(repository, r5Bundle, r5Next.getUrl());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported version of FHIR: %s".formatted(fhirVersion.getFhirVersionString()));
            }
        }
    }

    private static void getNextPageDstu3(IRepository repository, org.hl7.fhir.dstu3.model.Bundle bundle, String nextUrl) {
        org.hl7.fhir.dstu3.model.Bundle nextBundle = (org.hl7.fhir.dstu3.model.Bundle)repository.link(org.hl7.fhir.dstu3.model.Bundle.class, nextUrl);
        nextBundle.getEntry().forEach(arg_0 -> ((org.hl7.fhir.dstu3.model.Bundle)bundle).addEntry(arg_0));
        Bundle.BundleLinkComponent next = nextBundle.getLink("next");
        if (next != null) {
            SearchHelper.getNextPageDstu3(repository, bundle, next.getUrl());
        }
    }

    private static void getNextPageR4(IRepository repository, Bundle bundle, String nextUrl) {
        Bundle nextBundle = (Bundle)repository.link(Bundle.class, nextUrl);
        nextBundle.getEntry().forEach(arg_0 -> ((Bundle)bundle).addEntry(arg_0));
        Bundle.BundleLinkComponent next = nextBundle.getLink("next");
        if (next != null) {
            SearchHelper.getNextPageR4(repository, bundle, next.getUrl());
        }
    }

    private static void getNextPageR5(IRepository repository, org.hl7.fhir.r5.model.Bundle bundle, String nextUrl) {
        org.hl7.fhir.r5.model.Bundle nextBundle = (org.hl7.fhir.r5.model.Bundle)repository.link(org.hl7.fhir.r5.model.Bundle.class, nextUrl);
        nextBundle.getEntry().forEach(arg_0 -> ((org.hl7.fhir.r5.model.Bundle)bundle).addEntry(arg_0));
        Bundle.BundleLinkComponent next = nextBundle.getLink("next");
        if (next != null) {
            SearchHelper.getNextPageR5(repository, bundle, next.getUrl());
        }
    }
}

