/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility;

import ca.uhn.fhir.context.FhirVersionEnum;
import org.hl7.fhir.dstu2.model.CodeType;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.StringType;

public class VersionUtilities {
    private static final String UNSUPPORTED = "unknown or unsupported FHIR version";

    private VersionUtilities() {
    }

    public static FhirVersionEnum enumForVersion(String fhirVersion) {
        if (fhirVersion == null || fhirVersion.isEmpty()) {
            throw new IllegalArgumentException("fhirVersion can not be null or empty");
        }
        try {
            return FhirVersionEnum.valueOf((String)fhirVersion.toUpperCase());
        }
        catch (Exception exception) {
            FhirVersionEnum version = FhirVersionEnum.forVersionString((String)fhirVersion);
            if (version != null) {
                return version;
            }
            switch (fhirVersion.substring(0, 1)) {
                case "2": {
                    return FhirVersionEnum.DSTU2;
                }
                case "3": {
                    return FhirVersionEnum.DSTU3;
                }
                case "4": {
                    return FhirVersionEnum.R4;
                }
                case "5": {
                    return FhirVersionEnum.R5;
                }
            }
            throw new IllegalArgumentException(UNSUPPORTED);
        }
    }

    public static IPrimitiveType<String> stringTypeForVersion(FhirVersionEnum fhirVersion) {
        return VersionUtilities.stringTypeForVersion(fhirVersion, null);
    }

    public static IPrimitiveType<String> stringTypeForVersion(FhirVersionEnum fhirVersion, String string) {
        switch (fhirVersion) {
            case DSTU2: {
                return new org.hl7.fhir.dstu2.model.StringType(string);
            }
            case DSTU3: {
                return new org.hl7.fhir.dstu3.model.StringType(string);
            }
            case R4: {
                return new org.hl7.fhir.r4.model.StringType(string);
            }
            case R5: {
                return new StringType(string);
            }
        }
        throw new IllegalArgumentException(UNSUPPORTED);
    }

    public static IPrimitiveType<String> uriTypeForVersion(FhirVersionEnum fhirVersion) {
        return VersionUtilities.uriTypeForVersion(fhirVersion, null);
    }

    public static IPrimitiveType<String> uriTypeForVersion(FhirVersionEnum fhirVersion, String uri) {
        switch (fhirVersion) {
            case DSTU2: {
                return new org.hl7.fhir.dstu2.model.UriType(uri);
            }
            case DSTU3: {
                return new UriType(uri);
            }
            case R4: {
                return new org.hl7.fhir.r4.model.UriType(uri);
            }
            case R5: {
                return new org.hl7.fhir.r5.model.UriType(uri);
            }
        }
        throw new IllegalArgumentException(UNSUPPORTED);
    }

    public static IPrimitiveType<String> canonicalTypeForVersion(FhirVersionEnum fhirVersion) {
        return VersionUtilities.canonicalTypeForVersion(fhirVersion, null);
    }

    public static IPrimitiveType<String> canonicalTypeForVersion(FhirVersionEnum fhirVersion, String value) {
        switch (fhirVersion) {
            case DSTU2: {
                return new org.hl7.fhir.dstu2.model.UriType(value);
            }
            case DSTU3: {
                return new UriType(value);
            }
            case R4: {
                return new CanonicalType(value);
            }
            case R5: {
                return new org.hl7.fhir.r5.model.CanonicalType(value);
            }
        }
        throw new IllegalArgumentException(UNSUPPORTED);
    }

    public static IPrimitiveType<Boolean> booleanTypeForVersion(FhirVersionEnum fhirVersion, boolean value) {
        return switch (fhirVersion) {
            case FhirVersionEnum.DSTU2 -> new org.hl7.fhir.dstu2.model.BooleanType(value);
            case FhirVersionEnum.DSTU3 -> new org.hl7.fhir.dstu3.model.BooleanType(value);
            case FhirVersionEnum.R4 -> new org.hl7.fhir.r4.model.BooleanType(value);
            case FhirVersionEnum.R5 -> new BooleanType(value);
            default -> throw new IllegalArgumentException(UNSUPPORTED);
        };
    }

    public static IPrimitiveType<String> codeTypeForVersion(FhirVersionEnum fhirVersion, String code) {
        switch (fhirVersion) {
            case DSTU2: {
                return new CodeType(code);
            }
            case DSTU3: {
                return new org.hl7.fhir.dstu3.model.CodeType(code);
            }
            case R4: {
                return new org.hl7.fhir.r4.model.CodeType(code);
            }
            case R5: {
                return new org.hl7.fhir.r5.model.CodeType(code);
            }
        }
        throw new IllegalArgumentException(UNSUPPORTED);
    }

    public static IBaseReference referenceTypeForVersion(FhirVersionEnum fhirVersion, String value) {
        switch (fhirVersion) {
            case DSTU2: {
                return new org.hl7.fhir.dstu2.model.Reference().setReference(value);
            }
            case DSTU3: {
                return new Reference().setReference(value);
            }
            case R4: {
                return new org.hl7.fhir.r4.model.Reference().setReference(value);
            }
            case R5: {
                return new org.hl7.fhir.r5.model.Reference().setReference(value);
            }
        }
        throw new IllegalArgumentException(UNSUPPORTED);
    }
}

