/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.adapter;

import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import java.util.List;
import java.util.function.Consumer;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.RelatedArtifact;
import org.opencds.cqf.fhir.utility.adapter.IDependencyInfo;

public class DependencyInfo
implements IDependencyInfo {
    private String referenceSource;
    private String reference;
    private String referencePackageId;
    private Consumer<String> updateReferenceConsumer;
    private List<? extends IBaseExtension<?, ?>> extensionList;

    public DependencyInfo() {
    }

    public DependencyInfo(String referenceSource, String reference, List<? extends IBaseExtension<?, ?>> extensionList, Consumer<String> updateReferenceConsumer) {
        this.referenceSource = referenceSource;
        this.reference = reference;
        this.extensionList = extensionList;
        this.updateReferenceConsumer = updateReferenceConsumer;
    }

    @Override
    public String getReferenceSource() {
        return this.referenceSource;
    }

    public List<? extends IBaseExtension<?, ?>> getExtension() {
        return this.extensionList;
    }

    @Override
    public void setReferenceSource(String referenceSource) {
        this.referenceSource = referenceSource;
    }

    @Override
    public String getReference() {
        return this.reference;
    }

    @Override
    public void setReference(String reference) {
        this.reference = reference;
        this.updateReferenceConsumer.accept(reference);
    }

    @Override
    public String getReferencePackageId() {
        return this.referencePackageId;
    }

    @Override
    public void setReferencePackageId(String referencePackageId) {
        this.referencePackageId = referencePackageId;
    }

    public static IDependencyInfo convertRelatedArtifact(ICompositeType ra, String source) {
        if (ra instanceof org.hl7.fhir.dstu3.model.RelatedArtifact) {
            org.hl7.fhir.dstu3.model.RelatedArtifact reference = (org.hl7.fhir.dstu3.model.RelatedArtifact)ra;
            return new DependencyInfo(source, reference.getResource().getReference(), reference.getExtension(), ref -> reference.getResource().setReference(ref));
        }
        if (ra instanceof org.hl7.fhir.r4.model.RelatedArtifact) {
            org.hl7.fhir.r4.model.RelatedArtifact reference = (org.hl7.fhir.r4.model.RelatedArtifact)ra;
            return new DependencyInfo(source, reference.getResource(), reference.getExtension(), arg_0 -> ((org.hl7.fhir.r4.model.RelatedArtifact)reference).setResource(arg_0));
        }
        if (ra instanceof RelatedArtifact) {
            RelatedArtifact reference = (RelatedArtifact)ra;
            return new DependencyInfo(source, reference.getResource(), reference.getExtension(), arg_0 -> ((RelatedArtifact)reference).setResource(arg_0));
        }
        throw new UnprocessableEntityException("A valid RelatedArtifact object must be provided");
    }
}

