/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.adapter;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.opencds.cqf.fhir.utility.adapter.IActivityDefinitionAdapter;
import org.opencds.cqf.fhir.utility.adapter.IAttachmentAdapter;
import org.opencds.cqf.fhir.utility.adapter.ICodeableConceptAdapter;
import org.opencds.cqf.fhir.utility.adapter.ICodingAdapter;
import org.opencds.cqf.fhir.utility.adapter.IDataRequirementAdapter;
import org.opencds.cqf.fhir.utility.adapter.IElementDefinitionAdapter;
import org.opencds.cqf.fhir.utility.adapter.IEndpointAdapter;
import org.opencds.cqf.fhir.utility.adapter.IKnowledgeArtifactAdapter;
import org.opencds.cqf.fhir.utility.adapter.ILibraryAdapter;
import org.opencds.cqf.fhir.utility.adapter.IParametersAdapter;
import org.opencds.cqf.fhir.utility.adapter.IParametersParameterComponentAdapter;
import org.opencds.cqf.fhir.utility.adapter.IPlanDefinitionAdapter;
import org.opencds.cqf.fhir.utility.adapter.IQuestionnaireAdapter;
import org.opencds.cqf.fhir.utility.adapter.IRequestActionAdapter;
import org.opencds.cqf.fhir.utility.adapter.IResourceAdapter;
import org.opencds.cqf.fhir.utility.adapter.IValueSetAdapter;
import org.opencds.cqf.fhir.utility.adapter.r5.AdapterFactory;

public interface IAdapterFactory {
    public static IAdapterFactory forFhirContext(FhirContext fhirContext) {
        return IAdapterFactory.forFhirVersion(fhirContext.getVersion().getVersion());
    }

    public static IAdapterFactory forFhirVersion(FhirVersionEnum fhirVersion) {
        return switch (fhirVersion) {
            case FhirVersionEnum.DSTU3 -> new org.opencds.cqf.fhir.utility.adapter.dstu3.AdapterFactory();
            case FhirVersionEnum.R4 -> new org.opencds.cqf.fhir.utility.adapter.r4.AdapterFactory();
            case FhirVersionEnum.R5 -> new AdapterFactory();
            default -> throw new IllegalArgumentException("Unsupported FHIR version: %s".formatted(fhirVersion.toString()));
        };
    }

    public static IResourceAdapter createAdapterForResource(IBaseResource resource) {
        return IAdapterFactory.forFhirVersion(resource.getStructureFhirVersionEnum()).createResource(resource);
    }

    public IResourceAdapter createResource(IBaseResource var1);

    public IKnowledgeArtifactAdapter createKnowledgeArtifactAdapter(IDomainResource var1);

    public ILibraryAdapter createLibrary(IBaseResource var1);

    public IPlanDefinitionAdapter createPlanDefinition(IBaseResource var1);

    public IActivityDefinitionAdapter createActivityDefinition(IBaseResource var1);

    public IAttachmentAdapter createAttachment(ICompositeType var1);

    public IParametersAdapter createParameters(IBaseParameters var1);

    public IParametersParameterComponentAdapter createParametersParameter(IBaseBackboneElement var1);

    public IEndpointAdapter createEndpoint(IBaseResource var1);

    public ICodeableConceptAdapter createCodeableConcept(ICompositeType var1);

    public ICodingAdapter createCoding(ICompositeType var1);

    public IElementDefinitionAdapter createElementDefinition(ICompositeType var1);

    public IRequestActionAdapter createRequestAction(IBaseBackboneElement var1);

    public IDataRequirementAdapter createDataRequirement(ICompositeType var1);

    public IQuestionnaireAdapter createQuestionnaire(IBaseResource var1);

    public IValueSetAdapter createValueSet(IBaseResource var1);
}

