/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.adapter.dstu3;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.dstu3.model.DataRequirement;
import org.hl7.fhir.instance.model.api.IBaseDatatypeElement;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.opencds.cqf.cql.engine.model.ModelResolver;
import org.opencds.cqf.fhir.utility.adapter.ICodingAdapter;
import org.opencds.cqf.fhir.utility.adapter.IDataRequirementCodeFilterAdapter;
import org.opencds.cqf.fhir.utility.adapter.dstu3.CodingAdapter;
import org.opencds.cqf.fhir.utility.model.FhirModelResolverCache;

public class DataRequirementCodeFilterAdapter
implements IDataRequirementCodeFilterAdapter {
    private final DataRequirement.DataRequirementCodeFilterComponent codeFilter;
    private final FhirContext fhirContext;
    private final ModelResolver modelResolver;

    public DataRequirementCodeFilterAdapter(IBaseDatatypeElement codeFilter) {
        if (!(codeFilter instanceof DataRequirement.DataRequirementCodeFilterComponent)) {
            throw new IllegalArgumentException("object passed as codeFilter argument is not a DataRequirementCodeFilterComponent data type");
        }
        this.codeFilter = (DataRequirement.DataRequirementCodeFilterComponent)codeFilter;
        this.fhirContext = FhirContext.forDstu3Cached();
        this.modelResolver = FhirModelResolverCache.resolverForVersion(FhirVersionEnum.DSTU3);
    }

    @Override
    public DataRequirement.DataRequirementCodeFilterComponent get() {
        return this.codeFilter;
    }

    @Override
    public FhirContext fhirContext() {
        return this.fhirContext;
    }

    @Override
    public ModelResolver getModelResolver() {
        return this.modelResolver;
    }

    @Override
    public boolean hasCode() {
        return this.get().hasValueCoding();
    }

    @Override
    public List<ICodingAdapter> getCode() {
        return this.get().getValueCoding().stream().map(CodingAdapter::new).collect(Collectors.toList());
    }

    @Override
    public boolean hasPath() {
        return this.get().hasPath();
    }

    @Override
    public String getPath() {
        return this.get().getPath();
    }

    @Override
    public boolean hasValueSet() {
        return this.get().hasValueSet();
    }

    @Override
    public IPrimitiveType<String> getValueSet() {
        return this.get().getValueSetStringType();
    }
}

