/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.adapter.dstu3;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import java.util.List;
import org.hl7.fhir.dstu3.model.ElementDefinition;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseDatatypeElement;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.opencds.cqf.cql.engine.model.ModelResolver;
import org.opencds.cqf.fhir.utility.adapter.ICodingAdapter;
import org.opencds.cqf.fhir.utility.adapter.IElementDefinitionAdapter;
import org.opencds.cqf.fhir.utility.adapter.dstu3.AdapterFactory;
import org.opencds.cqf.fhir.utility.model.FhirModelResolverCache;

public class ElementDefinitionAdapter
implements IElementDefinitionAdapter {
    private final ElementDefinition elementDefinition;
    private final FhirContext fhirContext;
    private final ModelResolver modelResolver;
    private final AdapterFactory adapterFactory;

    public ElementDefinitionAdapter(ICompositeType elementDefinition) {
        if (!(elementDefinition instanceof ElementDefinition)) {
            throw new IllegalArgumentException("object passed as elementDefinition argument is not a ElementDefinition data type");
        }
        this.elementDefinition = (ElementDefinition)elementDefinition;
        this.fhirContext = FhirContext.forDstu3Cached();
        this.modelResolver = FhirModelResolverCache.resolverForVersion(FhirVersionEnum.DSTU3);
        this.adapterFactory = new AdapterFactory();
    }

    @Override
    public ElementDefinition get() {
        return this.elementDefinition;
    }

    @Override
    public FhirContext fhirContext() {
        return this.fhirContext;
    }

    @Override
    public ModelResolver getModelResolver() {
        return this.modelResolver;
    }

    @Override
    public String getId() {
        return this.get().getId();
    }

    @Override
    public String getPath() {
        return this.get().getPath();
    }

    @Override
    public String getSliceName() {
        return this.get().getSliceName();
    }

    @Override
    public boolean hasSlicing() {
        return this.get().hasSlicing();
    }

    @Override
    public String getLabel() {
        return this.get().getLabel();
    }

    @Override
    public boolean hasLabel() {
        return this.get().hasLabel();
    }

    @Override
    public List<ICodingAdapter> getCode() {
        return this.get().getCode().stream().map(this.adapterFactory::createCoding).toList();
    }

    @Override
    public String getShort() {
        return this.get().getShort();
    }

    @Override
    public boolean hasShort() {
        return this.get().hasShort();
    }

    @Override
    public String getDefinition() {
        return this.get().getDefinition();
    }

    @Override
    public String getComment() {
        return this.get().getComment();
    }

    @Override
    public String getRequirements() {
        return this.get().getRequirements();
    }

    @Override
    public List<String> getAlias() {
        return this.get().getAlias().stream().map(PrimitiveType::asStringValue).toList();
    }

    @Override
    public int getMin() {
        return this.get().getMin();
    }

    @Override
    public boolean hasMin() {
        return this.get().hasMin();
    }

    @Override
    public String getMax() {
        return this.get().getMax();
    }

    @Override
    public boolean hasMax() {
        return this.get().hasMax();
    }

    @Override
    public <T extends IBase> List<T> getType() {
        return this.get().getType().stream().map(t -> t).toList();
    }

    @Override
    public String getTypeCode() {
        return this.get().getTypeFirstRep().getCode();
    }

    @Override
    public String getTypeProfile() {
        return this.get().getTypeFirstRep().getProfile();
    }

    @Override
    public <T extends IBaseDatatype> T getDefaultValue() {
        return (T)this.get().getDefaultValue();
    }

    @Override
    public boolean hasDefaultValue() {
        return this.get().hasDefaultValue();
    }

    @Override
    public <T extends IBaseDatatype> T getFixed() {
        return (T)this.get().getFixed();
    }

    @Override
    public boolean hasFixed() {
        return this.get().hasFixed();
    }

    @Override
    public <T extends IBaseDatatype> T getPattern() {
        return (T)this.get().getPattern();
    }

    @Override
    public boolean hasPattern() {
        return this.get().hasPattern();
    }

    @Override
    public <T extends IBaseDatatype> T getFixedOrPattern() {
        return (T)(this.hasFixed() ? this.get().getFixed() : this.get().getPattern());
    }

    @Override
    public boolean hasFixedOrPattern() {
        return this.hasFixed() || this.hasPattern();
    }

    @Override
    public <T extends IBaseDatatype> T getDefaultOrFixedOrPattern() {
        return this.hasFixedOrPattern() ? this.getFixedOrPattern() : this.getDefaultValue();
    }

    @Override
    public boolean hasDefaultOrFixedOrPattern() {
        return this.hasDefaultValue() || this.hasFixedOrPattern();
    }

    @Override
    public boolean getMustSupport() {
        return this.get().getMustSupport();
    }

    @Override
    public <T extends IBaseDatatypeElement> T getBinding() {
        return (T)this.get().getBinding();
    }

    @Override
    public boolean hasBinding() {
        return this.get().hasBinding();
    }

    @Override
    public String getBindingValueSet() {
        if (this.hasBinding()) {
            String string;
            Type valueSet = this.get().getBinding().getValueSet();
            if (valueSet instanceof Reference) {
                Reference reference = (Reference)valueSet;
                string = reference.getReference();
            } else {
                string = valueSet.primitiveValue();
            }
            return string;
        }
        return null;
    }
}

