/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.adapter.dstu3;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.hl7.fhir.dstu3.model.Extension;
import org.hl7.fhir.dstu3.model.Library;
import org.hl7.fhir.dstu3.model.Measure;
import org.hl7.fhir.dstu3.model.MetadataResource;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.RelatedArtifact;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.opencds.cqf.fhir.utility.adapter.DependencyInfo;
import org.opencds.cqf.fhir.utility.adapter.IDependencyInfo;
import org.opencds.cqf.fhir.utility.adapter.IMeasureAdapter;
import org.opencds.cqf.fhir.utility.adapter.dstu3.KnowledgeArtifactAdapter;
import org.opencds.cqf.fhir.utility.adapter.dstu3.LibraryAdapter;

public class MeasureAdapter
extends KnowledgeArtifactAdapter
implements IMeasureAdapter {
    private boolean checkedEffectiveDataRequirements;
    private Library effectiveDataRequirements;
    private LibraryAdapter effectiveDataRequirementsAdapter;

    public MeasureAdapter(IDomainResource measure) {
        super(measure);
        if (!(measure instanceof Measure)) {
            throw new IllegalArgumentException("resource passed as measure argument is not a Measure resource");
        }
    }

    public MeasureAdapter(Measure measure) {
        super((MetadataResource)measure);
    }

    protected Measure getMeasure() {
        return (Measure)this.resource;
    }

    @Override
    public Measure get() {
        return this.getMeasure();
    }

    public Measure copy() {
        return this.get().copy();
    }

    private String getEdrReferenceString(Extension edrExtension) {
        return edrExtension.getUrl().contains("cqfm") ? ((Reference)edrExtension.getValue()).getReference() : (String)((UriType)edrExtension.getValue()).getValue();
    }

    private Consumer<String> getEdrReferenceConsumer(Extension edrExtension) {
        return edrExtension.getUrl().contains("cqfm") ? reference -> edrExtension.setValue((Type)new Reference(reference)) : reference -> edrExtension.setValue((Type)new UriType(reference));
    }

    private void findEffectiveDataRequirements() {
        if (!this.checkedEffectiveDataRequirements) {
            List edrExtensions = this.getMeasure().getExtension().stream().filter(ext -> ext.getUrl().endsWith("-effectiveDataRequirements")).filter(Extension::hasValue).collect(Collectors.toList());
            Extension edrExtension = edrExtensions.size() == 1 ? (Extension)edrExtensions.get(0) : null;
            Optional<String> maybeEdrReference = Optional.ofNullable(edrExtension).map(this::getEdrReferenceString);
            if (maybeEdrReference.isPresent()) {
                String edrReference = maybeEdrReference.get();
                for (Resource c : this.getMeasure().getContained()) {
                    Library library;
                    if (!c.hasId() || !edrReference.equals(c.getId()) && !edrReference.equals("#" + c.getId()) || !(c instanceof Library)) continue;
                    this.effectiveDataRequirements = library = (Library)c;
                    this.effectiveDataRequirementsAdapter = new LibraryAdapter(this.effectiveDataRequirements);
                }
            }
            this.checkedEffectiveDataRequirements = true;
        }
    }

    @Override
    public List<IDependencyInfo> getDependencies() {
        ArrayList<IDependencyInfo> references = new ArrayList<IDependencyInfo>();
        String referenceSource = this.getReferenceSource();
        this.addProfileReferences(references, referenceSource);
        this.findEffectiveDataRequirements();
        if (this.effectiveDataRequirements != null) {
            references.addAll(this.effectiveDataRequirementsAdapter.getDependencies());
            return references;
        }
        references.addAll(this.getRelatedArtifact().stream().map(ra -> DependencyInfo.convertRelatedArtifact(ra, referenceSource)).collect(Collectors.toList()));
        for (Reference library : this.getMeasure().getLibrary()) {
            DependencyInfo dependency = new DependencyInfo(referenceSource, library.getReference(), library.getExtension(), arg_0 -> ((Reference)library).setReference(arg_0));
            references.add(dependency);
        }
        this.get().getExtension().stream().filter(e -> CANONICAL_EXTENSIONS.contains(e.getUrl())).forEach(referenceExt -> references.add(new DependencyInfo(referenceSource, this.getEdrReferenceString((Extension)referenceExt), referenceExt.getExtension(), this.getEdrReferenceConsumer((Extension)referenceExt))));
        this.get().getExtension().stream().filter(e -> REFERENCE_EXTENSIONS.contains(e.getUrl())).forEach(referenceExt -> references.add(new DependencyInfo(referenceSource, ((Reference)referenceExt.getValue()).getReference(), referenceExt.getExtension(), reference -> referenceExt.setValue((Type)new Reference(reference)))));
        this.get().getExtensionsByUrl("http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-component").forEach(ext -> {
            RelatedArtifact ref = (RelatedArtifact)ext.getValue();
            if (ref.hasResource() && ref.getResource().hasReference()) {
                DependencyInfo dep = new DependencyInfo(referenceSource, ref.getResource().getReference(), ref.getExtension(), reference -> ref.getResource().setReference(reference));
                references.add(dep);
            }
        });
        return references;
    }
}

