/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.adapter.dstu3;

import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.dstu3.model.Parameters;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.opencds.cqf.fhir.utility.adapter.IParametersAdapter;
import org.opencds.cqf.fhir.utility.adapter.IParametersParameterComponentAdapter;
import org.opencds.cqf.fhir.utility.adapter.dstu3.ResourceAdapter;

class ParametersAdapter
extends ResourceAdapter
implements IParametersAdapter {
    private final Parameters parameters;

    public ParametersAdapter(IBaseResource parameters) {
        super(parameters);
        if (!parameters.fhirType().equals("Parameters")) {
            throw new IllegalArgumentException("resource passed as parameters argument is not a Parameters resource");
        }
        this.parameters = (Parameters)parameters;
    }

    protected Parameters getParameters() {
        return this.parameters;
    }

    @Override
    public boolean hasParameter() {
        return this.parameters.hasParameter();
    }

    @Override
    public List<IParametersParameterComponentAdapter> getParameter() {
        return this.getParameters().getParameter().stream().map(this.adapterFactory::createParametersParameter).toList();
    }

    @Override
    public void setParameter(List<IBaseBackboneElement> parametersParameterComponents) {
        this.getParameters().setParameter(parametersParameterComponents.stream().map(x -> (Parameters.ParametersParameterComponent)x).collect(Collectors.toList()));
    }

    @Override
    public void addParameter(String name, String value) {
        this.getParameters().addParameter().setName(name).setValue((Type)new StringType(value));
    }

    @Override
    public void addParameter(String name, IBase value) {
        if (!(value instanceof Type)) {
            throw new IllegalArgumentException("element passed as value argument is not a valid type");
        }
        Type type = (Type)value;
        this.getParameters().addParameter(this.addParameter().setName(name).setValue(type));
    }

    @Override
    public void addParameter(String name, IBaseResource resource) {
        if (!(resource instanceof Resource)) {
            throw new IllegalArgumentException("element passed as value argument is not a valid data type");
        }
        Resource resource1 = (Resource)resource;
        this.getParameters().addParameter().setName(name).setResource(resource1);
    }

    @Override
    public void addParameter(IBase parameter) {
        if (!(parameter instanceof Parameters.ParametersParameterComponent)) {
            throw new IllegalArgumentException("element passed as parameter argument is not a valid parameter component");
        }
        Parameters.ParametersParameterComponent component = (Parameters.ParametersParameterComponent)parameter;
        this.getParameters().addParameter(component);
    }

    public Parameters.ParametersParameterComponent addParameter() {
        return this.getParameters().addParameter();
    }

    public List<Type> getParameterValues(String name) {
        return this.getParameters().getParameter().stream().filter(p -> p.getName().equals(name)).map(Parameters.ParametersParameterComponent::getValue).collect(Collectors.toList());
    }

    @Override
    public boolean hasParameter(String name) {
        return this.getParameters().getParameter().stream().anyMatch(p -> p.getName().equals(name));
    }

    @Override
    public IParametersParameterComponentAdapter getParameter(String name) {
        return this.getParameters().getParameter().stream().filter(p -> p.getName().equals(name)).map(this.adapterFactory::createParametersParameter).findFirst().orElse(null);
    }
}

