/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.adapter.dstu3;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.dstu3.model.PlanDefinition;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.opencds.cqf.cql.engine.model.ModelResolver;
import org.opencds.cqf.fhir.utility.adapter.IPlanDefinitionActionAdapter;
import org.opencds.cqf.fhir.utility.adapter.ITriggerDefinitionAdapter;
import org.opencds.cqf.fhir.utility.adapter.dstu3.TriggerDefinitionAdapter;
import org.opencds.cqf.fhir.utility.model.FhirModelResolverCache;

public class PlanDefinitionActionAdapter
implements IPlanDefinitionActionAdapter {
    private final PlanDefinition.PlanDefinitionActionComponent action;
    private final FhirContext fhirContext;
    private final ModelResolver modelResolver;

    public PlanDefinitionActionAdapter(IBaseBackboneElement action) {
        if (!(action instanceof PlanDefinition.PlanDefinitionActionComponent)) {
            throw new IllegalArgumentException("object passed as action argument is not a PlanDefinitionActionComponent data type");
        }
        this.action = (PlanDefinition.PlanDefinitionActionComponent)action;
        this.fhirContext = FhirContext.forDstu3Cached();
        this.modelResolver = FhirModelResolverCache.resolverForVersion(FhirVersionEnum.DSTU3);
    }

    @Override
    public PlanDefinition.PlanDefinitionActionComponent get() {
        return this.action;
    }

    @Override
    public FhirContext fhirContext() {
        return this.fhirContext;
    }

    @Override
    public ModelResolver getModelResolver() {
        return this.modelResolver;
    }

    @Override
    public boolean hasTrigger() {
        return this.get().hasTriggerDefinition();
    }

    @Override
    public List<ITriggerDefinitionAdapter> getTrigger() {
        return this.get().getTriggerDefinition().stream().map(TriggerDefinitionAdapter::new).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public List<String> getTriggerType() {
        return this.get().getTriggerDefinition().stream().map(t -> t.getType().toCode()).collect(Collectors.toUnmodifiableList());
    }
}

