/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.adapter.dstu3;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.dstu3.model.MetadataResource;
import org.hl7.fhir.dstu3.model.Questionnaire;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.opencds.cqf.fhir.utility.adapter.DependencyInfo;
import org.opencds.cqf.fhir.utility.adapter.IDependencyInfo;
import org.opencds.cqf.fhir.utility.adapter.IQuestionnaireAdapter;
import org.opencds.cqf.fhir.utility.adapter.dstu3.KnowledgeArtifactAdapter;

public class QuestionnaireAdapter
extends KnowledgeArtifactAdapter
implements IQuestionnaireAdapter {
    public QuestionnaireAdapter(IDomainResource questionnaire) {
        super(questionnaire);
        if (!(questionnaire instanceof Questionnaire)) {
            throw new IllegalArgumentException("resource passed as questionnaire argument is not a Questionnaire resource");
        }
    }

    public QuestionnaireAdapter(Questionnaire questionnaire) {
        super((MetadataResource)questionnaire);
    }

    protected Questionnaire getQuestionnaire() {
        return (Questionnaire)this.resource;
    }

    @Override
    public Questionnaire get() {
        return (Questionnaire)this.resource;
    }

    public Questionnaire copy() {
        return this.get().copy();
    }

    @Override
    public List<IDependencyInfo> getDependencies() {
        ArrayList<IDependencyInfo> references = new ArrayList<IDependencyInfo>();
        String referenceSource = this.getReferenceSource();
        this.addProfileReferences(references, referenceSource);
        this.getQuestionnaire().getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/cqif-library").forEach(libraryExt -> references.add(new DependencyInfo(referenceSource, ((Reference)libraryExt.getValue()).getReference(), libraryExt.getExtension(), reference -> libraryExt.setValue((Type)new Reference(reference)))));
        this.getQuestionnaire().getItem().forEach(item -> this.getDependenciesOfItem((Questionnaire.QuestionnaireItemComponent)item, (List<IDependencyInfo>)references, referenceSource));
        return references;
    }

    private void getDependenciesOfItem(Questionnaire.QuestionnaireItemComponent item, List<IDependencyInfo> references, String referenceSource) {
        if (item.hasDefinition()) {
            String definition = item.getDefinition().split("#")[0];
            references.add(new DependencyInfo(referenceSource, definition, item.getExtension(), null));
        }
        if (item.hasOptions()) {
            references.add(new DependencyInfo(referenceSource, item.getOptions().getReference(), item.getExtension(), reference -> item.setOptions(new Reference(reference))));
        }
        item.getExtension().stream().filter(e -> REFERENCE_EXTENSIONS.contains(e.getUrl())).forEach(referenceExt -> references.add(new DependencyInfo(referenceSource, ((UriType)referenceExt.getValue()).asStringValue(), referenceExt.getExtension(), reference -> referenceExt.setValue((Type)new UriType(reference)))));
        item.getItem().forEach(childItem -> this.getDependenciesOfItem((Questionnaire.QuestionnaireItemComponent)childItem, references, referenceSource));
    }
}

