/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.adapter.dstu3;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import org.hl7.fhir.dstu3.model.ValueSet;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.opencds.cqf.cql.engine.model.ModelResolver;
import org.opencds.cqf.fhir.utility.adapter.IValueSetExpansionContainsAdapter;
import org.opencds.cqf.fhir.utility.model.FhirModelResolverCache;

public class ValueSetExpansionContainsAdapter
implements IValueSetExpansionContainsAdapter {
    private final ValueSet.ValueSetExpansionContainsComponent contains;
    private final FhirContext fhirContext;
    private final ModelResolver modelResolver;

    public ValueSetExpansionContainsAdapter(IBaseBackboneElement contains) {
        if (!(contains instanceof ValueSet.ValueSetExpansionContainsComponent)) {
            throw new IllegalArgumentException("element passed as contains argument is not a ValueSetExpansionContainsComponent element");
        }
        this.contains = (ValueSet.ValueSetExpansionContainsComponent)contains;
        this.fhirContext = FhirContext.forDstu3Cached();
        this.modelResolver = FhirModelResolverCache.resolverForVersion(FhirVersionEnum.DSTU3);
    }

    @Override
    public ValueSet.ValueSetExpansionContainsComponent get() {
        return this.contains;
    }

    @Override
    public FhirContext fhirContext() {
        return this.fhirContext;
    }

    @Override
    public ModelResolver getModelResolver() {
        return this.modelResolver;
    }

    @Override
    public boolean hasCode() {
        return this.get().hasCode();
    }

    @Override
    public String getCode() {
        return this.get().getCode();
    }

    @Override
    public boolean hasSystem() {
        return this.get().hasSystem();
    }

    @Override
    public String getSystem() {
        return this.get().getSystem();
    }

    @Override
    public boolean hasDisplay() {
        return this.get().hasDisplay();
    }

    @Override
    public String getDisplay() {
        return this.get().getDisplay();
    }
}

