/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.adapter.r4;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBaseDatatypeElement;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.DataRequirement;
import org.opencds.cqf.cql.engine.model.ModelResolver;
import org.opencds.cqf.fhir.utility.adapter.ICodingAdapter;
import org.opencds.cqf.fhir.utility.adapter.IDataRequirementCodeFilterAdapter;
import org.opencds.cqf.fhir.utility.adapter.r4.CodingAdapter;
import org.opencds.cqf.fhir.utility.model.FhirModelResolverCache;

public class DataRequirementCodeFilterAdapter
implements IDataRequirementCodeFilterAdapter {
    private final DataRequirement.DataRequirementCodeFilterComponent codeFilter;
    private final FhirContext fhirContext;
    private final ModelResolver modelResolver;

    public DataRequirementCodeFilterAdapter(IBaseDatatypeElement codeFilter) {
        if (!(codeFilter instanceof DataRequirement.DataRequirementCodeFilterComponent)) {
            throw new IllegalArgumentException("object passed as codeFilter argument is not a DataRequirementCodeFilterComponent data type");
        }
        this.codeFilter = (DataRequirement.DataRequirementCodeFilterComponent)codeFilter;
        this.fhirContext = FhirContext.forR4Cached();
        this.modelResolver = FhirModelResolverCache.resolverForVersion(FhirVersionEnum.R4);
    }

    @Override
    public DataRequirement.DataRequirementCodeFilterComponent get() {
        return this.codeFilter;
    }

    @Override
    public FhirContext fhirContext() {
        return this.fhirContext;
    }

    @Override
    public ModelResolver getModelResolver() {
        return this.modelResolver;
    }

    @Override
    public boolean hasCode() {
        return this.get().hasCode();
    }

    @Override
    public List<ICodingAdapter> getCode() {
        return this.get().getCode().stream().map(CodingAdapter::new).collect(Collectors.toList());
    }

    @Override
    public boolean hasPath() {
        return this.get().hasPath();
    }

    @Override
    public String getPath() {
        return this.get().getPath();
    }

    @Override
    public boolean hasValueSet() {
        return this.get().hasValueSet();
    }

    @Override
    public IPrimitiveType<String> getValueSet() {
        return this.get().getValueSetElement();
    }
}

