/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.adapter.r4;

import ca.uhn.fhir.context.FhirContext;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.RelatedArtifact;
import org.hl7.fhir.r4.model.RequestGroup;
import org.opencds.cqf.cql.engine.model.ModelResolver;
import org.opencds.cqf.fhir.utility.adapter.ICodeableConceptAdapter;
import org.opencds.cqf.fhir.utility.adapter.IRequestActionAdapter;
import org.opencds.cqf.fhir.utility.adapter.r4.CodeableConceptAdapter;
import org.opencds.cqf.fhir.utility.model.FhirModelResolverCache;

public class RequestActionAdapter
implements IRequestActionAdapter {
    private final RequestGroup.RequestGroupActionComponent action;
    private final FhirContext fhirContext = FhirContext.forR4Cached();
    private final ModelResolver modelResolver;

    public RequestActionAdapter(IBaseBackboneElement action) {
        if (!(action instanceof RequestGroup.RequestGroupActionComponent)) {
            throw new IllegalArgumentException("element passed as action argument is not a RequestGroupActionComponent Element");
        }
        this.action = (RequestGroup.RequestGroupActionComponent)action;
        this.modelResolver = FhirModelResolverCache.resolverForVersion(this.fhirContext.getVersion().getVersion());
    }

    @Override
    public RequestGroup.RequestGroupActionComponent get() {
        return this.action;
    }

    @Override
    public FhirContext fhirContext() {
        return this.fhirContext;
    }

    @Override
    public ModelResolver getModelResolver() {
        return this.modelResolver;
    }

    @Override
    public String getId() {
        return this.get().getId();
    }

    @Override
    public boolean hasTitle() {
        return this.get().hasTitle();
    }

    @Override
    public String getTitle() {
        return this.get().getTitle();
    }

    @Override
    public boolean hasDescription() {
        return this.get().hasDescription();
    }

    @Override
    public String getDescription() {
        return this.get().getDescription();
    }

    @Override
    public boolean hasType() {
        return this.get().hasType();
    }

    @Override
    public ICodeableConceptAdapter getType() {
        return new CodeableConceptAdapter((ICompositeType)this.get().getType());
    }

    @Override
    public boolean hasPriority() {
        return this.get().hasPriority();
    }

    @Override
    public String getPriority() {
        return this.get().getPriority().toCode();
    }

    @Override
    public boolean hasDocumentation() {
        return this.get().hasDocumentation();
    }

    public List<RelatedArtifact> getDocumentation() {
        return this.get().getDocumentation();
    }

    @Override
    public boolean hasSelectionBehavior() {
        return this.get().hasSelectionBehavior();
    }

    @Override
    public String getSelectionBehavior() {
        return this.get().getSelectionBehavior().toCode();
    }

    @Override
    public boolean hasResource() {
        return this.get().hasResource();
    }

    public Reference getResource() {
        return this.get().getResource();
    }

    @Override
    public boolean hasAction() {
        return this.get().hasAction();
    }

    @Override
    public List<IRequestActionAdapter> getAction() {
        return this.get().getAction().stream().map(RequestActionAdapter::new).collect(Collectors.toUnmodifiableList());
    }
}

