/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.adapter.r4;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.ValueSet;
import org.opencds.cqf.cql.engine.model.ModelResolver;
import org.opencds.cqf.fhir.utility.adapter.IValueSetConceptReferenceAdapter;
import org.opencds.cqf.fhir.utility.model.FhirModelResolverCache;

public class ValueSetConceptReferenceAdapter
implements IValueSetConceptReferenceAdapter {
    private final ValueSet.ConceptReferenceComponent conceptReference;
    private final FhirContext fhirContext;
    private final ModelResolver modelResolver;

    public ValueSetConceptReferenceAdapter(IBaseBackboneElement conceptReference) {
        if (!(conceptReference instanceof ValueSet.ConceptReferenceComponent)) {
            throw new IllegalArgumentException("element passed as conceptReference argument is not a ConceptReferenceComponent element");
        }
        this.conceptReference = (ValueSet.ConceptReferenceComponent)conceptReference;
        this.fhirContext = FhirContext.forR4Cached();
        this.modelResolver = FhirModelResolverCache.resolverForVersion(FhirVersionEnum.R4);
    }

    @Override
    public ValueSet.ConceptReferenceComponent get() {
        return this.conceptReference;
    }

    @Override
    public FhirContext fhirContext() {
        return this.fhirContext;
    }

    @Override
    public ModelResolver getModelResolver() {
        return this.modelResolver;
    }

    @Override
    public boolean hasCode() {
        return this.get().hasCode();
    }

    @Override
    public String getCode() {
        return this.get().getCode();
    }
}

