/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.adapter.r4;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.ValueSet;
import org.opencds.cqf.cql.engine.model.ModelResolver;
import org.opencds.cqf.fhir.utility.adapter.IValueSetConceptReferenceAdapter;
import org.opencds.cqf.fhir.utility.adapter.IValueSetConceptSetAdapter;
import org.opencds.cqf.fhir.utility.adapter.r4.ValueSetConceptReferenceAdapter;
import org.opencds.cqf.fhir.utility.model.FhirModelResolverCache;

public class ValueSetConceptSetAdapter
implements IValueSetConceptSetAdapter {
    private final ValueSet.ConceptSetComponent conceptSet;
    private final FhirContext fhirContext;
    private final ModelResolver modelResolver;

    public ValueSetConceptSetAdapter(IBaseBackboneElement conceptSet) {
        if (!(conceptSet instanceof ValueSet.ConceptSetComponent)) {
            throw new IllegalArgumentException("element passed as conceptSet argument is not a ConceptSetComponent element");
        }
        this.conceptSet = (ValueSet.ConceptSetComponent)conceptSet;
        this.fhirContext = FhirContext.forR4Cached();
        this.modelResolver = FhirModelResolverCache.resolverForVersion(FhirVersionEnum.R4);
    }

    @Override
    public ValueSet.ConceptSetComponent get() {
        return this.conceptSet;
    }

    @Override
    public FhirContext fhirContext() {
        return this.fhirContext;
    }

    @Override
    public ModelResolver getModelResolver() {
        return this.modelResolver;
    }

    @Override
    public boolean hasConcept() {
        return this.get().hasConcept();
    }

    @Override
    public List<IValueSetConceptReferenceAdapter> getConcept() {
        return this.get().getConcept().stream().map(ValueSetConceptReferenceAdapter::new).collect(Collectors.toList());
    }

    @Override
    public boolean hasSystem() {
        return this.get().hasSystem();
    }

    @Override
    public String getSystem() {
        return this.get().getSystem();
    }
}

