/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.adapter.r5;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Coding;
import org.opencds.cqf.cql.engine.model.ModelResolver;
import org.opencds.cqf.fhir.utility.adapter.ICodingAdapter;
import org.opencds.cqf.fhir.utility.model.FhirModelResolverCache;

public class CodingAdapter
implements ICodingAdapter {
    private final Coding coding;
    private final FhirContext fhirContext;
    private final ModelResolver modelResolver;

    public CodingAdapter(ICompositeType coding) {
        if (!(coding instanceof Coding)) {
            throw new IllegalArgumentException("object passed as coding argument is not a Coding data type");
        }
        this.coding = (Coding)coding;
        this.fhirContext = FhirContext.forR5Cached();
        this.modelResolver = FhirModelResolverCache.resolverForVersion(FhirVersionEnum.R5);
    }

    @Override
    public Coding get() {
        return this.coding;
    }

    @Override
    public FhirContext fhirContext() {
        return this.fhirContext;
    }

    @Override
    public ModelResolver getModelResolver() {
        return this.modelResolver;
    }

    @Override
    public String getCode() {
        return this.get().getCode();
    }

    @Override
    public boolean hasCode() {
        return this.get().hasCode();
    }

    @Override
    public ICodingAdapter setCode(String code) {
        this.get().setCode(code);
        return this;
    }

    @Override
    public String getDisplay() {
        return this.get().getDisplay();
    }

    @Override
    public boolean hasDisplay() {
        return this.get().hasDisplay();
    }

    @Override
    public ICodingAdapter setDisplay(String display) {
        this.get().setDisplay(display);
        return this;
    }

    @Override
    public String getSystem() {
        return this.get().getSystem();
    }

    @Override
    public boolean hasSystem() {
        return this.get().hasSystem();
    }

    @Override
    public ICodingAdapter setSystem(String system) {
        this.get().setSystem(system);
        return this;
    }
}

