/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.adapter.r5;

import ca.uhn.fhir.context.FhirContext;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.DataRequirement;
import org.opencds.cqf.cql.engine.model.ModelResolver;
import org.opencds.cqf.fhir.utility.adapter.IDataRequirementAdapter;
import org.opencds.cqf.fhir.utility.adapter.IDataRequirementCodeFilterAdapter;
import org.opencds.cqf.fhir.utility.adapter.r5.DataRequirementCodeFilterAdapter;
import org.opencds.cqf.fhir.utility.model.FhirModelResolverCache;

public class DataRequirementAdapter
implements IDataRequirementAdapter {
    private final DataRequirement dataRequirement;
    private final FhirContext fhirContext;
    private final ModelResolver modelResolver;

    public DataRequirementAdapter(ICompositeType compositeType) {
        if (!(compositeType instanceof DataRequirement)) {
            throw new IllegalArgumentException("object passed as dataRequirement argument is not a DataRequirement data type");
        }
        DataRequirement dataRequirementInner = (DataRequirement)compositeType;
        this.dataRequirement = dataRequirementInner;
        this.fhirContext = FhirContext.forR5Cached();
        this.modelResolver = FhirModelResolverCache.resolverForVersion(this.fhirContext.getVersion().getVersion());
    }

    @Override
    public DataRequirement get() {
        return this.dataRequirement;
    }

    @Override
    public FhirContext fhirContext() {
        return this.fhirContext;
    }

    @Override
    public ModelResolver getModelResolver() {
        return this.modelResolver;
    }

    @Override
    public boolean hasId() {
        return this.get().hasId();
    }

    @Override
    public String getId() {
        return this.get().getId();
    }

    @Override
    public boolean hasType() {
        return this.get().hasType();
    }

    @Override
    public String getType() {
        return this.get().getType().toCode();
    }

    @Override
    public boolean hasCodeFilter() {
        return this.get().hasCodeFilter();
    }

    @Override
    public List<IDataRequirementCodeFilterAdapter> getCodeFilter() {
        return this.get().getCodeFilter().stream().map(DataRequirementCodeFilterAdapter::new).collect(Collectors.toUnmodifiableList());
    }
}

