/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.adapter.r5;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.DataRequirement;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Expression;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.MetadataResource;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.opencds.cqf.fhir.utility.Canonicals;
import org.opencds.cqf.fhir.utility.adapter.DependencyInfo;
import org.opencds.cqf.fhir.utility.adapter.IDependencyInfo;
import org.opencds.cqf.fhir.utility.adapter.IPlanDefinitionActionAdapter;
import org.opencds.cqf.fhir.utility.adapter.IPlanDefinitionAdapter;
import org.opencds.cqf.fhir.utility.adapter.r5.KnowledgeArtifactAdapter;
import org.opencds.cqf.fhir.utility.adapter.r5.PlanDefinitionActionAdapter;

public class PlanDefinitionAdapter
extends KnowledgeArtifactAdapter
implements IPlanDefinitionAdapter {
    public PlanDefinitionAdapter(IDomainResource planDefinition) {
        super(planDefinition);
        if (!(planDefinition instanceof PlanDefinition)) {
            throw new IllegalArgumentException("resource passed as planDefinition argument is not a PlanDefinition resource");
        }
    }

    public PlanDefinitionAdapter(PlanDefinition planDefinition) {
        super((MetadataResource)planDefinition);
    }

    protected PlanDefinition getPlanDefinition() {
        return (PlanDefinition)this.resource;
    }

    @Override
    public PlanDefinition get() {
        return this.getPlanDefinition();
    }

    public PlanDefinition copy() {
        return this.get().copy();
    }

    @Override
    public List<IDependencyInfo> getDependencies() {
        ArrayList<IDependencyInfo> references = new ArrayList<IDependencyInfo>();
        String referenceSource = this.getReferenceSource();
        this.addProfileReferences(references, referenceSource);
        references.addAll(this.getRelatedArtifact().stream().map(ra -> DependencyInfo.convertRelatedArtifact(ra, referenceSource)).collect(Collectors.toList()));
        List libraries = this.getPlanDefinition().getLibrary();
        for (CanonicalType ct : libraries) {
            DependencyInfo dependency = new DependencyInfo(referenceSource, (String)ct.getValue(), ct.getExtension(), arg_0 -> ((CanonicalType)ct).setValue(arg_0));
            references.add(dependency);
        }
        this.getPlanDefinition().getAction().forEach(action -> this.getDependenciesOfAction((PlanDefinition.PlanDefinitionActionComponent)action, (List<IDependencyInfo>)references, referenceSource));
        this.getPlanDefinition().getExtension().stream().filter(ext -> ext.getUrl().contains("cpg-partOf")).filter(Extension::hasValue).findAny().ifPresent(ext -> references.add(new DependencyInfo(referenceSource, (String)((CanonicalType)ext.getValue()).getValue(), ext.getExtension(), reference -> ext.setValue((DataType)new CanonicalType(reference)))));
        return references;
    }

    private void getDependenciesOfAction(PlanDefinition.PlanDefinitionActionComponent action, List<IDependencyInfo> references, String referenceSource) {
        action.getTrigger().stream().flatMap(t -> t.getData().stream()).forEach(eventData -> {
            eventData.getProfile().stream().filter(IPrimitiveType::hasValue).forEach(profile -> references.add(new DependencyInfo(referenceSource, (String)profile.getValue(), profile.getExtension(), arg_0 -> ((CanonicalType)profile).setValue(arg_0))));
            eventData.getCodeFilter().stream().filter(cf -> cf.hasValueSet()).forEach(cf -> references.add(new DependencyInfo(referenceSource, cf.getValueSet(), cf.getExtension(), arg_0 -> ((DataRequirement.DataRequirementCodeFilterComponent)cf).setValueSet(arg_0))));
        });
        action.getCondition().stream().filter(c -> c.hasExpression()).map(c -> c.getExpression()).filter(e -> e.hasReference()).forEach(expression -> references.add(new DependencyInfo(referenceSource, expression.getReference(), expression.getExtension(), arg_0 -> ((Expression)expression).setReference(arg_0))));
        action.getDynamicValue().stream().filter(dv -> dv.hasExpression()).map(dv -> dv.getExpression()).filter(e -> e.hasReference()).forEach(expression -> references.add(new DependencyInfo(referenceSource, expression.getReference(), expression.getExtension(), arg_0 -> ((Expression)expression).setReference(arg_0))));
        Stream.concat(action.getInput().stream().map(i -> i.getRequirement()), action.getOutput().stream().map(o -> o.getRequirement())).forEach(inputOrOutput -> {
            inputOrOutput.getProfile().stream().filter(IPrimitiveType::hasValue).forEach(profile -> references.add(new DependencyInfo(referenceSource, (String)profile.getValue(), profile.getExtension(), arg_0 -> ((CanonicalType)profile).setValue(arg_0))));
            inputOrOutput.getCodeFilter().stream().filter(cf -> cf.hasValueSet()).forEach(cf -> references.add(new DependencyInfo(referenceSource, cf.getValueSet(), cf.getExtension(), arg_0 -> ((DataRequirement.DataRequirementCodeFilterComponent)cf).setValueSet(arg_0))));
        });
        CanonicalType definition = action.getDefinitionCanonicalType();
        if (definition != null && definition.hasValue()) {
            references.add(new DependencyInfo(referenceSource, (String)definition.getValue(), definition.getExtension(), arg_0 -> ((CanonicalType)definition).setValue(arg_0)));
        }
        action.getAction().forEach(nestedAction -> this.getDependenciesOfAction((PlanDefinition.PlanDefinitionActionComponent)nestedAction, references, referenceSource));
    }

    @Override
    public Map<String, String> getReferencedLibraries() {
        Map<String, String> libraries = this.getPlanDefinition().getLibrary().stream().collect(Collectors.toMap(l -> Objects.requireNonNull(Canonicals.getIdPart(l)), CanonicalType::getCanonical));
        libraries.putAll(this.resolveCqfLibraries());
        return libraries;
    }

    @Override
    public String getDescription() {
        return this.get().getDescription();
    }

    @Override
    public boolean hasLibrary() {
        return this.get().hasLibrary();
    }

    @Override
    public List<String> getLibrary() {
        return this.get().getLibrary().stream().map(PrimitiveType::asStringValue).collect(Collectors.toList());
    }

    @Override
    public boolean hasAction() {
        return this.get().hasAction();
    }

    @Override
    public List<IPlanDefinitionActionAdapter> getAction() {
        return this.get().getAction().stream().map(PlanDefinitionActionAdapter::new).collect(Collectors.toList());
    }
}

