/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.adapter.r5;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.MetadataResource;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.ValueSet;
import org.opencds.cqf.cql.engine.runtime.Code;
import org.opencds.cqf.fhir.utility.ValueSets;
import org.opencds.cqf.fhir.utility.adapter.DependencyInfo;
import org.opencds.cqf.fhir.utility.adapter.IDependencyInfo;
import org.opencds.cqf.fhir.utility.adapter.IValueSetAdapter;
import org.opencds.cqf.fhir.utility.adapter.IValueSetConceptSetAdapter;
import org.opencds.cqf.fhir.utility.adapter.IValueSetExpansionContainsAdapter;
import org.opencds.cqf.fhir.utility.adapter.r5.KnowledgeArtifactAdapter;
import org.opencds.cqf.fhir.utility.adapter.r5.ValueSetConceptSetAdapter;
import org.opencds.cqf.fhir.utility.adapter.r5.ValueSetExpansionContainsAdapter;

public class ValueSetAdapter
extends KnowledgeArtifactAdapter
implements IValueSetAdapter {
    public ValueSetAdapter(IDomainResource valueSet) {
        super(valueSet);
        if (!(valueSet instanceof ValueSet)) {
            throw new IllegalArgumentException("resource passed as valueSet argument is not a ValueSet resource");
        }
    }

    public ValueSetAdapter(ValueSet valueSet) {
        super((MetadataResource)valueSet);
    }

    protected ValueSet getValueSet() {
        return (ValueSet)this.resource;
    }

    @Override
    public ValueSet get() {
        return (ValueSet)this.resource;
    }

    public ValueSet copy() {
        return this.get().copy();
    }

    @Override
    public List<IDependencyInfo> getDependencies() {
        ArrayList<IDependencyInfo> references = new ArrayList<IDependencyInfo>();
        String referenceSource = this.getReferenceSource();
        this.addProfileReferences(references, referenceSource);
        Stream.concat(this.getValueSet().getCompose().getInclude().stream(), this.getValueSet().getCompose().getExclude().stream()).forEach(component -> {
            if (component.hasValueSet()) {
                component.getValueSet().forEach(ct -> references.add(new DependencyInfo(referenceSource, (String)ct.getValue(), ct.getExtension(), arg_0 -> ((CanonicalType)ct).setValue(arg_0))));
            }
            if (component.hasSystem()) {
                references.add(new DependencyInfo(referenceSource, component.getSystem(), component.getSystemElement().getExtension(), arg_0 -> ((ValueSet.ConceptSetComponent)component).setSystem(arg_0)));
            }
        });
        return references;
    }

    @Override
    public <T extends IBaseBackboneElement> void setExpansion(T expansion) {
        this.getValueSet().setExpansion((ValueSet.ValueSetExpansionComponent)expansion);
    }

    public ValueSet.ValueSetExpansionComponent getExpansion() {
        return this.getValueSet().getExpansion();
    }

    @Override
    public boolean hasExpansion() {
        return this.getValueSet().hasExpansion();
    }

    @Override
    public boolean hasExpansionContains() {
        return this.getExpansion().hasContains();
    }

    @Override
    public List<IValueSetExpansionContainsAdapter> getExpansionContains() {
        return this.getExpansion().getContains().stream().map(ValueSetExpansionContainsAdapter::new).collect(Collectors.toList());
    }

    public ValueSet.ValueSetExpansionComponent newExpansion() {
        ValueSet.ValueSetExpansionComponent expansion = new ValueSet.ValueSetExpansionComponent(Date.from(Instant.now()));
        expansion.getContains();
        return expansion;
    }

    @Override
    public boolean hasCompose() {
        return this.get().hasCompose();
    }

    @Override
    public boolean hasComposeInclude() {
        return this.get().getCompose().hasInclude();
    }

    @Override
    public List<IValueSetConceptSetAdapter> getComposeInclude() {
        return this.getValueSet().getCompose().getInclude().stream().map(ValueSetConceptSetAdapter::new).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public List<String> getValueSetIncludes() {
        return this.getValueSet().getCompose().getInclude().stream().map(ValueSet.ConceptSetComponent::getValueSet).flatMap(Collection::stream).map(PrimitiveType::asStringValue).distinct().toList();
    }

    @Override
    public boolean hasSimpleCompose() {
        return this.getValueSet().hasCompose() && !this.getValueSet().getCompose().hasExclude() && this.getValueSet().getCompose().getInclude().stream().noneMatch(csc -> csc.hasFilter() || csc.hasValueSet() || !csc.hasSystem() || !csc.hasConcept());
    }

    @Override
    public boolean hasGroupingCompose() {
        return this.getValueSet().hasCompose() && !this.getValueSet().getCompose().hasExclude() && this.getValueSet().getCompose().getInclude().stream().noneMatch(csc -> !csc.hasValueSet() || csc.hasFilter());
    }

    @Override
    public boolean hasNaiveParameter() {
        return this.getValueSet().getExpansion().getParameter().stream().anyMatch(p -> p.getName().equals("naive"));
    }

    public ValueSet.ValueSetExpansionParameterComponent createNaiveParameter() {
        return new ValueSet.ValueSetExpansionParameterComponent().setName("naive").setValue((DataType)new BooleanType(true));
    }

    @Override
    public void naiveExpand() {
        ValueSet.ValueSetExpansionComponent expansion = this.newExpansion().addParameter(this.createNaiveParameter());
        List<Code> codesInCompose = ValueSets.getCodesInCompose(this.fhirContext, (IBaseResource)this.getValueSet());
        if (codesInCompose == null) {
            return;
        }
        for (Code code : codesInCompose) {
            expansion.addContains().setCode(code.getCode()).setSystem(code.getSystem()).setVersion(code.getVersion()).setDisplay(code.getDisplay());
        }
        this.getValueSet().setExpansion(expansion);
    }
}

