/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.builder;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Date;
import org.hl7.fhir.dstu3.model.Composition;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.r4.model.Composition;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Enumerations;
import org.opencds.cqf.fhir.utility.builder.BaseDomainResourceBuilder;
import org.opencds.cqf.fhir.utility.builder.CodeableConceptSettings;
import org.opencds.cqf.fhir.utility.builder.CodingSettings;

public class CompositionBuilder<T extends IDomainResource>
extends BaseDomainResourceBuilder<CompositionBuilder<T>, T> {
    private String status;
    private String title;
    private CodeableConceptSettings type;
    private String subject;
    private String author;
    private String custodian;
    private Date date = new Date();

    public CompositionBuilder(Class<T> resourceClass) {
        super(resourceClass);
    }

    public CompositionBuilder(Class<T> resourceClass, String id) {
        super(resourceClass, id);
    }

    public CompositionBuilder(Class<T> resourceClass, String id, CodeableConceptSettings type, String status, String author, String title) {
        this(resourceClass, id);
        Preconditions.checkNotNull((Object)type);
        Preconditions.checkNotNull((Object)status);
        Preconditions.checkNotNull((Object)author);
        Preconditions.checkNotNull((Object)title);
        this.type = type;
        this.status = status;
        this.author = author;
        this.title = title;
    }

    public CompositionBuilder<T> withStatus(String status) {
        Preconditions.checkNotNull((Object)status);
        this.status = status;
        return this;
    }

    public CompositionBuilder<T> withTitle(String title) {
        Preconditions.checkNotNull((Object)title);
        this.title = title;
        return this;
    }

    public CompositionBuilder<T> withType(CodeableConceptSettings type) {
        Preconditions.checkNotNull((Object)type);
        this.type = type;
        return this;
    }

    public CompositionBuilder<T> withDate(Date date) {
        Preconditions.checkNotNull((Object)date);
        this.date = date;
        return this;
    }

    public CompositionBuilder<T> withSubject(String subject) {
        this.subject = CompositionBuilder.ensurePatientReference(subject);
        return this;
    }

    public CompositionBuilder<T> withAuthor(String author) {
        Preconditions.checkNotNull((Object)author);
        Preconditions.checkArgument((author.startsWith("Practitioner") || author.startsWith("PractitionerRole") || author.startsWith("Device") || author.startsWith("Patient") || author.startsWith("RelatedPerson") || author.startsWith("Organization") ? 1 : 0) != 0);
        this.author = author;
        return this;
    }

    public CompositionBuilder<T> withCustodian(String custodian) {
        this.custodian = CompositionBuilder.ensureOrganizationReference(custodian);
        return this;
    }

    @Override
    public T build() {
        Preconditions.checkNotNull((Object)this.type);
        Preconditions.checkNotNull((Object)this.status);
        Preconditions.checkNotNull((Object)this.author);
        Preconditions.checkNotNull((Object)this.title);
        Preconditions.checkArgument((!this.type.getCodingSettings().isEmpty() && this.type.getCodingSettings().size() == 1 ? 1 : 0) != 0);
        return (T)((IDomainResource)super.build());
    }

    private CodingSettings getTypeSetting() {
        return this.type.getCodingSettingsArray()[0];
    }

    @Override
    protected void initializeDstu3(T resource) {
        super.initializeDstu3(resource);
        org.hl7.fhir.dstu3.model.Composition composition = (org.hl7.fhir.dstu3.model.Composition)resource;
        composition.setDate(this.date).setIdentifier(new Identifier().setSystem((String)this.getIdentifier().getKey()).setValue((String)this.getIdentifier().getValue())).setStatus(Composition.CompositionStatus.valueOf((String)this.status)).setSubject(new Reference(this.subject)).setTitle(this.title).setType(new org.hl7.fhir.dstu3.model.CodeableConcept().addCoding(new org.hl7.fhir.dstu3.model.Coding().setSystem(this.getTypeSetting().getSystem()).setCode(this.getTypeSetting().getCode()).setDisplay(this.getTypeSetting().getDisplay()))).addAuthor(new Reference(this.author)).setCustodian(new Reference(this.custodian));
    }

    @Override
    protected void initializeR4(T resource) {
        super.initializeR4(resource);
        Composition composition = (Composition)resource;
        composition.setDate(this.date).setIdentifier(new org.hl7.fhir.r4.model.Identifier().setSystem((String)this.getIdentifier().getKey()).setValue((String)this.getIdentifier().getValue())).setStatus(Composition.CompositionStatus.valueOf((String)this.status)).setSubject(new org.hl7.fhir.r4.model.Reference(this.subject)).setTitle(this.title).setType(new org.hl7.fhir.r4.model.CodeableConcept().addCoding(new org.hl7.fhir.r4.model.Coding().setSystem(this.getTypeSetting().getSystem()).setCode(this.getTypeSetting().getCode()).setDisplay(this.getTypeSetting().getDisplay()))).addAuthor(new org.hl7.fhir.r4.model.Reference(this.author)).setCustodian(new org.hl7.fhir.r4.model.Reference(this.custodian));
    }

    @Override
    protected void initializeR5(T resource) {
        super.initializeR5(resource);
        org.hl7.fhir.r5.model.Composition composition = (org.hl7.fhir.r5.model.Composition)resource;
        ArrayList<org.hl7.fhir.r5.model.Identifier> r5Identifiers = new ArrayList<org.hl7.fhir.r5.model.Identifier>();
        org.hl7.fhir.r5.model.Identifier r5Identifier = new org.hl7.fhir.r5.model.Identifier();
        r5Identifier.setSystem((String)this.getIdentifier().getKey()).setValue((String)this.getIdentifier().getValue());
        r5Identifiers.add(r5Identifier);
        ArrayList<org.hl7.fhir.r5.model.Reference> r5References = new ArrayList<org.hl7.fhir.r5.model.Reference>();
        org.hl7.fhir.r5.model.Reference r5Reference = new org.hl7.fhir.r5.model.Reference(this.subject);
        r5References.add(r5Reference);
        composition.setDate(this.date).setIdentifier(r5Identifiers).setStatus(Enumerations.CompositionStatus.valueOf((String)this.status)).setSubject(r5References).setTitle(this.title).setType(new CodeableConcept().addCoding(new Coding().setSystem(this.getTypeSetting().getSystem()).setCode(this.getTypeSetting().getCode()).setDisplay(this.getTypeSetting().getDisplay()))).addAuthor(new org.hl7.fhir.r5.model.Reference(this.author)).setCustodian(new org.hl7.fhir.r5.model.Reference(this.custodian));
    }
}

