/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.client;

import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.rest.gclient.IOperationUnnamed;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.opencds.cqf.fhir.utility.Resources;
import org.opencds.cqf.fhir.utility.client.TerminologyServerClientSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpandRunner
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(ExpandRunner.class);
    private int expansionAttempt = 0;
    private IBaseResource expandedValueSet;
    private final IGenericClient fhirClient;
    private final String valueSetUrl;
    private final IBaseParameters parameters;
    private final TerminologyServerClientSettings terminologyServerClientSettings;
    private final ScheduledExecutorService scheduler;

    public ExpandRunner(IGenericClient client, TerminologyServerClientSettings terminologyServerClientSettings, String valueSetUrl, IBaseParameters parameters) {
        this(client, terminologyServerClientSettings, valueSetUrl, parameters, null);
    }

    public ExpandRunner(IGenericClient fhirClient, TerminologyServerClientSettings terminologyServerClientSettings, String valueSetUrl, IBaseParameters parameters, ScheduledExecutorService scheduler) {
        this.fhirClient = Objects.requireNonNull(fhirClient);
        this.terminologyServerClientSettings = Objects.requireNonNull(terminologyServerClientSettings);
        this.valueSetUrl = Objects.requireNonNull(valueSetUrl);
        this.parameters = parameters;
        this.scheduler = scheduler != null ? scheduler : Executors.newScheduledThreadPool(1);
    }

    public IBaseResource expandValueSet() {
        ScheduledFuture<?> result = this.scheduler.schedule(this, 0L, TimeUnit.SECONDS);
        try {
            result.get();
            if (this.scheduler.awaitTermination(this.terminologyServerClientSettings.getTimeoutSeconds(), TimeUnit.SECONDS)) {
                if (result.isDone() && this.expandedValueSet != null) {
                    return this.expandedValueSet;
                }
                throw new UnprocessableEntityException("Terminology Server expansion failed for ValueSet (%s) - Server could not process expansion requests.".formatted(this.valueSetUrl));
            }
            throw new UnprocessableEntityException("Terminology Server expansion took longer than the allotted timeout: %s".formatted(this.terminologyServerClientSettings.getTimeoutSeconds()));
        }
        catch (Exception e) {
            this.scheduler.shutdown();
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new TerminologyServerExpansionException(e.getMessage());
        }
    }

    @Override
    public void run() {
        try {
            ++this.expansionAttempt;
            if (this.expansionAttempt <= this.terminologyServerClientSettings.getMaxRetryCount()) {
                logger.info("Expansion attempt: {} for ValueSet: {}", (Object)this.expansionAttempt, (Object)this.valueSetUrl);
                this.expandedValueSet = (IBaseResource)((IOperationUnnamed)this.fhirClient.operation().onType("ValueSet")).named("$expand").withParameters(this.parameters).returnResourceType(this.getValueSetClass()).execute();
                this.scheduler.shutdown();
            }
        }
        catch (Exception ex) {
            logger.info("Expansion attempt {} failed: {}", (Object)this.expansionAttempt, (Object)ex.getMessage());
            if (this.expansionAttempt < this.terminologyServerClientSettings.getMaxRetryCount()) {
                this.scheduler.schedule(this, this.terminologyServerClientSettings.getRetryIntervalMillis() * (long)this.expansionAttempt, TimeUnit.MILLISECONDS);
            }
            this.scheduler.shutdown();
        }
    }

    private Class<IBaseResource> getValueSetClass() {
        return Resources.getClassForTypeAndVersion("ValueSet", this.fhirClient.getFhirContext().getVersion().getVersion());
    }

    public static class TerminologyServerExpansionException
    extends BaseServerResponseException {
        private static final int STATUS_CODE = 429;

        public TerminologyServerExpansionException(String message) {
            super(429, message);
        }
    }
}

